/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.identity.xml;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bonitasoft.engine.builder.BuilderFactory;
import org.bonitasoft.engine.commons.transaction.TransactionContentWithResult;
import org.bonitasoft.engine.identity.ExportedUser;
import org.bonitasoft.engine.identity.GroupCreator;
import org.bonitasoft.engine.identity.IdentityService;
import org.bonitasoft.engine.identity.ImportPolicy;
import org.bonitasoft.engine.identity.OrganizationImportException;
import org.bonitasoft.engine.identity.RoleCreator;
import org.bonitasoft.engine.identity.SGroupCreationException;
import org.bonitasoft.engine.identity.SGroupNotFoundException;
import org.bonitasoft.engine.identity.SIdentityException;
import org.bonitasoft.engine.identity.SRoleNotFoundException;
import org.bonitasoft.engine.identity.SUserCreationException;
import org.bonitasoft.engine.identity.SUserMembershipCreationException;
import org.bonitasoft.engine.identity.SUserNotFoundException;
import org.bonitasoft.engine.identity.SUserUpdateException;
import org.bonitasoft.engine.identity.UserMembership;
import org.bonitasoft.engine.identity.model.SContactInfo;
import org.bonitasoft.engine.identity.model.SGroup;
import org.bonitasoft.engine.identity.model.SRole;
import org.bonitasoft.engine.identity.model.SUser;
import org.bonitasoft.engine.identity.model.SUserMembership;
import org.bonitasoft.engine.identity.model.builder.SUserMembershipBuilderFactory;
import org.bonitasoft.engine.identity.model.builder.SUserUpdateBuilder;
import org.bonitasoft.engine.identity.model.builder.SUserUpdateBuilderFactory;
import org.bonitasoft.engine.identity.xml.ImportDuplicateInOrganizationException;
import org.bonitasoft.engine.identity.xml.ImportOrganizationFailOnDuplicatesStrategy;
import org.bonitasoft.engine.identity.xml.ImportOrganizationIgnoreDuplicatesStrategy;
import org.bonitasoft.engine.identity.xml.ImportOrganizationMergeDuplicatesStrategy;
import org.bonitasoft.engine.identity.xml.ImportOrganizationStrategy;
import org.bonitasoft.engine.identity.xml.Organization;
import org.bonitasoft.engine.identity.xml.OrganizationNodeBuilder;
import org.bonitasoft.engine.log.technical.TechnicalLogSeverity;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;
import org.bonitasoft.engine.service.ModelConvertor;
import org.bonitasoft.engine.service.TenantServiceAccessor;
import org.bonitasoft.engine.xml.Parser;

public class ImportOrganization
implements TransactionContentWithResult<List<String>> {
    final IdentityService identityService;
    private final Parser parser;
    private final TechnicalLoggerService logger;
    private final String organizationContent;
    private final List<String> warnings;
    private final ImportOrganizationStrategy strategy;

    public ImportOrganization(TenantServiceAccessor serviceAccessor, String organizationContent, ImportPolicy policy) throws OrganizationImportException {
        this.identityService = serviceAccessor.getIdentityService();
        this.organizationContent = organizationContent;
        this.parser = serviceAccessor.getParserFactgory().createParser(OrganizationNodeBuilder.BINDINGS);
        this.logger = serviceAccessor.getTechnicalLoggerService();
        this.warnings = new ArrayList<String>();
        switch (policy) {
            case FAIL_ON_DUPLICATES: {
                this.strategy = new ImportOrganizationFailOnDuplicatesStrategy();
                break;
            }
            case IGNORE_DUPLICATES: {
                this.strategy = new ImportOrganizationIgnoreDuplicatesStrategy();
                break;
            }
            case MERGE_DUPLICATES: {
                this.strategy = new ImportOrganizationMergeDuplicatesStrategy(this.identityService);
                break;
            }
            default: {
                throw new OrganizationImportException("No import strategy found for " + policy);
            }
        }
    }

    @Override
    public List<String> getResult() {
        return this.warnings;
    }

    @Override
    public void execute() throws ImportDuplicateInOrganizationException {
        try {
            this.parser.setSchema(this.getClass().getResourceAsStream("/bos-organization.xsd"));
            this.parser.validate(new StringReader(this.organizationContent));
            Organization organization = (Organization)this.parser.getObjectFromXML(new StringReader(this.organizationContent));
            List<ExportedUser> users = organization.getUsers();
            List<RoleCreator> roles = organization.getRoles();
            List<GroupCreator> groups = organization.getGroups();
            List<UserMembership> memberships = organization.getMemberships();
            Map<String, SUser> userNameToSUsers = this.importUsers(users);
            this.updateManagerId(users, userNameToSUsers);
            Map<String, Long> roleNameToIdMap = this.importRoles(roles);
            Map<String, Long> groupPathToIdMap = this.importGroups(groups);
            this.importMemberships(memberships, userNameToSUsers, roleNameToIdMap, groupPathToIdMap);
        }
        catch (ImportDuplicateInOrganizationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ImportDuplicateInOrganizationException(e);
        }
    }

    private void importMemberships(List<UserMembership> memberships, Map<String, SUser> userNameToSUsers, Map<String, Long> roleNameToIdMap, Map<String, Long> groupPathToIdMap) throws SIdentityException, ImportDuplicateInOrganizationException {
        for (UserMembership newMembership : memberships) {
            Long userId = this.getUserId(userNameToSUsers, newMembership);
            Long groupId = this.getGroupId(groupPathToIdMap, newMembership);
            Long roleId = this.getRoleId(roleNameToIdMap, newMembership);
            if (userId != null && groupId != null && roleId != null) {
                try {
                    SUserMembership sUserMembership = this.identityService.getUserMembership(userId, groupId, roleId);
                    this.strategy.foundExistingMembership(sUserMembership);
                }
                catch (SIdentityException e) {
                    Long assignedBy = this.getAssignedBy(userNameToSUsers, newMembership);
                    this.addMembership(newMembership, userId, groupId, roleId, assignedBy);
                }
                continue;
            }
            if (!this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.WARNING)) continue;
            this.logger.log(this.getClass(), TechnicalLogSeverity.WARNING, "The membership " + newMembership + " coud not be imported because the user, group or role can't be found\n userId=" + userId + " groupId=" + groupId + " roleId=" + roleId);
        }
    }

    private Long getUserId(Map<String, SUser> userNameToSUsers, UserMembership newMembership) {
        String username = newMembership.getUsername();
        if (username == null || username.isEmpty()) {
            return -1L;
        }
        SUser sUser = userNameToSUsers.get(username);
        if (sUser != null) {
            return sUser.getId();
        }
        return null;
    }

    private Long getGroupId(Map<String, Long> groupPathToIdMap, UserMembership newMembership) {
        String groupParentPath = newMembership.getGroupParentPath();
        String groupFullPath = (groupParentPath == null ? Character.valueOf('/') : groupParentPath + '/') + newMembership.getGroupName();
        return groupPathToIdMap.get(groupFullPath);
    }

    private Long getRoleId(Map<String, Long> roleNameToIdMap, UserMembership newMembership) {
        String roleName = newMembership.getRoleName();
        if (roleName == null || roleName.isEmpty()) {
            return -1L;
        }
        Long roleId = roleNameToIdMap.get(roleName);
        if (roleId != null) {
            return roleId;
        }
        return null;
    }

    private Long getAssignedBy(Map<String, SUser> userNameToSUsers, UserMembership newMembership) {
        String assignedByName = newMembership.getAssignedByName();
        if (assignedByName == null || assignedByName.isEmpty()) {
            return -1L;
        }
        SUser sUserAssigned = userNameToSUsers.get(assignedByName);
        if (sUserAssigned != null) {
            return sUserAssigned.getId();
        }
        return -1L;
    }

    private Map<String, Long> importGroups(List<GroupCreator> groupCreators) throws ImportDuplicateInOrganizationException, SIdentityException {
        HashMap<String, Long> groupPathToIdMap = new HashMap<String, Long>(groupCreators.size());
        for (GroupCreator groupCreator : groupCreators) {
            SGroup sGroup;
            try {
                String groupPath = this.getGroupPath(groupCreator);
                sGroup = this.identityService.getGroupByPath(groupPath);
                this.strategy.foundExistingGroup(sGroup, groupCreator);
            }
            catch (SGroupNotFoundException e) {
                sGroup = this.addGroup(groupCreator);
            }
            groupPathToIdMap.put(sGroup.getPath(), sGroup.getId());
        }
        return groupPathToIdMap;
    }

    private String getGroupPath(GroupCreator creator) {
        Map fields = creator.getFields();
        String name = (String)fields.get(GroupCreator.GroupField.NAME);
        String parentPath = (String)fields.get(GroupCreator.GroupField.PARENT_PATH);
        if (parentPath == null) {
            return "/" + name;
        }
        return parentPath + "/" + name;
    }

    private Map<String, Long> importRoles(List<RoleCreator> roleCreators) throws ImportDuplicateInOrganizationException, SIdentityException {
        HashMap<String, Long> roleNameToIdMap = new HashMap<String, Long>(roleCreators.size());
        for (RoleCreator roleCreator : roleCreators) {
            SRole sRole;
            try {
                sRole = this.identityService.getRoleByName((String)roleCreator.getFields().get(RoleCreator.RoleField.NAME));
                this.strategy.foundExistingRole(sRole, roleCreator);
            }
            catch (SRoleNotFoundException e) {
                sRole = this.addRole(roleCreator);
            }
            roleNameToIdMap.put(sRole.getName(), sRole.getId());
        }
        return roleNameToIdMap;
    }

    private void updateManagerId(List<ExportedUser> users, Map<String, SUser> userNameToSUsers) throws SUserUpdateException {
        for (ExportedUser user : users) {
            String managerUserName = user.getManagerUserName();
            if (managerUserName == null || managerUserName.trim().length() <= 0 || userNameToSUsers.get(managerUserName) == null) continue;
            SUser sUser = userNameToSUsers.get(user.getUserName());
            Long managerId = userNameToSUsers.get(managerUserName).getId();
            if (managerId != null) {
                SUserUpdateBuilder userUpdateBuilder = BuilderFactory.get(SUserUpdateBuilderFactory.class).createNewInstance();
                this.identityService.updateUser(sUser, userUpdateBuilder.updateManagerUserId(managerId).done());
                continue;
            }
            if (!this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.WARNING)) continue;
            this.logger.log(this.getClass(), TechnicalLogSeverity.WARNING, "The user " + user.getUserName() + " has a manager with username " + managerUserName + " but this one does not exist, Please set it manually");
        }
    }

    private Map<String, SUser> importUsers(List<ExportedUser> users) throws ImportDuplicateInOrganizationException, SIdentityException {
        HashMap<String, SUser> userNameToSUsers = new HashMap<String, SUser>((int)Math.min(Integer.MAX_VALUE, this.identityService.getNumberOfUsers()));
        for (ExportedUser user : users) {
            SUser sUser;
            try {
                sUser = this.identityService.getUserByUserName(user.getUserName());
                this.strategy.foundExistingUser(sUser, user);
            }
            catch (SUserNotFoundException e) {
                sUser = this.addUser(user);
            }
            userNameToSUsers.put(sUser.getUserName(), sUser);
        }
        return userNameToSUsers;
    }

    private void addMembership(UserMembership newMembership, Long userId, Long groupId, Long roleId, Long assignedBy) throws SUserMembershipCreationException {
        long assignedDateAsLong = this.getAssignedDate(newMembership);
        SUserMembership sUserMembership = BuilderFactory.get(SUserMembershipBuilderFactory.class).createNewInstance(userId, groupId, roleId).setAssignedBy(assignedBy).setAssignedDate(assignedDateAsLong).done();
        this.identityService.createUserMembership(sUserMembership);
    }

    private long getAssignedDate(UserMembership newMembership) {
        Date assignedDate = newMembership.getAssignedDate();
        if (assignedDate != null) {
            return assignedDate.getTime();
        }
        return 0L;
    }

    private SGroup addGroup(GroupCreator creator) throws SGroupCreationException {
        SGroup sGroup = ModelConvertor.constructSGroup(creator);
        this.identityService.createGroup(sGroup);
        return sGroup;
    }

    private SRole addRole(RoleCreator creator) throws SIdentityException {
        SRole sRole = ModelConvertor.constructSRole(creator);
        this.identityService.createRole(sRole);
        return sRole;
    }

    private SUser addUser(ExportedUser user) throws SUserCreationException {
        SUser sUser = user.isPasswordEncrypted() ? this.identityService.createUserWithoutEncryptingPassword(ModelConvertor.constructSUser(user)) : this.identityService.createUser(ModelConvertor.constructSUser(user));
        SContactInfo persoSContactInfo = ModelConvertor.constructSUserContactInfo(user, true, sUser.getId());
        this.identityService.createUserContactInfo(persoSContactInfo);
        SContactInfo professSContactInfo = ModelConvertor.constructSUserContactInfo(user, false, sUser.getId());
        this.identityService.createUserContactInfo(professSContactInfo);
        return sUser;
    }
}

