/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.identity.xml;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.bonitasoft.engine.identity.ExportedUser;
import org.bonitasoft.engine.identity.Group;
import org.bonitasoft.engine.identity.Role;
import org.bonitasoft.engine.identity.UserMembership;
import org.bonitasoft.engine.identity.xml.GroupBinding;
import org.bonitasoft.engine.identity.xml.MembershipBinding;
import org.bonitasoft.engine.identity.xml.OrganizationBinding;
import org.bonitasoft.engine.identity.xml.PersonalContactDataBinding;
import org.bonitasoft.engine.identity.xml.ProfessionalContactDataBinding;
import org.bonitasoft.engine.identity.xml.RoleBinding;
import org.bonitasoft.engine.identity.xml.UserBinding;
import org.bonitasoft.engine.xml.ElementBinding;
import org.bonitasoft.engine.xml.XMLNode;

public class OrganizationNodeBuilder {
    static final List<Class<? extends ElementBinding>> BINDINGS = new ArrayList<Class<? extends ElementBinding>>();
    private static final String NAMESPACE = "http://www.bonitasoft.org/ns/organization/6.0.0-beta-016";
    private static final String NS_PREFIX = "organization";

    public static XMLNode getDocument(List<ExportedUser> users, Map<Long, String> userNames, List<Group> groups, Map<Long, String> groupIdParentPath, List<Role> roles, List<UserMembership> userMemberships) {
        XMLNode document = OrganizationNodeBuilder.getRootNode();
        XMLNode usersNode = new XMLNode("users");
        document.addChild(usersNode);
        for (ExportedUser user : users) {
            XMLNode userNode = OrganizationNodeBuilder.getUserNode(user);
            usersNode.addChild(userNode);
        }
        XMLNode rolesNodes = new XMLNode("roles");
        document.addChild(rolesNodes);
        for (Role role : roles) {
            XMLNode roleNode = OrganizationNodeBuilder.getRoleNode(role);
            rolesNodes.addChild(roleNode);
        }
        XMLNode groupsNode = new XMLNode("groups");
        document.addChild(groupsNode);
        for (Group group : groups) {
            XMLNode groupNode = OrganizationNodeBuilder.getGroupNode(group);
            groupsNode.addChild(groupNode);
        }
        XMLNode membershipsNode = new XMLNode("memberships");
        document.addChild(membershipsNode);
        for (UserMembership userMembership : userMemberships) {
            XMLNode membershipNode = OrganizationNodeBuilder.getMembershipNode(userNames, groupIdParentPath, userMembership);
            membershipsNode.addChild(membershipNode);
        }
        return document;
    }

    private static XMLNode getMembershipNode(Map<Long, String> userNames, Map<Long, String> groupIdParentPath, UserMembership membership) {
        XMLNode membershipNode = new XMLNode("membership");
        XMLNode node = new XMLNode("userName");
        node.setContent(String.valueOf(membership.getUsername()));
        membershipNode.addChild(node);
        node = new XMLNode("roleName");
        node.setContent(membership.getRoleName());
        membershipNode.addChild(node);
        node = new XMLNode("groupName");
        node.setContent(membership.getGroupName());
        membershipNode.addChild(node);
        node = new XMLNode("groupParentPath");
        node.setContent(groupIdParentPath.get(membership.getGroupId()));
        membershipNode.addChild(node);
        if (membership.getAssignedBy() > 0L) {
            node = new XMLNode("assignedBy");
            node.setContent(userNames.get(membership.getAssignedBy()));
            membershipNode.addChild(node);
        }
        if (membership.getAssignedDate() != null && membership.getAssignedDate().getTime() > 0L) {
            node = new XMLNode("assignedDate");
            node.setContent(String.valueOf(membership.getAssignedDate().getTime()));
            membershipNode.addChild(node);
        }
        return membershipNode;
    }

    private static XMLNode getRoleNode(Role role) {
        XMLNode node;
        XMLNode roleNode = new XMLNode("role");
        if (role.getName() != null) {
            roleNode.addAttribute("name", role.getName());
        }
        if (role.getDisplayName() != null) {
            node = new XMLNode("displayName");
            node.setContent(role.getDisplayName());
            roleNode.addChild(node);
        }
        if (role.getDescription() != null) {
            node = new XMLNode("description");
            node.setContent(role.getDescription());
            roleNode.addChild(node);
        }
        if (role.getIconName() != null) {
            node = new XMLNode("iconName");
            node.setContent(role.getIconName());
            roleNode.addChild(node);
        }
        if (role.getIconPath() != null) {
            node = new XMLNode("iconPath");
            node.setContent(role.getIconPath());
            roleNode.addChild(node);
        }
        return roleNode;
    }

    private static XMLNode getGroupNode(Group group) {
        XMLNode node;
        XMLNode groupNode = new XMLNode("group");
        if (group.getName() != null) {
            groupNode.addAttribute("name", group.getName());
        }
        if (group.getParentPath() != null) {
            groupNode.addAttribute("parentPath", group.getParentPath());
        }
        if (group.getDisplayName() != null) {
            node = new XMLNode("displayName");
            node.setContent(group.getDisplayName());
            groupNode.addChild(node);
        }
        if (group.getDescription() != null) {
            node = new XMLNode("description");
            node.setContent(group.getDescription());
            groupNode.addChild(node);
        }
        if (group.getIconName() != null) {
            node = new XMLNode("iconName");
            node.setContent(group.getIconName());
            groupNode.addChild(node);
        }
        if (group.getIconPath() != null) {
            node = new XMLNode("iconPath");
            node.setContent(group.getIconPath());
            groupNode.addChild(node);
        }
        return groupNode;
    }

    private static XMLNode getUserNode(ExportedUser user) {
        XMLNode node;
        XMLNode userNode = new XMLNode("user");
        userNode.addAttribute("userName", user.getUserName());
        XMLNode nodePassword = new XMLNode("password");
        nodePassword.addAttribute("encrypted", "true");
        nodePassword.setContent(user.getPassword());
        userNode.addChild(nodePassword);
        if (user.getFirstName() != null) {
            node = new XMLNode("firstName");
            node.setContent(user.getFirstName());
            userNode.addChild(node);
        }
        if (user.getLastName() != null) {
            node = new XMLNode("lastName");
            node.setContent(user.getLastName());
            userNode.addChild(node);
        }
        if (user.getIconName() != null) {
            node = new XMLNode("iconName");
            node.setContent(user.getIconName());
            userNode.addChild(node);
        }
        if (user.getIconPath() != null) {
            node = new XMLNode("iconPath");
            node.setContent(user.getIconPath());
            userNode.addChild(node);
        }
        if (user.getTitle() != null) {
            node = new XMLNode("title");
            node.setContent(user.getTitle());
            userNode.addChild(node);
        }
        if (user.getJobTitle() != null) {
            node = new XMLNode("jobTitle");
            node.setContent(user.getJobTitle());
            userNode.addChild(node);
        }
        XMLNode enabledNode = new XMLNode("enabled");
        enabledNode.setContent(user.isEnabled() ? "true" : "false");
        userNode.addChild(enabledNode);
        XMLNode personalDataNode = OrganizationNodeBuilder.getPersonalDataNode(user);
        userNode.addChild(personalDataNode);
        XMLNode professionalDataNode = OrganizationNodeBuilder.getProfessionalDataNode(user);
        userNode.addChild(professionalDataNode);
        if (user.getManagerUserName() != null) {
            XMLNode node2 = new XMLNode("manager");
            node2.setContent(user.getManagerUserName());
            userNode.addChild(node2);
        }
        return userNode;
    }

    private static XMLNode getPersonalDataNode(ExportedUser user) {
        XMLNode contactDataNode = new XMLNode("personalData");
        if (user.getPersonalAddress() != null) {
            contactDataNode.addChild("address", user.getPersonalAddress());
        }
        if (user.getPersonalBuilding() != null) {
            contactDataNode.addChild("building", user.getPersonalBuilding());
        }
        if (user.getPersonalCity() != null) {
            contactDataNode.addChild("city", user.getPersonalCity());
        }
        if (user.getPersonalCountry() != null) {
            contactDataNode.addChild("country", user.getPersonalCountry());
        }
        if (user.getPersonalEmail() != null) {
            contactDataNode.addChild("email", user.getPersonalEmail());
        }
        if (user.getPersonalFaxNumber() != null) {
            contactDataNode.addChild("faxNumber", user.getPersonalFaxNumber());
        }
        if (user.getPersonalMobileNumber() != null) {
            contactDataNode.addChild("mobileNumber", user.getPersonalMobileNumber());
        }
        if (user.getPersonalPhoneNumber() != null) {
            contactDataNode.addChild("phoneNumber", user.getPersonalPhoneNumber());
        }
        if (user.getPersonalRoom() != null) {
            contactDataNode.addChild("room", user.getPersonalRoom());
        }
        if (user.getPersonalState() != null) {
            contactDataNode.addChild("state", user.getPersonalState());
        }
        if (user.getPersonalWebsite() != null) {
            contactDataNode.addChild("website", user.getPersonalWebsite());
        }
        if (user.getPersonalZipCode() != null) {
            contactDataNode.addChild("zipCode", user.getPersonalZipCode());
        }
        return contactDataNode;
    }

    private static XMLNode getProfessionalDataNode(ExportedUser user) {
        XMLNode contactDataNode = new XMLNode("professionalData");
        if (user.getProfessionalAddress() != null) {
            contactDataNode.addChild("address", user.getProfessionalAddress());
        }
        if (user.getProfessionalBuilding() != null) {
            contactDataNode.addChild("building", user.getProfessionalBuilding());
        }
        if (user.getProfessionalCity() != null) {
            contactDataNode.addChild("city", user.getProfessionalCity());
        }
        if (user.getProfessionalCountry() != null) {
            contactDataNode.addChild("country", user.getProfessionalCountry());
        }
        if (user.getProfessionalEmail() != null) {
            contactDataNode.addChild("email", user.getProfessionalEmail());
        }
        if (user.getProfessionalFaxNumber() != null) {
            contactDataNode.addChild("faxNumber", user.getProfessionalFaxNumber());
        }
        if (user.getProfessionalMobileNumber() != null) {
            contactDataNode.addChild("mobileNumber", user.getProfessionalMobileNumber());
        }
        if (user.getProfessionalPhoneNumber() != null) {
            contactDataNode.addChild("phoneNumber", user.getProfessionalPhoneNumber());
        }
        if (user.getProfessionalRoom() != null) {
            contactDataNode.addChild("room", user.getProfessionalRoom());
        }
        if (user.getProfessionalState() != null) {
            contactDataNode.addChild("state", user.getProfessionalState());
        }
        if (user.getProfessionalWebsite() != null) {
            contactDataNode.addChild("website", user.getProfessionalWebsite());
        }
        if (user.getProfessionalZipCode() != null) {
            contactDataNode.addChild("zipCode", user.getProfessionalZipCode());
        }
        return contactDataNode;
    }

    private static XMLNode getRootNode() {
        XMLNode organizationNode = new XMLNode("organization:Organization");
        organizationNode.addAttribute("xmlns:organization", NAMESPACE);
        return organizationNode;
    }

    static {
        BINDINGS.add(OrganizationBinding.class);
        BINDINGS.add(UserBinding.class);
        BINDINGS.add(PersonalContactDataBinding.class);
        BINDINGS.add(ProfessionalContactDataBinding.class);
        BINDINGS.add(RoleBinding.class);
        BINDINGS.add(GroupBinding.class);
        BINDINGS.add(MembershipBinding.class);
    }
}

