/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.jobs;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.bonitasoft.engine.builder.BuilderFactory;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.core.process.instance.api.event.EventInstanceService;
import org.bonitasoft.engine.core.process.instance.api.exceptions.event.trigger.SMessageInstanceNotFoundException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.event.trigger.SMessageInstanceReadException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.event.trigger.SMessageModificationException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.event.trigger.SWaitingEventModificationException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.event.trigger.SWaitingEventNotFoundException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.event.trigger.SWaitingEventReadException;
import org.bonitasoft.engine.core.process.instance.model.builder.event.handling.SMessageInstanceBuilderFactory;
import org.bonitasoft.engine.core.process.instance.model.builder.event.handling.SWaitingMessageEventBuilderFactory;
import org.bonitasoft.engine.core.process.instance.model.event.handling.SBPMEventType;
import org.bonitasoft.engine.core.process.instance.model.event.handling.SMessageEventCouple;
import org.bonitasoft.engine.core.process.instance.model.event.handling.SMessageInstance;
import org.bonitasoft.engine.core.process.instance.model.event.handling.SWaitingMessageEvent;
import org.bonitasoft.engine.execution.work.WorkFactory;
import org.bonitasoft.engine.jobs.InternalJob;
import org.bonitasoft.engine.recorder.model.EntityUpdateDescriptor;
import org.bonitasoft.engine.scheduler.exception.SJobConfigurationException;
import org.bonitasoft.engine.scheduler.exception.SJobExecutionException;
import org.bonitasoft.engine.work.WorkService;

public class BPMEventHandlingJob
extends InternalJob
implements Serializable {
    private static final List<SBPMEventType> START_WAITING_MESSAGE_LIST = Arrays.asList(SBPMEventType.START_EVENT);
    private static final long serialVersionUID = 8929044925208984537L;
    private transient EventInstanceService eventInstanceService;
    private WorkService workService;

    @Override
    public String getName() {
        return "BPMEventHandlingJob";
    }

    @Override
    public String getDescription() {
        return "Handle BPM events";
    }

    @Override
    public void execute() throws SJobExecutionException {
        try {
            List<SMessageEventCouple> potentialMessageCouples = this.eventInstanceService.getMessageEventCouples();
            List<SMessageEventCouple> uniqueCouples = this.makeMessageUniqueCouples(potentialMessageCouples);
            for (SMessageEventCouple couple : uniqueCouples) {
                long messageInstanceId = couple.getMessageInstanceId();
                long waitingMessageId = couple.getWaitingMessageId();
                SBPMEventType waitingMessageEventType = couple.getWaitingMessageEventType();
                this.markMessageAsInProgress(messageInstanceId);
                if (!START_WAITING_MESSAGE_LIST.contains((Object)waitingMessageEventType)) {
                    this.markWaitingMessageAsInProgress(waitingMessageId);
                }
                this.workService.registerWork(WorkFactory.createExecuteMessageCoupleWork(messageInstanceId, waitingMessageId));
            }
        }
        catch (SBonitaException e) {
            throw new SJobExecutionException(e);
        }
    }

    protected List<SMessageEventCouple> makeMessageUniqueCouples(List<SMessageEventCouple> messageCouples) {
        ArrayList<Long> takenMessages = new ArrayList<Long>(messageCouples.size());
        ArrayList<Long> takenWaitings = new ArrayList<Long>(messageCouples.size());
        ArrayList<SMessageEventCouple> pairs = new ArrayList<SMessageEventCouple>();
        for (SMessageEventCouple couple : messageCouples) {
            long messageInstanceId = couple.getMessageInstanceId();
            long waitingMessageId = couple.getWaitingMessageId();
            SBPMEventType waitingMessageEventType = couple.getWaitingMessageEventType();
            if (takenMessages.contains(messageInstanceId) || takenWaitings.contains(waitingMessageId)) continue;
            takenMessages.add(messageInstanceId);
            if (!START_WAITING_MESSAGE_LIST.contains((Object)waitingMessageEventType)) {
                takenWaitings.add(waitingMessageId);
            }
            pairs.add(couple);
        }
        return pairs;
    }

    @Override
    public void setAttributes(Map<String, Serializable> attributes) throws SJobConfigurationException {
        this.eventInstanceService = this.getTenantServiceAccessor().getEventInstanceService();
        this.workService = this.getTenantServiceAccessor().getWorkService();
    }

    private void markMessageAsInProgress(long messageInstanceIdToUpdate) throws SMessageModificationException, SMessageInstanceNotFoundException, SMessageInstanceReadException {
        SMessageInstance messageInstance = this.eventInstanceService.getMessageInstance(messageInstanceIdToUpdate);
        EntityUpdateDescriptor descriptor = new EntityUpdateDescriptor();
        descriptor.addField(BuilderFactory.get(SMessageInstanceBuilderFactory.class).getHandledKey(), true);
        this.eventInstanceService.updateMessageInstance(messageInstance, descriptor);
    }

    private void markWaitingMessageAsInProgress(long waitingMessageInstanceIdToUpdate) throws SWaitingEventModificationException, SWaitingEventNotFoundException, SWaitingEventReadException {
        SWaitingMessageEvent waitingMsg = this.eventInstanceService.getWaitingMessage(waitingMessageInstanceIdToUpdate);
        EntityUpdateDescriptor descriptor = new EntityUpdateDescriptor();
        descriptor.addField(BuilderFactory.get(SWaitingMessageEventBuilderFactory.class).getProgressKey(), 1);
        this.eventInstanceService.updateWaitingMessage(waitingMsg, descriptor);
    }
}

