/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.operation;

import org.bonitasoft.engine.bpm.document.DocumentValue;
import org.bonitasoft.engine.builder.BuilderFactory;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.core.expression.control.model.SExpressionContext;
import org.bonitasoft.engine.core.operation.OperationExecutorStrategy;
import org.bonitasoft.engine.core.operation.exception.SOperationExecutionException;
import org.bonitasoft.engine.core.operation.model.SLeftOperand;
import org.bonitasoft.engine.core.operation.model.SOperation;
import org.bonitasoft.engine.core.process.document.api.ProcessDocumentService;
import org.bonitasoft.engine.core.process.document.model.SProcessDocument;
import org.bonitasoft.engine.core.process.document.model.builder.SProcessDocumentBuilder;
import org.bonitasoft.engine.core.process.document.model.builder.SProcessDocumentBuilderFactory;
import org.bonitasoft.engine.core.process.instance.api.ActivityInstanceService;
import org.bonitasoft.engine.core.process.instance.model.SFlowNodeInstance;
import org.bonitasoft.engine.data.instance.api.DataInstanceContainer;
import org.bonitasoft.engine.document.SDocumentNotFoundException;
import org.bonitasoft.engine.session.SessionService;
import org.bonitasoft.engine.sessionaccessor.SessionAccessor;
import org.bonitasoft.engine.sessionaccessor.SessionIdNotSetException;

public class DocumentOperationExecutorStrategy
implements OperationExecutorStrategy {
    private static final String TYPE_DOCUMENT_CREATE_UPDATE = "DOCUMENT_CREATE_UPDATE";
    ProcessDocumentService processDocumentService;
    private final ActivityInstanceService activityInstanceService;
    private final SessionAccessor sessionAccessor;
    private final SessionService sessionService;

    public DocumentOperationExecutorStrategy(ProcessDocumentService processDocumentService, ActivityInstanceService activityInstanceService, SessionAccessor sessionAccessor, SessionService sessionService) {
        this.processDocumentService = processDocumentService;
        this.activityInstanceService = activityInstanceService;
        this.sessionAccessor = sessionAccessor;
        this.sessionService = sessionService;
    }

    @Override
    public Object getValue(SOperation operation, Object value, long containerId, String containerType, SExpressionContext expressionContext) {
        return value;
    }

    @Override
    public String getOperationType() {
        return TYPE_DOCUMENT_CREATE_UPDATE;
    }

    @Override
    public void update(SLeftOperand sLeftOperand, Object newValue, long containerId, String containerType) throws SOperationExecutionException {
        block14: {
            boolean isDocumentWithContent = newValue instanceof DocumentValue;
            if (!isDocumentWithContent && newValue != null) {
                throw new SOperationExecutionException("Document operation only accepts an expression returning a DocumentValue and not " + newValue.getClass().getName());
            }
            String documentName = sLeftOperand.getName();
            try {
                long authorId;
                long processInstanceId;
                if (DataInstanceContainer.PROCESS_INSTANCE.name().equals(containerType)) {
                    processInstanceId = containerId;
                } else {
                    SFlowNodeInstance flowNodeInstance = this.activityInstanceService.getFlowNodeInstance(containerId);
                    processInstanceId = flowNodeInstance.getParentProcessInstanceId();
                }
                if (newValue == null) {
                    try {
                        this.processDocumentService.removeCurrentVersion(processInstanceId, documentName);
                    }
                    catch (SDocumentNotFoundException e) {}
                    break block14;
                }
                try {
                    long sessionId = this.sessionAccessor.getSessionId();
                    authorId = this.sessionService.getSession(sessionId).getUserId();
                }
                catch (SessionIdNotSetException e) {
                    authorId = -1L;
                }
                DocumentValue documentValue = (DocumentValue)newValue;
                boolean hasContent = documentValue.hasContent();
                try {
                    this.processDocumentService.getDocument(processInstanceId, documentName);
                    SProcessDocument document = this.createDocument(documentName, processInstanceId, authorId, documentValue, hasContent, documentValue.getUrl());
                    if (hasContent) {
                        this.processDocumentService.updateDocumentOfProcessInstance(document, documentValue.getContent());
                        break block14;
                    }
                    this.processDocumentService.updateDocumentOfProcessInstance(document);
                }
                catch (SDocumentNotFoundException e) {
                    SProcessDocument document = this.createDocument(documentName, processInstanceId, authorId, documentValue, hasContent, documentValue.getUrl());
                    if (hasContent) {
                        this.processDocumentService.attachDocumentToProcessInstance(document, documentValue.getContent());
                        break block14;
                    }
                    this.processDocumentService.attachDocumentToProcessInstance(document);
                }
            }
            catch (SBonitaException e) {
                throw new SOperationExecutionException(e);
            }
        }
    }

    private SProcessDocument createDocument(String documentName, long processInstanceId, long authorId, DocumentValue documentValue, boolean hasContent, String documentUrl) {
        SProcessDocumentBuilder processDocumentBuilder = BuilderFactory.get(SProcessDocumentBuilderFactory.class).createNewInstance();
        processDocumentBuilder.setName(documentName);
        processDocumentBuilder.setFileName(documentValue.getFileName());
        processDocumentBuilder.setContentMimeType(documentValue.getMimeType());
        processDocumentBuilder.setProcessInstanceId(processInstanceId);
        processDocumentBuilder.setAuthor(authorId);
        processDocumentBuilder.setCreationDate(System.currentTimeMillis());
        processDocumentBuilder.setHasContent(hasContent);
        processDocumentBuilder.setURL(documentUrl);
        SProcessDocument document = processDocumentBuilder.done();
        return document;
    }

    @Override
    public boolean doUpdateData() {
        return false;
    }
}

