/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.persistence;

import java.lang.reflect.Method;
import org.hibernate.HibernateException;
import org.hibernate.transaction.JNDITransactionManagerLookup;

public class BTMJNDITransactionManagerLookup
extends JNDITransactionManagerLookup {
    public String getUserTransactionName() {
        return this.getInternalName();
    }

    protected String getName() {
        return this.getInternalName();
    }

    private String getInternalName() {
        try {
            Class<?> transactionManagerServiceClass = Class.forName("bitronix.tm.TransactionManagerServices");
            Method getConfigurationMethod = transactionManagerServiceClass.getMethod("getConfiguration", new Class[0]);
            Object configurationInstance = getConfigurationMethod.invoke((Object)null, new Object[0]);
            Class<?> bitronixConfigurationClass = configurationInstance.getClass();
            Method getJndiUserTransactionNameMethod = bitronixConfigurationClass.getMethod("getJndiUserTransactionName", new Class[0]);
            String configuredJndiUserTransactionName = (String)getJndiUserTransactionNameMethod.invoke(configurationInstance, new Object[0]);
            if (configuredJndiUserTransactionName != null && configuredJndiUserTransactionName.trim().length() >= 0) {
                return configuredJndiUserTransactionName;
            }
            return "java:comp/UserTransaction";
        }
        catch (Exception e) {
            throw new HibernateException("Could not obtain BTM UserTransactionName", (Throwable)e);
        }
    }
}

