/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.persistence;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bonitasoft.engine.persistence.FilterOption;
import org.bonitasoft.engine.persistence.OrderByOption;
import org.bonitasoft.engine.persistence.OrderByType;
import org.bonitasoft.engine.persistence.PersistentObject;
import org.bonitasoft.engine.persistence.SearchFields;

public class QueryOptions
implements Serializable {
    private static final long serialVersionUID = 8923754215920928153L;
    private final int fromIndex;
    private final int numberOfResults;
    private final List<FilterOption> filters;
    private final SearchFields multipleFilter;
    private final List<OrderByOption> orderByOptions;
    public static final int UNLIMITED_NUMBER_OF_RESULTS = Integer.MAX_VALUE;
    public static final int DEFAULT_NUMBER_OF_RESULTS = 20;
    private static final QueryOptions DEFAULT_QUERY_OPTIONS = new QueryOptions(0, 20);
    private static final QueryOptions ALL_RESULTS_QUERY_OPTIONS = new QueryOptions(0, Integer.MAX_VALUE);

    public QueryOptions(QueryOptions queryOptions) {
        this.fromIndex = queryOptions.getFromIndex();
        this.numberOfResults = queryOptions.getNumberOfResults();
        this.orderByOptions = queryOptions.getOrderByOptions();
        this.filters = queryOptions.getFilters();
        this.multipleFilter = queryOptions.getMultipleFilter();
    }

    public QueryOptions(int fromIndex, int numberOfResults, List<OrderByOption> orderByOptions) {
        this.fromIndex = fromIndex;
        this.numberOfResults = numberOfResults;
        this.orderByOptions = orderByOptions;
        this.filters = Collections.emptyList();
        this.multipleFilter = null;
    }

    public QueryOptions(int fromIndex, int numberOfResults, List<OrderByOption> orderByOptions, List<FilterOption> filters, SearchFields multipleFilter) {
        this.fromIndex = fromIndex;
        this.numberOfResults = numberOfResults;
        this.orderByOptions = orderByOptions;
        this.filters = filters;
        this.multipleFilter = multipleFilter;
    }

    public QueryOptions(List<FilterOption> filters, SearchFields multipleFilter) {
        this(0, 20, Collections.emptyList(), filters, multipleFilter);
    }

    public QueryOptions(int fromIndex, int numberOfResults, Class<? extends PersistentObject> clazz, String fieldName, OrderByType orderByType) {
        this.fromIndex = fromIndex;
        this.numberOfResults = numberOfResults;
        if (fieldName == null || orderByType == null) {
            this.orderByOptions = Collections.emptyList();
        } else {
            this.orderByOptions = new ArrayList<OrderByOption>();
            this.orderByOptions.add(new OrderByOption(clazz, fieldName, orderByType));
        }
        this.filters = Collections.emptyList();
        this.multipleFilter = null;
    }

    public QueryOptions(List<OrderByOption> orderByOptions) {
        this.fromIndex = 0;
        this.numberOfResults = 20;
        this.orderByOptions = orderByOptions;
        this.filters = Collections.emptyList();
        this.multipleFilter = null;
    }

    public QueryOptions(Class<? extends PersistentObject> clazz, String fieldName, OrderByType orderByType) {
        this.fromIndex = 0;
        this.numberOfResults = 20;
        this.orderByOptions = new ArrayList<OrderByOption>();
        this.orderByOptions.add(new OrderByOption(clazz, fieldName, orderByType));
        this.filters = Collections.emptyList();
        this.multipleFilter = null;
    }

    public QueryOptions(int fromIndex, int numberOfResults) {
        this.fromIndex = fromIndex;
        this.numberOfResults = numberOfResults;
        this.orderByOptions = Collections.emptyList();
        this.filters = Collections.emptyList();
        this.multipleFilter = null;
    }

    public int getFromIndex() {
        return this.fromIndex;
    }

    public int getNumberOfResults() {
        return this.numberOfResults;
    }

    public List<FilterOption> getFilters() {
        return this.filters;
    }

    public SearchFields getMultipleFilter() {
        return this.multipleFilter;
    }

    public List<OrderByOption> getOrderByOptions() {
        return this.orderByOptions;
    }

    public boolean hasOrderByOptions() {
        return this.orderByOptions != null && !this.orderByOptions.isEmpty();
    }

    public static QueryOptions defaultQueryOptions() {
        return DEFAULT_QUERY_OPTIONS;
    }

    public static QueryOptions allResultsQueryOptions() {
        return ALL_RESULTS_QUERY_OPTIONS;
    }

    public static QueryOptions getNextPage(QueryOptions queryOptions) {
        return new QueryOptions(queryOptions.getFromIndex() + queryOptions.getNumberOfResults(), queryOptions.getNumberOfResults(), queryOptions.getOrderByOptions());
    }

    public String toString() {
        return "QueryOptions [fromIndex=" + this.fromIndex + ", numberOfResults=" + this.numberOfResults + ", orderByOptions=" + this.orderByOptions + "]";
    }

    public boolean hasAFilter() {
        return this.filters != null && !this.filters.isEmpty() || this.multipleFilter != null;
    }
}

