/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.profile.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.bonitasoft.engine.builder.BuilderFactory;
import org.bonitasoft.engine.commons.LogUtil;
import org.bonitasoft.engine.commons.NullCheckingUtil;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.events.EventActionType;
import org.bonitasoft.engine.events.EventService;
import org.bonitasoft.engine.events.model.SDeleteEvent;
import org.bonitasoft.engine.events.model.SInsertEvent;
import org.bonitasoft.engine.events.model.SUpdateEvent;
import org.bonitasoft.engine.events.model.builders.SEventBuilderFactory;
import org.bonitasoft.engine.log.technical.TechnicalLogSeverity;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;
import org.bonitasoft.engine.persistence.OrderByType;
import org.bonitasoft.engine.persistence.PersistentObject;
import org.bonitasoft.engine.persistence.QueryOptions;
import org.bonitasoft.engine.persistence.ReadPersistenceService;
import org.bonitasoft.engine.persistence.SBonitaReadException;
import org.bonitasoft.engine.persistence.SBonitaSearchException;
import org.bonitasoft.engine.persistence.SelectByIdDescriptor;
import org.bonitasoft.engine.persistence.SelectListDescriptor;
import org.bonitasoft.engine.persistence.SelectOneDescriptor;
import org.bonitasoft.engine.profile.ProfileService;
import org.bonitasoft.engine.profile.builder.SProfileBuilderFactory;
import org.bonitasoft.engine.profile.builder.SProfileEntryBuilderFactory;
import org.bonitasoft.engine.profile.builder.impl.SProfileLogBuilderImpl;
import org.bonitasoft.engine.profile.builder.impl.SProfileMemberLogBuilderImpl;
import org.bonitasoft.engine.profile.exception.profile.SProfileCreationException;
import org.bonitasoft.engine.profile.exception.profile.SProfileDeletionException;
import org.bonitasoft.engine.profile.exception.profile.SProfileNotFoundException;
import org.bonitasoft.engine.profile.exception.profile.SProfileReadException;
import org.bonitasoft.engine.profile.exception.profile.SProfileUpdateException;
import org.bonitasoft.engine.profile.exception.profileentry.SProfileEntryCreationException;
import org.bonitasoft.engine.profile.exception.profileentry.SProfileEntryDeletionException;
import org.bonitasoft.engine.profile.exception.profileentry.SProfileEntryNotFoundException;
import org.bonitasoft.engine.profile.exception.profileentry.SProfileEntryReadException;
import org.bonitasoft.engine.profile.exception.profileentry.SProfileEntryUpdateException;
import org.bonitasoft.engine.profile.exception.profilemember.SProfileMemberCreationException;
import org.bonitasoft.engine.profile.exception.profilemember.SProfileMemberDeletionException;
import org.bonitasoft.engine.profile.exception.profilemember.SProfileMemberNotFoundException;
import org.bonitasoft.engine.profile.exception.profilemember.SProfileMemberReadException;
import org.bonitasoft.engine.profile.model.SProfile;
import org.bonitasoft.engine.profile.model.SProfileEntry;
import org.bonitasoft.engine.profile.model.SProfileMember;
import org.bonitasoft.engine.profile.model.impl.SProfileMemberImpl;
import org.bonitasoft.engine.profile.persistence.SelectDescriptorBuilder;
import org.bonitasoft.engine.queriablelogger.model.SQueriableLog;
import org.bonitasoft.engine.queriablelogger.model.SQueriableLogSeverity;
import org.bonitasoft.engine.queriablelogger.model.builder.ActionType;
import org.bonitasoft.engine.queriablelogger.model.builder.HasCRUDEAction;
import org.bonitasoft.engine.queriablelogger.model.builder.SLogBuilder;
import org.bonitasoft.engine.queriablelogger.model.builder.SPersistenceLogBuilder;
import org.bonitasoft.engine.recorder.Recorder;
import org.bonitasoft.engine.recorder.SRecorderException;
import org.bonitasoft.engine.recorder.model.DeleteAllRecord;
import org.bonitasoft.engine.recorder.model.DeleteRecord;
import org.bonitasoft.engine.recorder.model.EntityUpdateDescriptor;
import org.bonitasoft.engine.recorder.model.InsertRecord;
import org.bonitasoft.engine.recorder.model.UpdateRecord;
import org.bonitasoft.engine.services.QueriableLoggerService;

public class ProfileServiceImpl
implements ProfileService {
    private static final int BATCH_NUMBER = 1000;
    private final ReadPersistenceService persistenceService;
    private final Recorder recorder;
    private final EventService eventService;
    private final TechnicalLoggerService logger;
    private final QueriableLoggerService queriableLoggerService;

    public ProfileServiceImpl(ReadPersistenceService persistenceService, Recorder recorder, EventService eventService, TechnicalLoggerService logger, QueriableLoggerService queriableLoggerService) {
        this.persistenceService = persistenceService;
        this.recorder = recorder;
        this.eventService = eventService;
        this.logger = logger;
        this.queriableLoggerService = queriableLoggerService;
    }

    @Override
    public SProfile createProfile(SProfile profile) throws SProfileCreationException {
        this.logBeforeMethod("createProfile");
        SProfileLogBuilderImpl logBuilder = this.getSProfileLog(ActionType.CREATED, "Adding a new profile");
        InsertRecord insertRecord = new InsertRecord(profile);
        SInsertEvent insertEvent = null;
        if (this.eventService.hasHandlers("PROFILE", EventActionType.CREATED)) {
            insertEvent = (SInsertEvent)BuilderFactory.get(SEventBuilderFactory.class).createInsertEvent("PROFILE").setObject(profile).done();
        }
        try {
            this.recorder.recordInsert(insertRecord, insertEvent);
            this.initiateLogBuilder(profile.getId(), 1, logBuilder, "createProfile");
            this.logAfterMethod("createProfile");
            return profile;
        }
        catch (SRecorderException re) {
            this.logOnExceptionMethod("createProfile", re);
            this.initiateLogBuilder(profile.getId(), 0, logBuilder, "createProfile");
            throw new SProfileCreationException(re);
        }
    }

    @Override
    public SProfile getProfile(long profileId) throws SProfileNotFoundException {
        this.logBeforeMethod("getProfile");
        try {
            SelectByIdDescriptor<SProfile> descriptor = SelectDescriptorBuilder.getElementById(SProfile.class, "Profile", profileId);
            SProfile profile = this.persistenceService.selectById(descriptor);
            if (profile == null) {
                throw new SProfileNotFoundException("No profile exists with id: " + profileId);
            }
            this.logAfterMethod("getProfile");
            return profile;
        }
        catch (SBonitaReadException e) {
            this.logOnExceptionMethod("getProfile", e);
            throw new SProfileNotFoundException(e);
        }
    }

    @Override
    public SProfile getProfileByName(String profileName) throws SProfileNotFoundException {
        this.logBeforeMethod("getProfileByName");
        try {
            SelectOneDescriptor<SProfile> descriptor = SelectDescriptorBuilder.getElementByNameDescriptor(SProfile.class, "Profile", profileName);
            SProfile profile = this.persistenceService.selectOne(descriptor);
            if (profile == null) {
                throw new SProfileNotFoundException("No profile exists with name: " + profileName);
            }
            this.logAfterMethod("getProfileByName");
            return profile;
        }
        catch (SBonitaReadException e) {
            this.logOnExceptionMethod("getProfileByName", e);
            throw new SProfileNotFoundException(e);
        }
    }

    @Override
    public List<SProfile> getProfiles(List<Long> profileIds) throws SProfileNotFoundException {
        this.logBeforeMethod("getProfiles");
        ArrayList<SProfile> profiles = new ArrayList<SProfile>();
        if (profileIds != null) {
            for (Long profileId : profileIds) {
                SProfile profile = this.getProfile(profileId);
                profiles.add(profile);
            }
        }
        this.logAfterMethod("getProfiles");
        return profiles;
    }

    @Override
    public SProfile updateProfile(SProfile sProfile, EntityUpdateDescriptor descriptor) throws SProfileUpdateException {
        this.logBeforeMethod("updateProfile");
        NullCheckingUtil.checkArgsNotNull(sProfile);
        SProfileLogBuilderImpl logBuilder = this.getSProfileLog(ActionType.UPDATED, "Updating profile");
        SProfile oldUser = BuilderFactory.get(SProfileBuilderFactory.class).createNewInstance(sProfile).done();
        UpdateRecord updateRecord = UpdateRecord.buildSetFields((PersistentObject)sProfile, descriptor);
        SUpdateEvent updateEvent = null;
        if (this.eventService.hasHandlers("PROFILE", EventActionType.UPDATED)) {
            updateEvent = (SUpdateEvent)BuilderFactory.get(SEventBuilderFactory.class).createUpdateEvent("PROFILE").setObject(sProfile).done();
            updateEvent.setOldObject(oldUser);
        }
        try {
            this.recorder.recordUpdate(updateRecord, updateEvent);
            this.initiateLogBuilder(sProfile.getId(), 1, logBuilder, "updateProfile");
            this.logAfterMethod("updateProfile");
        }
        catch (SRecorderException re) {
            this.logOnExceptionMethod("updateProfile", re);
            this.initiateLogBuilder(sProfile.getId(), 0, logBuilder, "updateProfile");
            throw new SProfileUpdateException(re);
        }
        return sProfile;
    }

    @Override
    public void deleteProfile(SProfile profile) throws SProfileDeletionException {
        this.logBeforeMethod("deleteProfile");
        SProfileLogBuilderImpl logBuilder = this.getSProfileLog(ActionType.DELETED, "Deleting profile");
        DeleteRecord deleteRecord = new DeleteRecord(profile);
        SDeleteEvent deleteEvent = null;
        if (this.eventService.hasHandlers("PROFILE", EventActionType.DELETED)) {
            deleteEvent = (SDeleteEvent)BuilderFactory.get(SEventBuilderFactory.class).createDeleteEvent("PROFILE").setObject(profile).done();
        }
        try {
            this.deleteAllProfileEntriesOfProfile(profile);
            this.deleteAllProfileMembersOfProfile(profile);
            this.recorder.recordDelete(deleteRecord, deleteEvent);
            this.initiateLogBuilder(profile.getId(), 1, logBuilder, "deleteProfile");
            this.logAfterMethod("deleteProfile");
        }
        catch (SRecorderException re) {
            this.logOnExceptionMethod("deleteProfile", re);
            this.initiateLogBuilder(profile.getId(), 0, logBuilder, "deleteProfile");
            throw new SProfileDeletionException(re);
        }
        catch (SProfileEntryDeletionException e) {
            this.logOnExceptionMethod("deleteProfile", e);
            throw new SProfileDeletionException(e);
        }
        catch (SProfileMemberDeletionException e) {
            this.logOnExceptionMethod("deleteProfile", e);
            throw new SProfileDeletionException(e);
        }
    }

    private void deleteAllProfileMembersOfProfile(SProfile profile) throws SProfileMemberDeletionException {
        try {
            List<SProfileMember> sProfileMembers;
            do {
                sProfileMembers = this.getSProfileMembers(profile.getId());
                for (SProfileMember profileUser : sProfileMembers) {
                    this.deleteProfileMember(profileUser);
                }
            } while (!sProfileMembers.isEmpty());
        }
        catch (SProfileMemberNotFoundException e) {
            throw new SProfileMemberDeletionException(e);
        }
    }

    private void deleteAllProfileEntriesOfProfile(SProfile profile) throws SProfileEntryDeletionException {
        try {
            List<SProfileEntry> entries;
            do {
                entries = this.getEntriesOfProfile(profile.getId(), 0, 1000, "id", OrderByType.ASC);
                for (SProfileEntry entry : entries) {
                    this.deleteProfileEntry(entry);
                }
            } while (!entries.isEmpty());
        }
        catch (SProfileEntryReadException e) {
            throw new SProfileEntryDeletionException(e);
        }
    }

    @Override
    public void deleteProfile(long profileId) throws SProfileNotFoundException, SProfileDeletionException {
        this.logBeforeMethod("deleteProfile");
        SProfile profile = this.getProfile(profileId);
        this.deleteProfile(profile);
        this.logAfterMethod("deleteProfile");
    }

    @Override
    public SProfileEntry getProfileEntry(long profileEntryId) throws SProfileEntryNotFoundException {
        this.logBeforeMethod("getProfileEntry");
        try {
            SelectByIdDescriptor<SProfileEntry> descriptor = SelectDescriptorBuilder.getElementById(SProfileEntry.class, "ProfileEntry", profileEntryId);
            SProfileEntry profileEntry = this.persistenceService.selectById(descriptor);
            if (profileEntry == null) {
                throw new SProfileEntryNotFoundException("No entry exists with id: " + profileEntryId);
            }
            this.logAfterMethod("getProfileEntry");
            return profileEntry;
        }
        catch (SBonitaReadException bre) {
            this.logOnExceptionMethod("getProfileEntry", bre);
            throw new SProfileEntryNotFoundException(bre);
        }
    }

    @Override
    public List<SProfileEntry> getEntriesOfProfile(long profileId, int fromIndex, int numberOfProfileEntries, String field, OrderByType order) throws SProfileEntryReadException {
        this.logBeforeMethod("getEntriesOfProfile");
        try {
            List<SProfileEntry> listspEntries = this.persistenceService.selectList(SelectDescriptorBuilder.getEntriesOfProfile(profileId, field, order, fromIndex, numberOfProfileEntries));
            this.logAfterMethod("getEntriesOfProfile");
            return listspEntries;
        }
        catch (SBonitaReadException bre) {
            this.logOnExceptionMethod("getEntriesOfProfile", bre);
            throw new SProfileEntryReadException(bre);
        }
    }

    @Override
    public List<SProfileEntry> getEntriesOfProfileByParentId(long profileId, long parentId, int fromIndex, int numberOfProfileEntries, String field, OrderByType order) throws SProfileEntryReadException {
        this.logBeforeMethod("getEntriesOfProfileByParentId");
        try {
            List<SProfileEntry> listspEntries = this.persistenceService.selectList(SelectDescriptorBuilder.getEntriesOfProfile(profileId, parentId, field, order, fromIndex, numberOfProfileEntries));
            this.logAfterMethod("getEntriesOfProfileByParentId");
            return listspEntries;
        }
        catch (SBonitaReadException bre) {
            this.logOnExceptionMethod("getEntriesOfProfileByParentId", bre);
            throw new SProfileEntryReadException(bre);
        }
    }

    @Override
    public SProfileEntry createProfileEntry(SProfileEntry profileEntry) throws SProfileEntryCreationException {
        this.logBeforeMethod("createProfileEntry");
        SProfileLogBuilderImpl logBuilder = this.getSProfileLog(ActionType.CREATED, "Adding a new pofile entry");
        InsertRecord insertRecord = new InsertRecord(profileEntry);
        SInsertEvent insertEvent = null;
        if (this.eventService.hasHandlers("PROFILE", EventActionType.CREATED)) {
            insertEvent = (SInsertEvent)BuilderFactory.get(SEventBuilderFactory.class).createInsertEvent("ENTRY_PROFILE").setObject(profileEntry).done();
        }
        try {
            this.recorder.recordInsert(insertRecord, insertEvent);
            this.initiateLogBuilder(profileEntry.getId(), 1, logBuilder, "createProfileEntry");
            this.logAfterMethod("createProfileEntry");
            return profileEntry;
        }
        catch (SRecorderException re) {
            this.logOnExceptionMethod("createProfileEntry", re);
            this.initiateLogBuilder(profileEntry.getId(), 0, logBuilder, "createProfileEntry");
            throw new SProfileEntryCreationException(re);
        }
    }

    @Override
    public SProfileEntry updateProfileEntry(SProfileEntry profileEntry, EntityUpdateDescriptor descriptor) throws SProfileEntryUpdateException {
        this.logBeforeMethod("updateProfileEntry");
        NullCheckingUtil.checkArgsNotNull(profileEntry);
        SProfileLogBuilderImpl logBuilder = this.getSProfileLog(ActionType.UPDATED, "Updating profile entry");
        try {
            SProfileEntry oldProfileEntry = BuilderFactory.get(SProfileEntryBuilderFactory.class).createNewInstance(profileEntry).done();
            UpdateRecord updateRecord = UpdateRecord.buildSetFields((PersistentObject)profileEntry, descriptor);
            SUpdateEvent updateEvent = null;
            if (this.eventService.hasHandlers("ENTRY_PROFILE", EventActionType.UPDATED)) {
                updateEvent = (SUpdateEvent)BuilderFactory.get(SEventBuilderFactory.class).createUpdateEvent("ENTRY_PROFILE").setObject(profileEntry).done();
                updateEvent.setOldObject(oldProfileEntry);
            }
            this.recorder.recordUpdate(updateRecord, updateEvent);
            this.initiateLogBuilder(profileEntry.getId(), 1, logBuilder, "updateProfileEntry");
            this.logAfterMethod("updateProfileEntry");
        }
        catch (SRecorderException re) {
            this.logOnExceptionMethod("updateProfileEntry", re);
            this.initiateLogBuilder(profileEntry.getId(), 0, logBuilder, "updateProfileEntry");
            throw new SProfileEntryUpdateException(re);
        }
        return profileEntry;
    }

    @Override
    public void deleteProfileEntry(SProfileEntry profileEntry) throws SProfileEntryDeletionException {
        this.logBeforeMethod("deleteProfileEntry");
        SProfileLogBuilderImpl logBuilder = this.getSProfileLog(ActionType.DELETED, "Deleting profile entry");
        try {
            DeleteRecord deleteRecord = new DeleteRecord(profileEntry);
            SDeleteEvent deleteEvent = null;
            if (this.eventService.hasHandlers("ENTRY_PROFILE", EventActionType.DELETED)) {
                deleteEvent = (SDeleteEvent)BuilderFactory.get(SEventBuilderFactory.class).createDeleteEvent("ENTRY_PROFILE").setObject(profileEntry).done();
            }
            this.recorder.recordDelete(deleteRecord, deleteEvent);
            this.initiateLogBuilder(profileEntry.getId(), 1, logBuilder, "deleteProfileEntry");
            this.logAfterMethod("deleteProfileEntry");
        }
        catch (SRecorderException re) {
            this.logOnExceptionMethod("deleteProfileEntry", re);
            this.initiateLogBuilder(profileEntry.getId(), 0, logBuilder, "deleteProfileEntry");
            throw new SProfileEntryDeletionException(re);
        }
    }

    @Override
    public void deleteProfileEntry(long profileEntryId) throws SProfileEntryNotFoundException, SProfileEntryDeletionException {
        this.logBeforeMethod("deleteProfileEntry");
        SProfileEntry profileEntry = this.getProfileEntry(profileEntryId);
        this.deleteProfileEntry(profileEntry);
        this.logAfterMethod("deleteProfileEntry");
    }

    private SProfileMemberImpl buildProfileMember(long profileId, String displayNamePart1, String displayNamePart2, String displayNamePart3) {
        SProfileMemberImpl profileMember = new SProfileMemberImpl(profileId);
        profileMember.setDisplayNamePart1(displayNamePart1);
        profileMember.setDisplayNamePart2(displayNamePart2);
        profileMember.setDisplayNamePart1(displayNamePart3);
        return profileMember;
    }

    @Override
    public SProfileMember addUserToProfile(long profileId, long userId, String firstName, String lastName, String userName) throws SProfileMemberCreationException {
        this.logBeforeMethod("addUserToProfile");
        SProfileMemberImpl profileMember = this.buildProfileMember(profileId, firstName, lastName, userName);
        profileMember.setUserId(userId);
        this.createProfileMember(profileMember);
        this.logAfterMethod("addUserToProfile");
        return profileMember;
    }

    private void createProfileMember(SProfileMemberImpl profileMember) throws SProfileMemberCreationException {
        String message = "Adding a new profile member";
        SProfileMemberLogBuilderImpl logBuilder = this.getProfileMemberLog(ActionType.CREATED, "Adding a new profile member");
        try {
            InsertRecord insertRecord = new InsertRecord(profileMember);
            SInsertEvent insertEvent = null;
            if (this.eventService.hasHandlers("PROFILE", EventActionType.CREATED)) {
                insertEvent = (SInsertEvent)BuilderFactory.get(SEventBuilderFactory.class).createInsertEvent("PROFILE_MEMBER").setObject(profileMember).done();
            }
            this.recorder.recordInsert(insertRecord, insertEvent);
            this.initiateLogBuilder(profileMember.getId(), 1, logBuilder, "insertProfileMember");
        }
        catch (SRecorderException re) {
            this.initiateLogBuilder(profileMember.getId(), 0, logBuilder, "insertProfileMember");
            throw new SProfileMemberCreationException(re);
        }
    }

    @Override
    public SProfileMember addGroupToProfile(long profileId, long groupId, String groupName, String parentPath) throws SProfileMemberCreationException {
        this.logBeforeMethod("addGroupToProfile");
        SProfileMemberImpl profileMember = this.buildProfileMember(profileId, groupName, parentPath, null);
        profileMember.setGroupId(groupId);
        this.createProfileMember(profileMember);
        this.logAfterMethod("addGroupToProfile");
        return profileMember;
    }

    @Override
    public SProfileMember addRoleToProfile(long profileId, long roleId, String roleName) throws SProfileMemberCreationException {
        this.logBeforeMethod("addRoleToProfile");
        SProfileMemberImpl profileMember = this.buildProfileMember(profileId, roleName, null, null);
        profileMember.setRoleId(roleId);
        this.createProfileMember(profileMember);
        this.logAfterMethod("addRoleToProfile");
        return profileMember;
    }

    @Override
    public SProfileMember addRoleAndGroupToProfile(long profileId, long roleId, long groupId, String roleName, String groupName, String groupParentPath) throws SProfileMemberCreationException {
        this.logBeforeMethod("addRoleAndGroupToProfile");
        SProfileMemberImpl profileMember = this.buildProfileMember(profileId, roleName, groupName, groupParentPath);
        profileMember.setGroupId(groupId);
        profileMember.setRoleId(roleId);
        this.createProfileMember(profileMember);
        this.logAfterMethod("addRoleAndGroupToProfile");
        return profileMember;
    }

    @Override
    public void deleteProfileMember(long profileMemberId) throws SProfileMemberDeletionException, SProfileMemberNotFoundException {
        this.logBeforeMethod("deleteProfileMember");
        SProfileMember profileMember = this.getProfileMemberWithoutDisplayName(profileMemberId);
        this.deleteProfileMember(profileMember);
        this.logAfterMethod("deleteProfileMember");
    }

    private SProfileMember getProfileMemberWithoutDisplayName(long profileMemberId) throws SProfileMemberNotFoundException {
        SelectByIdDescriptor<SProfileMember> selectByIdDescriptor = SelectDescriptorBuilder.getProfileMemberWithoutDisplayName(profileMemberId);
        try {
            SProfileMember profileMember = this.persistenceService.selectById(selectByIdDescriptor);
            if (profileMember == null) {
                throw new SProfileMemberNotFoundException(profileMemberId + " does not refer to any profile member");
            }
            return profileMember;
        }
        catch (SBonitaReadException bre) {
            throw new SProfileMemberNotFoundException(bre);
        }
    }

    @Override
    public void deleteProfileMember(SProfileMember profileMember) throws SProfileMemberDeletionException {
        this.logBeforeMethod("deleteProfileMember");
        String message = "Deleting profile member for userId " + profileMember.getUserId() + " with roleId " + profileMember.getRoleId() + " in groupId " + profileMember.getGroupId();
        SProfileMemberLogBuilderImpl logBuilder = this.getProfileMemberLog(ActionType.DELETED, message);
        try {
            DeleteRecord deleteRecord = new DeleteRecord(profileMember);
            SDeleteEvent deleteEvent = null;
            if (this.eventService.hasHandlers("PROFILE_MEMBER", EventActionType.DELETED)) {
                deleteEvent = (SDeleteEvent)BuilderFactory.get(SEventBuilderFactory.class).createDeleteEvent("PROFILE_MEMBER").setObject(profileMember).done();
            }
            this.recorder.recordDelete(deleteRecord, deleteEvent);
            this.initiateLogBuilder(profileMember.getId(), 1, logBuilder, "deleteProfileMember");
            this.logAfterMethod("deleteProfileMember");
        }
        catch (SRecorderException re) {
            this.logOnExceptionMethod("deleteProfileMember", re);
            this.initiateLogBuilder(profileMember.getId(), 0, logBuilder, "deleteProfileMember");
            throw new SProfileMemberDeletionException(re);
        }
    }

    @Override
    public List<SProfileMember> getProfileMembersOfUser(long userId, int fromIndex, int numberOfElements, String field, OrderByType order) throws SProfileMemberReadException {
        this.logBeforeMethod("getProfileMembersOfUser");
        try {
            SelectListDescriptor<SProfileMember> descriptor = SelectDescriptorBuilder.getDirectProfileMembersOfUser(userId, field, order, fromIndex, numberOfElements);
            List<SProfileMember> listspProfileMembers = this.persistenceService.selectList(descriptor);
            this.logAfterMethod("getProfileMembersOfUser");
            return listspProfileMembers;
        }
        catch (SBonitaReadException bre) {
            this.logOnExceptionMethod("getProfileMembersOfUser", bre);
            throw new SProfileMemberReadException(bre);
        }
    }

    @Override
    public List<SProfileMember> getProfileMembersOfGroup(long groupId, int fromIndex, int numberOfElements, String field, OrderByType order) throws SProfileMemberReadException {
        this.logBeforeMethod("getProfileMembersOfGroup");
        try {
            SelectListDescriptor<SProfileMember> descriptor = SelectDescriptorBuilder.getDirectProfileMembersOfGroup(groupId, field, order, fromIndex, numberOfElements);
            List<SProfileMember> listspProfileMembers = this.persistenceService.selectList(descriptor);
            this.logAfterMethod("getProfileMembersOfGroup");
            return listspProfileMembers;
        }
        catch (SBonitaReadException bre) {
            this.logOnExceptionMethod("getProfileMembersOfGroup", bre);
            throw new SProfileMemberReadException(bre);
        }
    }

    @Override
    public List<SProfileMember> getProfileMembersOfRole(long roleId, int fromIndex, int numberOfElements, String field, OrderByType order) throws SProfileMemberReadException {
        this.logBeforeMethod("getProfileMembersOfRole");
        try {
            SelectListDescriptor<SProfileMember> descriptor = SelectDescriptorBuilder.getDirectProfileMembersOfRole(roleId, field, order, fromIndex, numberOfElements);
            List<SProfileMember> listspProfileMembers = this.persistenceService.selectList(descriptor);
            this.logAfterMethod("getProfileMembersOfRole");
            return listspProfileMembers;
        }
        catch (SBonitaReadException bre) {
            this.logOnExceptionMethod("getProfileMembersOfRole", bre);
            throw new SProfileMemberReadException(bre);
        }
    }

    @Override
    public List<SProfile> getProfilesOfUser(long userId) throws SProfileReadException {
        this.logBeforeMethod("getProfilesOfUser");
        SelectListDescriptor<SProfile> descriptor = SelectDescriptorBuilder.getProfilesOfUser(userId);
        try {
            List<SProfile> sProfiles = this.persistenceService.selectList(descriptor);
            this.logAfterMethod("getProfilesOfUser");
            return sProfiles;
        }
        catch (SBonitaReadException bre) {
            this.logOnExceptionMethod("getProfilesOfUser", bre);
            throw new SProfileReadException(bre);
        }
    }

    @Override
    public List<SProfileMember> getSProfileMembers(long profileId) throws SProfileMemberNotFoundException {
        try {
            SelectListDescriptor<SProfileMember> descriptor = SelectDescriptorBuilder.getSProfileMembersWithoutDisplayName(profileId);
            return this.persistenceService.selectList(descriptor);
        }
        catch (SBonitaReadException bre) {
            throw new SProfileMemberNotFoundException(bre);
        }
    }

    @Override
    public List<SProfileMember> searchProfileMembers(String querySuffix, QueryOptions queryOptions) throws SBonitaSearchException {
        this.logBeforeMethod("searchProfileMembers");
        try {
            List<SProfileMember> listSProfileMembers = this.persistenceService.searchEntity(SProfileMember.class, querySuffix, queryOptions, null);
            this.logAfterMethod("searchProfileMembers");
            return listSProfileMembers;
        }
        catch (SBonitaException e) {
            this.logOnExceptionMethod("searchProfileMembers", e);
            throw new SBonitaSearchException(e);
        }
    }

    @Override
    public long getNumberOfProfileMembers(String querySuffix, QueryOptions countOptions) throws SBonitaSearchException {
        this.logBeforeMethod("getNumberOfProfileMembers");
        try {
            long number = this.persistenceService.getNumberOfEntities(SProfileMember.class, querySuffix, countOptions, null);
            this.logAfterMethod("getNumberOfProfileMembers");
            return number;
        }
        catch (SBonitaReadException e) {
            this.logOnExceptionMethod("getNumberOfProfileMembers", e);
            throw new SBonitaSearchException(e);
        }
    }

    @Override
    public List<SProfileMember> getNumberOfProfileMembers(List<Long> profileIds) throws SBonitaSearchException {
        this.logBeforeMethod("getNumberOfProfileMembers");
        if (profileIds == null || profileIds.size() == 0) {
            return Collections.emptyList();
        }
        try {
            Map<String, Object> emptyMap = Collections.singletonMap("profileIds", profileIds);
            List<SProfileMember> results = this.persistenceService.selectList(new SelectListDescriptor("getProfileMembersFromProfileIds", emptyMap, SProfileMember.class));
            this.logAfterMethod("getNumberOfProfileMembers");
            return results;
        }
        catch (SBonitaReadException e) {
            this.logOnExceptionMethod("getNumberOfProfileMembers", e);
            throw new SBonitaSearchException(e);
        }
    }

    private void initiateLogBuilder(long objectId, int sQueriableLogStatus, SPersistenceLogBuilder logBuilder, String callerMethodName) {
        logBuilder.actionScope(String.valueOf(objectId));
        logBuilder.actionStatus(sQueriableLogStatus);
        logBuilder.objectId(objectId);
        SQueriableLog log = logBuilder.done();
        if (this.queriableLoggerService.isLoggable(log.getActionType(), log.getSeverity())) {
            this.queriableLoggerService.log(this.getClass().getName(), callerMethodName, log);
        }
    }

    @Override
    public void deleteAllProfileMembers() throws SProfileMemberDeletionException {
        try {
            DeleteAllRecord record = new DeleteAllRecord(SProfileMember.class, null);
            this.recorder.recordDeleteAll(record);
        }
        catch (SRecorderException e) {
            throw new SProfileMemberDeletionException("Can't delete all profile members.", e);
        }
    }

    @Override
    public long getNumberOfProfiles(QueryOptions queryOptions) throws SBonitaSearchException {
        try {
            Map<String, Object> parameters = Collections.emptyMap();
            return this.persistenceService.getNumberOfEntities(SProfile.class, queryOptions, parameters);
        }
        catch (SBonitaReadException e) {
            throw new SBonitaSearchException(e);
        }
    }

    @Override
    public List<SProfile> searchProfiles(QueryOptions queryOptions) throws SBonitaSearchException {
        try {
            Map<String, Object> parameters = Collections.emptyMap();
            return this.persistenceService.searchEntity(SProfile.class, queryOptions, parameters);
        }
        catch (SBonitaReadException e) {
            throw new SBonitaSearchException(e);
        }
    }

    public List<SProfileMember> getProfileMembers(int fromIndex, int numberOfElements, String field, OrderByType order) throws SBonitaReadException {
        SelectListDescriptor<SProfileMember> descriptor = SelectDescriptorBuilder.getProfileMembers(field, order, fromIndex, numberOfElements);
        return this.persistenceService.selectList(descriptor);
    }

    @Override
    public long getNumberOfProfileEntries(QueryOptions queryOptions) throws SBonitaSearchException {
        try {
            Map<String, Object> parameters = Collections.emptyMap();
            return this.persistenceService.getNumberOfEntities(SProfileEntry.class, queryOptions, parameters);
        }
        catch (SBonitaReadException e) {
            throw new SBonitaSearchException(e);
        }
    }

    @Override
    public List<SProfileEntry> searchProfileEntries(QueryOptions queryOptions) throws SBonitaSearchException {
        try {
            Map<String, Object> parameters = Collections.emptyMap();
            return this.persistenceService.searchEntity(SProfileEntry.class, queryOptions, parameters);
        }
        catch (SBonitaReadException e) {
            throw new SBonitaSearchException(e);
        }
    }

    private void logBeforeMethod(String methodName) {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), methodName));
        }
    }

    private void logAfterMethod(String methodName) {
        Class<?> thisClass = this.getClass();
        if (this.logger.isLoggable(thisClass, TechnicalLogSeverity.TRACE)) {
            this.logger.log(thisClass, TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(thisClass, methodName));
        }
    }

    private void logOnExceptionMethod(String methodName, SBonitaException e) {
        Class<?> thisClass = this.getClass();
        if (this.logger.isLoggable(thisClass, TechnicalLogSeverity.TRACE)) {
            this.logger.log(thisClass, TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(thisClass, methodName, e));
        }
    }

    private SProfileLogBuilderImpl getSProfileLog(ActionType actionType, String message) {
        SProfileLogBuilderImpl logBuilder = new SProfileLogBuilderImpl();
        this.initializeLogBuilder(logBuilder, message);
        this.updateLog(actionType, logBuilder);
        return logBuilder;
    }

    private SProfileMemberLogBuilderImpl getProfileMemberLog(ActionType actionType, String message) {
        SProfileMemberLogBuilderImpl logBuilder = new SProfileMemberLogBuilderImpl();
        this.initializeLogBuilder(logBuilder, message);
        this.updateLog(actionType, logBuilder);
        return logBuilder;
    }

    private <T extends SLogBuilder> void initializeLogBuilder(T logBuilder, String message) {
        logBuilder.actionStatus(0).severity(SQueriableLogSeverity.INTERNAL).rawMessage(message);
    }

    private <T extends HasCRUDEAction> void updateLog(ActionType actionType, T logBuilder) {
        logBuilder.setActionType(actionType);
    }
}

