/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.queriablelogger.model.impl;

import java.util.Calendar;
import java.util.Date;
import org.bonitasoft.engine.queriablelogger.model.SQueriableLog;
import org.bonitasoft.engine.queriablelogger.model.SQueriableLogSeverity;

public class SQueriableLogImpl
implements SQueriableLog {
    private static final long serialVersionUID = -1680378231407104908L;
    private long tenantId;
    private long id;
    private long timeStamp;
    private int year;
    private int month;
    private int dayOfYear;
    private int weekOfYear;
    private String userId;
    private final long threadNumber = Thread.currentThread().getId();
    private String clusterNode;
    private String productVersion;
    private SQueriableLogSeverity severity = null;
    private String actionType;
    private String actionScope;
    private int actionStatus = -1;
    private String rawMessage;
    private String callerClassName;
    private String callerMethodName;
    private long numericIndex1 = -1L;
    private long numericIndex2 = -1L;
    private long numericIndex3 = -1L;
    private long numericIndex4 = -1L;
    private long numericIndex5 = -1L;

    public SQueriableLogImpl() {
        Date date = new Date();
        this.updateDateElements(date);
    }

    public long getTenantId() {
        return this.tenantId;
    }

    @Override
    public void setTenantId(long tenantId) {
        this.tenantId = tenantId;
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public String getDiscriminator() {
        return SQueriableLog.class.getName();
    }

    @Override
    public long getTimeStamp() {
        return this.timeStamp;
    }

    @Override
    public int getYear() {
        return this.year;
    }

    @Override
    public int getMonth() {
        return this.month;
    }

    @Override
    public int getDayOfYear() {
        return this.dayOfYear;
    }

    @Override
    public int getWeekOfYear() {
        return this.weekOfYear;
    }

    @Override
    public String getUserId() {
        return this.userId;
    }

    @Override
    public long getThreadNumber() {
        return this.threadNumber;
    }

    @Override
    public String getClusterNode() {
        return this.clusterNode;
    }

    @Override
    public String getProductVersion() {
        return this.productVersion;
    }

    @Override
    public SQueriableLogSeverity getSeverity() {
        return this.severity;
    }

    @Override
    public String getActionType() {
        return this.actionType;
    }

    @Override
    public String getActionScope() {
        return this.actionScope;
    }

    @Override
    public int getActionStatus() {
        return this.actionStatus;
    }

    @Override
    public String getRawMessage() {
        return this.rawMessage;
    }

    @Override
    public String getCallerClassName() {
        return this.callerClassName;
    }

    @Override
    public String getCallerMethodName() {
        return this.callerMethodName;
    }

    @Override
    public long getNumericIndex(int pos) {
        long result = -1L;
        switch (pos) {
            case 0: {
                result = this.numericIndex1;
                break;
            }
            case 1: {
                result = this.numericIndex2;
                break;
            }
            case 2: {
                result = this.numericIndex3;
                break;
            }
            case 3: {
                result = this.numericIndex4;
                break;
            }
            case 4: {
                result = this.numericIndex5;
            }
        }
        return result;
    }

    private void updateDateElements(Date date) {
        this.timeStamp = date.getTime();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        this.year = calendar.get(1);
        this.month = calendar.get(2) + 1;
        this.weekOfYear = calendar.get(3);
        this.dayOfYear = calendar.get(6);
    }

    public void setClusterNode(String clusterNode) {
        this.clusterNode = clusterNode;
    }

    public void setProductVersion(String productVersion) {
        this.productVersion = productVersion;
    }

    public void setSeverity(SQueriableLogSeverity severity) {
        this.severity = severity;
    }

    public void setActionType(String actionType) {
        this.actionType = actionType;
    }

    public void setActionScope(String actionScope) {
        this.actionScope = actionScope;
    }

    public void setActionStatus(int actionStatus) {
        this.actionStatus = actionStatus;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setRawMessage(String rawMessage) {
        this.rawMessage = rawMessage;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    public void setNumericIndex(int pos, long value) {
        switch (pos) {
            case 0: {
                this.numericIndex1 = value;
                break;
            }
            case 1: {
                this.numericIndex2 = value;
                break;
            }
            case 2: {
                this.numericIndex3 = value;
                break;
            }
            case 3: {
                this.numericIndex4 = value;
                break;
            }
            case 4: {
                this.numericIndex5 = value;
            }
        }
    }

    public void setCallerClassName(String callerClassName) {
        this.callerClassName = callerClassName;
    }

    public void setCallerMethodName(String callerMethodName) {
        this.callerMethodName = callerMethodName;
    }

    public String toString() {
        return "SQueriableLogImpl [tenantId=" + this.tenantId + ", id=" + this.id + ", timeStamp=" + this.timeStamp + ", year=" + this.year + ", month=" + this.month + ", dayOfYear=" + this.dayOfYear + ", weekOfYear=" + this.weekOfYear + ", userId=" + this.userId + ", threadNumber=" + this.threadNumber + ", clusterNode=" + this.clusterNode + ", productVersion=" + this.productVersion + ", severity=" + (Object)((Object)this.severity) + ", actionType=" + this.actionType + ", actionScope=" + this.actionScope + ", actionStatus=" + this.actionStatus + ", rawMessage=" + this.rawMessage + ", callerClassName=" + this.callerClassName + ", callerMethodName=" + this.callerMethodName + ", numericIndex1=" + this.numericIndex1 + ", numericIndex2=" + this.numericIndex2 + ", numericIndex3=" + this.numericIndex3 + ", numericIndex4=" + this.numericIndex4 + ", numericIndex5=" + this.numericIndex5 + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.actionScope == null ? 0 : this.actionScope.hashCode());
        result = 31 * result + this.actionStatus;
        result = 31 * result + (this.actionType == null ? 0 : this.actionType.hashCode());
        result = 31 * result + (this.callerClassName == null ? 0 : this.callerClassName.hashCode());
        result = 31 * result + (this.callerMethodName == null ? 0 : this.callerMethodName.hashCode());
        result = 31 * result + (this.clusterNode == null ? 0 : this.clusterNode.hashCode());
        result = 31 * result + this.dayOfYear;
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        result = 31 * result + this.month;
        result = 31 * result + (int)(this.numericIndex1 ^ this.numericIndex1 >>> 32);
        result = 31 * result + (int)(this.numericIndex2 ^ this.numericIndex2 >>> 32);
        result = 31 * result + (int)(this.numericIndex3 ^ this.numericIndex3 >>> 32);
        result = 31 * result + (int)(this.numericIndex4 ^ this.numericIndex4 >>> 32);
        result = 31 * result + (int)(this.numericIndex5 ^ this.numericIndex5 >>> 32);
        result = 31 * result + (this.productVersion == null ? 0 : this.productVersion.hashCode());
        result = 31 * result + (this.rawMessage == null ? 0 : this.rawMessage.hashCode());
        result = 31 * result + (this.severity == null ? 0 : this.severity.hashCode());
        result = 31 * result + (int)(this.tenantId ^ this.tenantId >>> 32);
        result = 31 * result + (int)(this.threadNumber ^ this.threadNumber >>> 32);
        result = 31 * result + (int)(this.timeStamp ^ this.timeStamp >>> 32);
        result = 31 * result + (this.userId == null ? 0 : this.userId.hashCode());
        result = 31 * result + this.weekOfYear;
        result = 31 * result + this.year;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SQueriableLogImpl other = (SQueriableLogImpl)obj;
        if (this.actionScope == null ? other.actionScope != null : !this.actionScope.equals(other.actionScope)) {
            return false;
        }
        if (this.actionStatus != other.actionStatus) {
            return false;
        }
        if (this.actionType == null ? other.actionType != null : !this.actionType.equals(other.actionType)) {
            return false;
        }
        if (this.callerClassName == null ? other.callerClassName != null : !this.callerClassName.equals(other.callerClassName)) {
            return false;
        }
        if (this.callerMethodName == null ? other.callerMethodName != null : !this.callerMethodName.equals(other.callerMethodName)) {
            return false;
        }
        if (this.clusterNode == null ? other.clusterNode != null : !this.clusterNode.equals(other.clusterNode)) {
            return false;
        }
        if (this.dayOfYear != other.dayOfYear) {
            return false;
        }
        if (this.id != other.id) {
            return false;
        }
        if (this.month != other.month) {
            return false;
        }
        if (this.numericIndex1 != other.numericIndex1) {
            return false;
        }
        if (this.numericIndex2 != other.numericIndex2) {
            return false;
        }
        if (this.numericIndex3 != other.numericIndex3) {
            return false;
        }
        if (this.numericIndex4 != other.numericIndex4) {
            return false;
        }
        if (this.numericIndex5 != other.numericIndex5) {
            return false;
        }
        if (this.productVersion == null ? other.productVersion != null : !this.productVersion.equals(other.productVersion)) {
            return false;
        }
        if (this.rawMessage == null ? other.rawMessage != null : !this.rawMessage.equals(other.rawMessage)) {
            return false;
        }
        if (this.severity != other.severity) {
            return false;
        }
        if (this.tenantId != other.tenantId) {
            return false;
        }
        if (this.threadNumber != other.threadNumber) {
            return false;
        }
        if (this.timeStamp != other.timeStamp) {
            return false;
        }
        if (this.userId == null ? other.userId != null : !this.userId.equals(other.userId)) {
            return false;
        }
        if (this.weekOfYear != other.weekOfYear) {
            return false;
        }
        return this.year == other.year;
    }
}

