/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.search.descriptor;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.bonitasoft.engine.persistence.FilterOption;
import org.bonitasoft.engine.persistence.OrderByOption;
import org.bonitasoft.engine.persistence.OrderByType;
import org.bonitasoft.engine.persistence.PersistentObject;
import org.bonitasoft.engine.persistence.SBonitaSearchException;
import org.bonitasoft.engine.persistence.SearchFields;
import org.bonitasoft.engine.persistence.search.FilterOperationType;
import org.bonitasoft.engine.search.Sort;
import org.bonitasoft.engine.search.descriptor.FieldDescriptor;
import org.bonitasoft.engine.search.impl.SearchFilter;

public abstract class SearchEntityDescriptor {
    public FilterOption getEntityFilter(SearchFilter filter) {
        String key = filter.getField();
        FieldDescriptor fieldDescriptor = this.getEntityKeys().get(key);
        if (fieldDescriptor == null && !filter.isUndefinedFieldNameAuthorized()) {
            throw new IllegalArgumentException("the field '" + key + "' is unknown for the entity searched using " + this.getClass().getSimpleName());
        }
        return this.constructFilterOption(filter, fieldDescriptor);
    }

    public OrderByOption getEntityOrder(Sort sort) throws SBonitaSearchException {
        FieldDescriptor fieldDescriptor = this.getEntityKeys().get(sort.getField());
        if (fieldDescriptor == null) {
            throw new SBonitaSearchException("Invalid sort key: " + sort.getField());
        }
        OrderByType type = OrderByType.valueOf(sort.getOrder().name());
        return new OrderByOption(fieldDescriptor.getPersistentClass(), fieldDescriptor.getValue(), type);
    }

    public SearchFields getEntitySearchTerm(String searchString) {
        StringTokenizer tokens = new StringTokenizer(searchString, " ");
        ArrayList<String> terms = new ArrayList<String>(tokens.countTokens());
        while (tokens.hasMoreTokens()) {
            String term = tokens.nextToken();
            terms.add(term);
        }
        return new SearchFields(terms, this.getAllFields());
    }

    protected abstract Map<String, FieldDescriptor> getEntityKeys();

    protected abstract Map<Class<? extends PersistentObject>, Set<String>> getAllFields();

    protected Serializable convertFilterValue(Serializable filterValue) {
        return filterValue;
    }

    public FilterOption constructFilterOption(SearchFilter filter, FieldDescriptor fieldDescriptor) {
        Class<? extends PersistentObject> clazz = fieldDescriptor != null ? fieldDescriptor.getPersistentClass() : null;
        String fieldName = fieldDescriptor != null ? fieldDescriptor.getValue() : null;
        Serializable value = this.convertFilterValue(filter.getValue());
        switch (filter.getOperation()) {
            case BETWEEN: {
                return new FilterOption(clazz, fieldName, (Object)this.convertFilterValue(filter.getFrom()), this.convertFilterValue(filter.getTo()));
            }
            case DIFFERENT: {
                return new FilterOption(clazz, fieldName, (Object)value, FilterOperationType.DIFFERENT);
            }
            case EQUALS: {
                return new FilterOption(clazz, fieldName, (Object)value, FilterOperationType.EQUALS);
            }
            case GREATER_OR_EQUAL: {
                return new FilterOption(clazz, fieldName, (Object)value, FilterOperationType.GREATER_OR_EQUALS);
            }
            case GREATER_THAN: {
                return new FilterOption(clazz, fieldName, (Object)value, FilterOperationType.GREATER);
            }
            case LESS_OR_EQUAL: {
                return new FilterOption(clazz, fieldName, (Object)value, FilterOperationType.LESS_OR_EQUALS);
            }
            case LESS_THAN: {
                return new FilterOption(clazz, fieldName, (Object)value, FilterOperationType.LESS);
            }
            case AND: {
                return new FilterOption(FilterOperationType.AND);
            }
            case OR: {
                return new FilterOption(FilterOperationType.OR);
            }
            case L_PARENTHESIS: {
                return new FilterOption(FilterOperationType.L_PARENTHESIS);
            }
            case R_PARENTHESIS: {
                return new FilterOption(FilterOperationType.R_PARENTHESIS);
            }
        }
        return null;
    }
}

