/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.search.task;

import java.util.List;
import org.bonitasoft.engine.core.process.instance.api.ActivityInstanceService;
import org.bonitasoft.engine.core.process.instance.model.SHumanTaskInstance;
import org.bonitasoft.engine.execution.state.FlowNodeStateManager;
import org.bonitasoft.engine.persistence.QueryOptions;
import org.bonitasoft.engine.persistence.SBonitaSearchException;
import org.bonitasoft.engine.search.AbstractHumanTaskInstanceSearchEntity;
import org.bonitasoft.engine.search.SearchOptions;
import org.bonitasoft.engine.search.descriptor.SearchHumanTaskInstanceDescriptor;

public class SearchPendingTasksForUser
extends AbstractHumanTaskInstanceSearchEntity {
    private final ActivityInstanceService activityInstanceService;
    private final long userId;
    private final boolean orAssignedToUser;

    public SearchPendingTasksForUser(ActivityInstanceService activityInstanceService, FlowNodeStateManager flowNodeStateManager, SearchHumanTaskInstanceDescriptor searchEntitiesDescriptor, long userId, SearchOptions options, boolean orAssignedToUser) {
        super(searchEntitiesDescriptor, options, flowNodeStateManager);
        this.activityInstanceService = activityInstanceService;
        this.userId = userId;
        this.orAssignedToUser = orAssignedToUser;
    }

    @Override
    public long executeCount(QueryOptions searchOptions) throws SBonitaSearchException {
        if (this.orAssignedToUser) {
            return this.activityInstanceService.getNumberOfPendingOrAssignedTasks(this.userId, searchOptions);
        }
        return this.activityInstanceService.getNumberOfPendingTasksForUser(this.userId, searchOptions);
    }

    @Override
    public List<SHumanTaskInstance> executeSearch(QueryOptions searchOptions) throws SBonitaSearchException {
        if (this.orAssignedToUser) {
            return this.activityInstanceService.searchPendingOrAssignedTasks(this.userId, searchOptions);
        }
        return this.activityInstanceService.searchPendingTasksForUser(this.userId, searchOptions);
    }
}

