/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.search.theme;

import java.util.List;
import org.bonitasoft.engine.persistence.QueryOptions;
import org.bonitasoft.engine.persistence.SBonitaSearchException;
import org.bonitasoft.engine.search.AbstractSearchEntity;
import org.bonitasoft.engine.search.SearchOptions;
import org.bonitasoft.engine.search.descriptor.SearchThemeDescriptor;
import org.bonitasoft.engine.service.ModelConvertor;
import org.bonitasoft.engine.theme.Theme;
import org.bonitasoft.engine.theme.ThemeService;
import org.bonitasoft.engine.theme.model.STheme;

public class SearchThemes
extends AbstractSearchEntity<Theme, STheme> {
    private final ThemeService themeService;

    public SearchThemes(ThemeService themeService, SearchThemeDescriptor searchThemeDescriptor, SearchOptions options) {
        super(searchThemeDescriptor, options);
        this.themeService = themeService;
    }

    @Override
    public long executeCount(QueryOptions queryOptions) throws SBonitaSearchException {
        return this.themeService.getNumberOfThemes(queryOptions);
    }

    @Override
    public List<STheme> executeSearch(QueryOptions queryOptions) throws SBonitaSearchException {
        return this.themeService.searchThemes(queryOptions);
    }

    @Override
    public List<Theme> convertToClientObjects(List<STheme> serverObjects) {
        return ModelConvertor.toThemes(serverObjects);
    }
}

