/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.service;

import java.util.HashMap;
import java.util.Map;
import org.bonitasoft.engine.service.TenantServiceAccessor;
import org.bonitasoft.engine.service.impl.ServiceAccessorFactory;

public final class TenantServiceSingleton {
    private static Map<Long, TenantServiceAccessor> instances = new HashMap<Long, TenantServiceAccessor>();

    private TenantServiceSingleton() {
    }

    private static TenantServiceAccessor getTenant(long tenantId) {
        try {
            return ServiceAccessorFactory.getInstance().createTenantServiceAccessor(tenantId);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static TenantServiceAccessor getInstance(long tenantId) {
        if (!instances.containsKey(tenantId)) {
            instances.put(tenantId, TenantServiceSingleton.getTenant(tenantId));
        }
        return instances.get(tenantId);
    }
}

