/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.service.impl;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import org.bonitasoft.engine.exception.BonitaHomeNotSetException;
import org.bonitasoft.engine.home.BonitaHomeServer;
import org.bonitasoft.engine.service.impl.AbsoluteFileSystemXmlApplicationContext;
import org.bonitasoft.engine.service.impl.SpringSessionAccessorFileSystemBeanAcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.FileSystemXmlApplicationContext;

public class SpringPlatformFileSystemBeanAccessor {
    private static AbsoluteFileSystemXmlApplicationContext context;

    private static String[] getResources() {
        BonitaHomeServer homeServer = BonitaHomeServer.getInstance();
        try {
            String platformFolder = homeServer.getPlatformConfFolder();
            File serviceFolder = new File(platformFolder + File.separatorChar + "services");
            if (!serviceFolder.isDirectory()) {
                throw new RuntimeException("Folder 'services' not found");
            }
            FileFilter filter = new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.isFile() && pathname.getName().endsWith(".xml");
                }
            };
            File[] listFiles = serviceFolder.listFiles(filter);
            if (listFiles.length == 0) {
                throw new RuntimeException("No file found");
            }
            String[] resources = new String[listFiles.length];
            for (int i = 0; i < listFiles.length; ++i) {
                try {
                    resources[i] = listFiles[i].getCanonicalPath();
                    continue;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            return resources;
        }
        catch (BonitaHomeNotSetException e) {
            throw new RuntimeException("Bonita home not set");
        }
    }

    public static <T> T getService(Class<T> serviceClass) {
        return (T)SpringPlatformFileSystemBeanAccessor.getContext().getBean(serviceClass);
    }

    protected static FileSystemXmlApplicationContext getContext() {
        if (context == null) {
            SpringPlatformFileSystemBeanAccessor.initializeContext(null);
        }
        return context;
    }

    public static synchronized void initializeContext(ClassLoader classLoader) {
        if (context == null) {
            SpringSessionAccessorFileSystemBeanAcessor.initializeContext(classLoader);
            FileSystemXmlApplicationContext sessionContext = SpringSessionAccessorFileSystemBeanAcessor.getContext();
            context = new AbsoluteFileSystemXmlApplicationContext(SpringPlatformFileSystemBeanAccessor.getResources(), true, (ApplicationContext)sessionContext);
        }
    }

    protected static <T> T getService(String name, Class<T> serviceClass) {
        return (T)SpringPlatformFileSystemBeanAccessor.getContext().getBean(name, serviceClass);
    }

    public static void destroy() {
        context.destroy();
        context = null;
    }
}

