/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.service.impl;

import java.io.File;
import java.io.IOException;
import org.bonitasoft.engine.exception.BonitaHomeNotSetException;
import org.bonitasoft.engine.home.BonitaHomeServer;
import org.bonitasoft.engine.service.impl.AbsoluteFileSystemXmlApplicationContext;
import org.bonitasoft.engine.service.impl.SessionAccessorNotFoundException;
import org.bonitasoft.engine.sessionaccessor.SessionAccessor;
import org.springframework.context.support.FileSystemXmlApplicationContext;

public class SpringSessionAccessorFileSystemBeanAcessor {
    private static AbsoluteFileSystemXmlApplicationContext context;

    private static String[] getResources() {
        BonitaHomeServer homeServer = BonitaHomeServer.getInstance();
        try {
            String platformFolder = homeServer.getPlatformConfFolder();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(platformFolder).append(File.separatorChar).append("sessionaccessor").append(File.separatorChar);
            String file = "cfg-bonita-sessionaccessor-threadlocal.xml";
            stringBuilder.append("cfg-bonita-sessionaccessor-threadlocal.xml");
            File sessionAccesorFile = new File(stringBuilder.toString());
            if (!sessionAccesorFile.exists() || !sessionAccesorFile.isFile()) {
                throw new SessionAccessorNotFoundException("File: cfg-bonita-sessionaccessor-threadlocal.xml does not exist");
            }
            String[] resources = new String[]{sessionAccesorFile.getCanonicalPath()};
            return resources;
        }
        catch (BonitaHomeNotSetException e) {
            throw new SessionAccessorNotFoundException(e);
        }
        catch (IOException e) {
            throw new SessionAccessorNotFoundException(e);
        }
    }

    protected static SessionAccessor getSessionAccessor() {
        return (SessionAccessor)SpringSessionAccessorFileSystemBeanAcessor.getContext().getBean(SessionAccessor.class);
    }

    protected static FileSystemXmlApplicationContext getContext() {
        if (context == null) {
            SpringSessionAccessorFileSystemBeanAcessor.initializeContext(null);
        }
        return context;
    }

    public static synchronized void initializeContext(ClassLoader classLoader) {
        if (context == null) {
            context = new AbsoluteFileSystemXmlApplicationContext(SpringSessionAccessorFileSystemBeanAcessor.getResources(), false, null);
            if (classLoader != null) {
                context.setClassLoader(classLoader);
            }
            context.refresh();
        }
    }

    public static void destroy() {
        context.destroy();
        context = null;
    }
}

