/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.services;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.bonitasoft.engine.persistence.PersistentObject;

public class UpdateDescriptor {
    private static final String ID = "id";
    private final PersistentObject entity;
    private Map<String, Object> fields;

    public static UpdateDescriptor buildSetField(PersistentObject entity, String fieldName, Object fieldValue) {
        UpdateDescriptor updateDescriptor = new UpdateDescriptor(entity);
        updateDescriptor.addField(fieldName, fieldValue);
        return updateDescriptor;
    }

    public static UpdateDescriptor buildSetFields(PersistentObject entity, Map<String, Object> fields) {
        UpdateDescriptor updateDescriptor = new UpdateDescriptor(entity);
        updateDescriptor.addFields(fields);
        return updateDescriptor;
    }

    public UpdateDescriptor(PersistentObject entity) {
        this.entity = entity;
    }

    public void addField(String fieldName, Object fieldValue) {
        if (this.fields == null) {
            this.fields = new HashMap<String, Object>();
        }
        if (ID.equalsIgnoreCase(fieldName)) {
            throw new RuntimeException("Updating an object's id field is forbidden");
        }
        this.fields.put(fieldName, fieldValue);
    }

    public void addFields(Map<String, Object> fields) {
        if (this.fields == null) {
            this.fields = new HashMap<String, Object>();
        }
        if (fields.containsKey(ID)) {
            throw new RuntimeException("Updating an object's id field is forbidden");
        }
        this.fields.putAll(fields);
    }

    public PersistentObject getEntity() {
        return this.entity;
    }

    public Map<String, Object> getFields() {
        if (this.fields == null) {
            return Collections.emptyMap();
        }
        return this.fields;
    }

    public String toString() {
        return "UpdateDescriptor [entity=" + this.entity + ", fields=" + this.fields + "]";
    }
}

