/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.session.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.bonitasoft.engine.session.SSessionAlreadyExistsException;
import org.bonitasoft.engine.session.SSessionNotFoundException;
import org.bonitasoft.engine.session.SessionProvider;
import org.bonitasoft.engine.session.model.SSession;

public final class SessionProviderImpl
implements SessionProvider {
    private static Map<Long, SSession> sessions = new HashMap<Long, SSession>();

    @Override
    public synchronized void addSession(SSession session) throws SSessionAlreadyExistsException {
        long id = session.getId();
        if (sessions.containsKey(id)) {
            throw new SSessionAlreadyExistsException("A session wih id \"" + id + "\" already exists");
        }
        sessions.put(id, session);
    }

    @Override
    public synchronized void removeSession(long sessionId) throws SSessionNotFoundException {
        SSession session = sessions.remove(sessionId);
        if (session == null) {
            throw new SSessionNotFoundException("No session found with id \"" + sessionId + "\"");
        }
    }

    @Override
    public synchronized SSession getSession(long sessionId) throws SSessionNotFoundException {
        SSession session = sessions.get(sessionId);
        if (session == null) {
            throw new SSessionNotFoundException("No session found with id \"" + sessionId + "\"");
        }
        return session;
    }

    @Override
    public synchronized void updateSession(SSession session) throws SSessionNotFoundException {
        long id = session.getId();
        if (!sessions.containsKey(id)) {
            throw new SSessionNotFoundException("No session found with id \"" + id + "\"");
        }
        sessions.put(id, session);
    }

    @Override
    public synchronized void cleanInvalidSessions() {
        ArrayList<Long> invalidSessionIds = new ArrayList<Long>();
        for (SSession session : sessions.values()) {
            if (session.isValid()) continue;
            invalidSessionIds.add(session.getId());
        }
        for (Long invalidSessionId : invalidSessionIds) {
            sessions.remove(invalidSessionId);
        }
    }

    @Override
    public synchronized void removeSessions() {
        sessions.clear();
    }

    @Override
    public synchronized void deleteSessionsOfTenant(long tenantId) {
        Iterator<SSession> iterator = sessions.values().iterator();
        while (iterator.hasNext()) {
            SSession sSession = iterator.next();
            if (tenantId != sSession.getTenantId()) continue;
            iterator.remove();
        }
    }
}

