/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.session.model.impl;

import java.util.Date;
import org.bonitasoft.engine.session.model.SSession;

public class SSessionImpl
implements SSession {
    private static final long serialVersionUID = 1L;
    private long tenantId;
    private final long id;
    private Date creationDate;
    private long duration;
    private Date lastRenewDate;
    private String userName;
    private long userId;
    private String clientIP;
    private String clusterNode;
    private String applicationName;
    private String clientApplicationName;
    private boolean technicalUser;

    public SSessionImpl(long id, long tenantId, String userName, String applicationName, long userId) {
        this.id = id;
        this.tenantId = tenantId;
        this.userName = userName;
        this.applicationName = applicationName;
        this.userId = userId;
    }

    public SSessionImpl(SSession session) {
        this.id = session.getId();
        this.tenantId = session.getTenantId();
        this.creationDate = session.getCreationDate();
        this.duration = session.getDuration();
        this.lastRenewDate = session.getLastRenewDate();
        this.userName = session.getUserName();
        this.userId = session.getUserId();
        this.technicalUser = session.isTechnicalUser();
        this.clientIP = session.getClientIP();
        this.clusterNode = session.getClusterNode();
        this.applicationName = session.getApplicationName();
        this.clientApplicationName = session.getClientApplicationName();
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    @Override
    public Date getLastRenewDate() {
        return this.lastRenewDate;
    }

    public void setLastRenewDate(Date lastRenewDate) {
        this.lastRenewDate = lastRenewDate;
    }

    @Override
    public long getDuration() {
        return this.duration;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    @Override
    public Date getExpirationDate() {
        return new Date(this.lastRenewDate.getTime() + this.duration);
    }

    @Override
    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    @Override
    public long getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(long tenantId) {
        this.tenantId = tenantId;
    }

    @Override
    public String getClientIP() {
        return this.clientIP;
    }

    public void setClientIP(String clientIP) {
        this.clientIP = clientIP;
    }

    @Override
    public String getClusterNode() {
        return this.clusterNode;
    }

    public void setClusterNode(String clusterNode) {
        this.clusterNode = clusterNode;
    }

    @Override
    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    @Override
    public String getClientApplicationName() {
        return this.clientApplicationName;
    }

    public void setClientApplicationName(String clientApplicationName) {
        this.clientApplicationName = clientApplicationName;
    }

    @Override
    public boolean isValid() {
        return this.getExpirationDate().getTime() > System.currentTimeMillis();
    }

    @Override
    public long getUserId() {
        return this.userId;
    }

    public void setUserId(long userId) {
        this.userId = userId;
    }

    @Override
    public boolean isTechnicalUser() {
        return this.technicalUser;
    }

    public void setTechnicalUser(boolean technicalUser) {
        this.technicalUser = technicalUser;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.applicationName == null ? 0 : this.applicationName.hashCode());
        result = 31 * result + (this.clientApplicationName == null ? 0 : this.clientApplicationName.hashCode());
        result = 31 * result + (this.clientIP == null ? 0 : this.clientIP.hashCode());
        result = 31 * result + (this.clusterNode == null ? 0 : this.clusterNode.hashCode());
        result = 31 * result + (this.creationDate == null ? 0 : this.creationDate.hashCode());
        result = 31 * result + (int)(this.duration ^ this.duration >>> 32);
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        result = 31 * result + (this.lastRenewDate == null ? 0 : this.lastRenewDate.hashCode());
        result = 31 * result + (this.technicalUser ? 1231 : 1237);
        result = 31 * result + (int)(this.tenantId ^ this.tenantId >>> 32);
        result = 31 * result + (int)(this.userId ^ this.userId >>> 32);
        result = 31 * result + (this.userName == null ? 0 : this.userName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SSessionImpl other = (SSessionImpl)obj;
        if (this.applicationName == null ? other.applicationName != null : !this.applicationName.equals(other.applicationName)) {
            return false;
        }
        if (this.clientApplicationName == null ? other.clientApplicationName != null : !this.clientApplicationName.equals(other.clientApplicationName)) {
            return false;
        }
        if (this.clientIP == null ? other.clientIP != null : !this.clientIP.equals(other.clientIP)) {
            return false;
        }
        if (this.clusterNode == null ? other.clusterNode != null : !this.clusterNode.equals(other.clusterNode)) {
            return false;
        }
        if (this.creationDate == null ? other.creationDate != null : !this.creationDate.equals(other.creationDate)) {
            return false;
        }
        if (this.duration != other.duration) {
            return false;
        }
        if (this.id != other.id) {
            return false;
        }
        if (this.lastRenewDate == null ? other.lastRenewDate != null : !this.lastRenewDate.equals(other.lastRenewDate)) {
            return false;
        }
        if (this.technicalUser != other.technicalUser) {
            return false;
        }
        if (this.tenantId != other.tenantId) {
            return false;
        }
        if (this.userId != other.userId) {
            return false;
        }
        return !(this.userName == null ? other.userName != null : !this.userName.equals(other.userName));
    }
}

