/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.synchro;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bonitasoft.engine.command.CommandService;
import org.bonitasoft.engine.command.SCommandExecutionException;
import org.bonitasoft.engine.command.TenantCommand;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.events.EventService;
import org.bonitasoft.engine.events.model.SEvent;
import org.bonitasoft.engine.events.model.SHandler;
import org.bonitasoft.engine.recorder.model.EntityUpdateDescriptor;
import org.bonitasoft.engine.service.TenantServiceAccessor;
import org.bonitasoft.engine.synchro.FlowNodeHandler;
import org.bonitasoft.engine.synchro.ProcessInstanceHandler;

public class AddHandlerCommand
extends TenantCommand {
    private static final String PROCESSINSTANCE_STATE_UPDATED = "PROCESSINSTANCE_STATE_UPDATED";
    private static final String ACTIVITYINSTANCE_STATE_UPDATED = "ACTIVITYINSTANCE_STATE_UPDATED";
    private static final String ACTIVITYINSTANCE_CREATED = "ACTIVITYINSTANCE_CREATED";
    private static final String EVENT_INSTANCE_CREATED = "EVENT_INSTANCE_CREATED";

    @Override
    public Serializable execute(Map<String, Serializable> parameters, TenantServiceAccessor serviceAccessor) throws SCommandExecutionException {
        EventService eventService = serviceAccessor.getEventService();
        try {
            long tenantId = serviceAccessor.getTenantId();
            if (!this.containsHandler(eventService, PROCESSINSTANCE_STATE_UPDATED, ProcessInstanceHandler.class)) {
                eventService.addHandler(PROCESSINSTANCE_STATE_UPDATED, new ProcessInstanceHandler(tenantId));
            }
            if (!this.containsHandler(eventService, ACTIVITYINSTANCE_STATE_UPDATED, FlowNodeHandler.class)) {
                eventService.addHandler(ACTIVITYINSTANCE_STATE_UPDATED, new FlowNodeHandler(tenantId));
                eventService.addHandler(ACTIVITYINSTANCE_CREATED, new FlowNodeHandler(tenantId));
                eventService.addHandler(EVENT_INSTANCE_CREATED, new FlowNodeHandler(tenantId));
            }
            EntityUpdateDescriptor entityUpdateDescriptor = new EntityUpdateDescriptor();
            entityUpdateDescriptor.addField("system", true);
            CommandService commandService = serviceAccessor.getCommandService();
            List commandIds = (List)((Object)parameters.get("commands"));
            for (Long commandId : commandIds) {
                commandService.update(commandService.get(commandId), entityUpdateDescriptor);
            }
        }
        catch (SBonitaException e) {
            throw new SCommandExecutionException(e);
        }
        return null;
    }

    private boolean containsHandler(EventService eventService, String eventType, Class<?> clazz) {
        Set<SHandler<SEvent>> handlers = eventService.getHandlers(eventType);
        if (handlers != null) {
            for (SHandler<SEvent> sHandler : handlers) {
                if (!clazz.isInstance(sHandler)) continue;
                return true;
            }
        }
        return false;
    }
}

