/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.work;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.bonitasoft.engine.log.technical.TechnicalLogSeverity;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;
import org.bonitasoft.engine.sessionaccessor.SessionAccessor;
import org.bonitasoft.engine.sessionaccessor.TenantIdNotSetException;
import org.bonitasoft.engine.transaction.STransactionNotFoundException;
import org.bonitasoft.engine.transaction.TransactionService;
import org.bonitasoft.engine.work.AbstractWorkSynchronization;
import org.bonitasoft.engine.work.BonitaExecutorServiceFactory;
import org.bonitasoft.engine.work.BonitaWork;
import org.bonitasoft.engine.work.WorkRegisterException;
import org.bonitasoft.engine.work.WorkService;
import org.bonitasoft.engine.work.WorkSynchronizationFactory;

public class ExecutorWorkService
implements WorkService {
    private static final int TIMEOUT = Integer.valueOf(System.getProperty("bonita.work.termination.timeout", "15"));
    private final TransactionService transactionService;
    private ThreadPoolExecutor threadPoolExecutor;
    private final WorkSynchronizationFactory workSynchronizationFactory;
    private final ThreadLocal<AbstractWorkSynchronization> synchronizations = new ThreadLocal();
    private final TechnicalLoggerService loggerService;
    private final SessionAccessor sessionAccessor;
    private final Set<Long> deactivated = new HashSet<Long>();
    private final BonitaExecutorServiceFactory bonitaExecutorServiceFactory;

    public ExecutorWorkService(TransactionService transactionService, WorkSynchronizationFactory workSynchronizationFactory, TechnicalLoggerService loggerService, SessionAccessor sessionAccessor, BonitaExecutorServiceFactory bonitaExecutorServiceFactory) {
        this.transactionService = transactionService;
        this.workSynchronizationFactory = workSynchronizationFactory;
        this.loggerService = loggerService;
        this.sessionAccessor = sessionAccessor;
        this.bonitaExecutorServiceFactory = bonitaExecutorServiceFactory;
    }

    @Override
    public void registerWork(BonitaWork work) throws WorkRegisterException {
        AbstractWorkSynchronization synchro = this.getContinuationSynchronization(work);
        if (synchro != null) {
            synchro.addWork(work);
        }
    }

    @Override
    public void executeWork(BonitaWork work) throws WorkRegisterException {
        try {
            work.setTenantId(this.sessionAccessor.getTenantId());
        }
        catch (TenantIdNotSetException e) {
            throw new WorkRegisterException("Unable to read tenant id from session", e);
        }
        this.threadPoolExecutor.submit(work);
    }

    private synchronized AbstractWorkSynchronization getContinuationSynchronization(BonitaWork work) throws WorkRegisterException {
        if (this.threadPoolExecutor == null || this.threadPoolExecutor.isShutdown()) {
            this.loggerService.log(this.getClass(), TechnicalLogSeverity.WARNING, "Tried to register work " + work.getDescription() + " but the work service is shutdown. work will be restarted with the node");
            return null;
        }
        AbstractWorkSynchronization synchro = this.synchronizations.get();
        if (synchro == null || synchro.isExecuted()) {
            synchro = this.workSynchronizationFactory.getWorkSynchronization(this.threadPoolExecutor, this.loggerService, this.sessionAccessor, this);
            try {
                this.transactionService.registerBonitaSynchronization(synchro);
            }
            catch (STransactionNotFoundException e) {
                throw new WorkRegisterException(e.getMessage(), e);
            }
            this.synchronizations.set(synchro);
        }
        return synchro;
    }

    @Override
    public void stop(Long tenantId) {
        this.deactivated.add(tenantId);
    }

    @Override
    public void start(Long tenantId) {
        this.deactivated.remove(tenantId);
    }

    public boolean isStopped(long tenantId) {
        return this.deactivated.contains(tenantId);
    }

    @Override
    public void stop() {
        if (this.threadPoolExecutor != null && !this.threadPoolExecutor.isShutdown()) {
            this.threadPoolExecutor.shutdown();
            try {
                if (!this.threadPoolExecutor.awaitTermination(TIMEOUT, TimeUnit.SECONDS)) {
                    this.loggerService.log(this.getClass(), TechnicalLogSeverity.INFO, "Waited termination of all work " + TIMEOUT + "s but all task were not finished");
                }
            }
            catch (InterruptedException e) {
                this.loggerService.log(this.getClass(), TechnicalLogSeverity.ERROR, "error while waiting termination of all work ", e);
            }
        }
    }

    @Override
    public void start() {
        if (this.threadPoolExecutor == null || this.threadPoolExecutor.isShutdown()) {
            this.threadPoolExecutor = this.bonitaExecutorServiceFactory.createExecutorService();
        }
    }
}

