/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.api.impl;

import java.io.File;
import java.util.regex.Pattern;
import org.apache.commons.io.filefilter.RegexFileFilter;

public class DeepRegexFileFilter
extends RegexFileFilter {
    private static final long serialVersionUID = -8894250238822765740L;
    private final Pattern pattern;

    public DeepRegexFileFilter(String pattern) {
        super(pattern);
        if (pattern == null) {
            throw new IllegalArgumentException("Pattern is missing");
        }
        this.pattern = Pattern.compile(pattern);
    }

    public boolean accept(File dir, String name) {
        String fullName = dir.getAbsolutePath() + File.separator + name;
        fullName = fullName.replaceAll("\\\\", "/");
        return this.pattern.matcher(fullName).matches();
    }
}

