/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.bpm.classloader;

import org.bonitasoft.engine.classloader.ClassLoaderException;
import org.bonitasoft.engine.classloader.ClassLoaderService;
import org.bonitasoft.engine.classloader.ParentClassLoaderResolver;
import org.bonitasoft.engine.dependency.model.ScopeType;
import org.bonitasoft.engine.exception.BonitaRuntimeException;
import org.bonitasoft.engine.sessionaccessor.ReadSessionAccessor;
import org.bonitasoft.engine.sessionaccessor.TenantIdNotSetException;

public class BonitaBPMParentClassLoaderResolver
implements ParentClassLoaderResolver {
    private final ReadSessionAccessor sessionAccessor;

    public BonitaBPMParentClassLoaderResolver(ReadSessionAccessor sessionAccessor) {
        this.sessionAccessor = sessionAccessor;
    }

    @Override
    public ClassLoader getParent(ClassLoaderService classLoaderService, String childClassLoaderType, long childClassLoaderId) throws ClassLoaderException {
        if (ScopeType.PROCESS.name().equals(childClassLoaderType)) {
            try {
                Long tenantId = this.sessionAccessor.getTenantId();
                return classLoaderService.getLocalClassLoader(ScopeType.TENANT.name(), tenantId);
            }
            catch (TenantIdNotSetException e) {
                return classLoaderService.getGlobalClassLoader();
            }
        }
        if (ScopeType.TENANT.name().equals(childClassLoaderType)) {
            return classLoaderService.getGlobalClassLoader();
        }
        if ("___datasource___".equals(childClassLoaderType)) {
            return classLoaderService.getGlobalClassLoader();
        }
        throw new BonitaRuntimeException("unable to find a parent for type: " + childClassLoaderType);
    }
}

