/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.cache.ehcache;

import java.io.Serializable;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import org.bonitasoft.engine.cache.CacheConfiguration;
import org.bonitasoft.engine.cache.CacheConfigurations;
import org.bonitasoft.engine.cache.CacheException;
import org.bonitasoft.engine.cache.CommonCacheService;
import org.bonitasoft.engine.commons.LogUtil;
import org.bonitasoft.engine.log.technical.TechnicalLogSeverity;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;
import org.bonitasoft.engine.sessionaccessor.ReadSessionAccessor;

public abstract class CommonEhCacheCacheService
implements CommonCacheService {
    protected final CacheManager cacheManager;
    protected final TechnicalLoggerService logger;
    protected final ReadSessionAccessor sessionAccessor;
    protected final Map<String, net.sf.ehcache.config.CacheConfiguration> cacheConfigurations;

    public CommonEhCacheCacheService(TechnicalLoggerService logger, ReadSessionAccessor sessionAccessor, CacheConfigurations cacheConfigurations) {
        this(logger, sessionAccessor, cacheConfigurations, null);
    }

    public CommonEhCacheCacheService(TechnicalLoggerService logger, ReadSessionAccessor sessionAccessor, CacheConfigurations cacheConfigurations, URL configFile) {
        this.logger = logger;
        this.sessionAccessor = sessionAccessor;
        List<CacheConfiguration> configurations = cacheConfigurations.getConfigurations();
        this.cacheConfigurations = new HashMap<String, net.sf.ehcache.config.CacheConfiguration>(configurations.size());
        for (CacheConfiguration cacheConfig : configurations) {
            this.cacheConfigurations.put(cacheConfig.getName(), this.getEhCacheConfiguration(cacheConfig));
        }
        this.cacheManager = configFile != null ? CacheManager.create((URL)configFile) : CacheManager.create();
    }

    protected net.sf.ehcache.config.CacheConfiguration getEhCacheConfiguration(CacheConfiguration cacheConfig) {
        net.sf.ehcache.config.CacheConfiguration ehCacheConfig = new net.sf.ehcache.config.CacheConfiguration();
        ehCacheConfig.setMaxElementsInMemory(cacheConfig.getMaxElementsInMemory());
        ehCacheConfig.setMaxElementsOnDisk(cacheConfig.getMaxElementsOnDisk());
        ehCacheConfig.setOverflowToDisk(!cacheConfig.isInMemoryOnly());
        ehCacheConfig.setTimeToLiveSeconds(cacheConfig.getTimeToLiveSeconds());
        ehCacheConfig.setEternal(cacheConfig.isEternal());
        return ehCacheConfig;
    }

    protected synchronized Cache createCache(String cacheName, String internalCacheName) throws CacheException {
        Cache cache = this.cacheManager.getCache(internalCacheName);
        if (cache == null) {
            net.sf.ehcache.config.CacheConfiguration cacheConfiguration = this.cacheConfigurations.get(cacheName);
            if (cacheConfiguration != null) {
                net.sf.ehcache.config.CacheConfiguration newCacheConfig = cacheConfiguration.clone();
                newCacheConfig.setName(internalCacheName);
                cache = new Cache(newCacheConfig);
                this.cacheManager.addCache(cache);
            } else {
                throw new CacheException("No configuration found for the cache " + cacheName);
            }
        }
        return cache;
    }

    @Override
    public void store(String cacheName, Serializable key, Object value) throws CacheException {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "store"));
        }
        String cacheNameKey = this.getKeyFromCacheName(cacheName);
        try {
            Cache cache = this.cacheManager.getCache(cacheNameKey);
            if (cache == null) {
                cache = this.createCache(cacheName, cacheNameKey);
            }
            if (value instanceof Serializable) {
                cache.put(new Element(key, (Serializable)value));
            } else {
                cache.put(new Element((Object)key, value));
            }
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "store"));
            }
        }
        catch (IllegalStateException e) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "store", e));
            }
            StringBuilder stringBuilder = new StringBuilder("The cache '");
            stringBuilder.append(cacheNameKey).append("' is not alive");
            String msg = stringBuilder.toString();
            throw new CacheException(msg, e);
        }
        catch (net.sf.ehcache.CacheException ce) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "store", (Exception)((Object)ce)));
            }
            throw new CacheException(ce);
        }
    }

    protected abstract String getKeyFromCacheName(String var1) throws CacheException;

    @Override
    public Object get(String cacheName, Object key) throws CacheException {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "get"));
        }
        String cacheNameKey = this.getKeyFromCacheName(cacheName);
        try {
            Cache cache = this.cacheManager.getCache(cacheNameKey);
            if (cache == null) {
                return null;
            }
            Element element = cache.get(key);
            if (element != null) {
                if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                    this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "get"));
                }
                return element.getObjectValue();
            }
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "get"));
            }
            return null;
        }
        catch (IllegalStateException e) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "get", e));
            }
            StringBuilder stringBuilder = new StringBuilder("The cache '");
            stringBuilder.append(cacheNameKey).append("' is not alive");
            String msg = stringBuilder.toString();
            throw new CacheException(msg, e);
        }
        catch (Exception e) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "get", e));
            }
            StringBuilder stringBuilder = new StringBuilder("The cache '");
            stringBuilder.append(cacheNameKey).append("' does not exist");
            String msg = stringBuilder.toString();
            throw new CacheException(msg, e);
        }
    }

    @Override
    public boolean clear(String cacheName) throws CacheException {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "clear"));
        }
        String cacheNameKey = this.getKeyFromCacheName(cacheName);
        try {
            Cache cache = this.cacheManager.getCache(cacheNameKey);
            if (cache != null) {
                cache.removeAll();
            }
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "clear"));
            }
            return cache == null;
        }
        catch (IllegalStateException e) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "clear", e));
            }
            StringBuilder stringBuilder = new StringBuilder("The cache '");
            stringBuilder.append(cacheNameKey).append("' is not alive");
            String msg = stringBuilder.toString();
            throw new CacheException(msg, e);
        }
        catch (Exception e) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "clear", e));
            }
            StringBuilder stringBuilder = new StringBuilder("The cache '");
            stringBuilder.append(cacheNameKey).append("' does not exist");
            String msg = stringBuilder.toString();
            throw new CacheException(msg, e);
        }
    }

    @Override
    public int getCacheSize(String cacheName) throws CacheException {
        Cache cache = this.cacheManager.getCache(this.getKeyFromCacheName(cacheName));
        if (cache == null) {
            return 0;
        }
        return cache.getSize();
    }

    @Override
    public void clearAll() throws CacheException {
        try {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "clearAll"));
            }
            List<String> cacheNames = this.getCachesNames();
            for (String cacheName : cacheNames) {
                this.clear(cacheName);
            }
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "clearAll"));
            }
        }
        catch (net.sf.ehcache.CacheException e) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "clearAll", (Exception)((Object)e)));
            }
            throw new CacheException(e);
        }
    }

    @Override
    public boolean remove(String cacheName, Object key) throws CacheException {
        String cacheNameKey = this.getKeyFromCacheName(cacheName);
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "remove"));
        }
        Cache cache = this.cacheManager.getCache(cacheNameKey);
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "remove"));
        }
        return cache != null && cache.remove(key);
    }

    @Override
    public List<Object> getKeys(String cacheName) throws CacheException {
        String cacheNameKey = this.getKeyFromCacheName(cacheName);
        try {
            Cache cache;
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "getKeys"));
            }
            if ((cache = this.cacheManager.getCache(cacheNameKey)) == null) {
                StringBuilder message = new StringBuilder("The cache '");
                message.append(cacheNameKey).append("' does not exist");
                throw new CacheException(message.toString());
            }
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "getKeys"));
            }
            return cache.getKeys();
        }
        catch (IllegalStateException e) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "getKeys", e));
            }
            StringBuilder stringBuilder = new StringBuilder("The cache '");
            stringBuilder.append(cacheNameKey).append("' is not alive");
            String msg = stringBuilder.toString();
            throw new CacheException(msg, e);
        }
        catch (net.sf.ehcache.CacheException e) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "getKeys", (Exception)((Object)e)));
            }
            throw new CacheException(e);
        }
    }

    public void destroy() {
        this.cacheManager.shutdown();
    }
}

