/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.core.expression.control.api.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.bonitasoft.engine.classloader.ClassLoaderException;
import org.bonitasoft.engine.classloader.ClassLoaderService;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.core.expression.control.api.ExpressionResolverService;
import org.bonitasoft.engine.core.expression.control.model.SExpressionContext;
import org.bonitasoft.engine.core.process.definition.ProcessDefinitionService;
import org.bonitasoft.engine.core.process.definition.model.SProcessDefinition;
import org.bonitasoft.engine.expression.ExpressionExecutorStrategy;
import org.bonitasoft.engine.expression.ExpressionService;
import org.bonitasoft.engine.expression.ExpressionType;
import org.bonitasoft.engine.expression.exception.SExpressionDependencyMissingException;
import org.bonitasoft.engine.expression.exception.SExpressionEvaluationException;
import org.bonitasoft.engine.expression.exception.SExpressionTypeUnknownException;
import org.bonitasoft.engine.expression.exception.SInvalidExpressionException;
import org.bonitasoft.engine.expression.model.ExpressionKind;
import org.bonitasoft.engine.expression.model.SExpression;

public class ExpressionResolverServiceImpl
implements ExpressionResolverService {
    private static final SExpressionContext EMPTY_CONTEXT = new SExpressionContext();
    private final ExpressionService expressionService;
    private final ProcessDefinitionService processDefinitionService;
    private final ClassLoaderService classLoaderService;

    public ExpressionResolverServiceImpl(ExpressionService expressionService, ProcessDefinitionService processDefinitionService, ClassLoaderService classLoaderService) {
        this.expressionService = expressionService;
        this.processDefinitionService = processDefinitionService;
        this.classLoaderService = classLoaderService;
    }

    @Override
    public Object evaluate(SExpression expression) throws SExpressionTypeUnknownException, SExpressionEvaluationException, SExpressionDependencyMissingException, SInvalidExpressionException {
        return this.evaluate(expression, EMPTY_CONTEXT);
    }

    @Override
    public Object evaluate(SExpression expression, SExpressionContext evaluationContext) throws SExpressionTypeUnknownException, SExpressionEvaluationException, SExpressionDependencyMissingException, SInvalidExpressionException {
        return this.evaluateExpressionsFlatten(Collections.singletonList(expression), evaluationContext).get(0);
    }

    private List<Object> evaluateExpressionsFlatten(List<SExpression> expressions, SExpressionContext evaluationContext) throws SInvalidExpressionException, SExpressionTypeUnknownException, SExpressionEvaluationException, SExpressionDependencyMissingException {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            HashMap<String, Object> dependencyValues = new HashMap<String, Object>();
            if (evaluationContext == null) {
                evaluationContext = EMPTY_CONTEXT;
            } else {
                this.fillContext(evaluationContext, dependencyValues);
            }
            Long processDefinitionId = evaluationContext.getProcessDefinitionId();
            if (processDefinitionId != null) {
                Thread.currentThread().setContextClassLoader(this.classLoaderService.getLocalClassLoader("PROCESS", processDefinitionId));
            }
            HashMap<ExpressionKind, List<SExpression>> expressionMapByKind = new HashMap<ExpressionKind, List<SExpression>>();
            int totalSize = this.flattenDependencies(expressionMapByKind, expressions);
            ExpressionKind variableKind = new ExpressionKind(ExpressionType.TYPE_VARIABLE.name());
            HashMap<Integer, Object> resolvedExpressions = new HashMap<Integer, Object>(totalSize);
            Map<SExpression, SExpression> dataReplacement = Collections.emptyMap();
            List<SExpression> variableExpressions = expressionMapByKind.get(variableKind);
            if (evaluationContext.isEvaluateInDefinition() && variableExpressions != null && variableExpressions.size() > 0 && !this.variablesAreAllProvided(variableExpressions, evaluationContext)) {
                throw new SInvalidExpressionException("Evaluation of expressions of type VARIABLE is forbidden at process definition level");
            }
            for (ExpressionKind kind : ExpressionExecutorStrategy.NO_DEPENDENCY_EXPRESSION_EVALUATION_ORDER) {
                this.evaluateExpressionsOfKind(dependencyValues, expressionMapByKind, resolvedExpressions, kind, dataReplacement);
                expressionMapByKind.remove(kind);
            }
            for (SExpression sExpression : expressions) {
                this.evaluateExpressionWithResolvedDependencies(sExpression, dependencyValues, resolvedExpressions, dataReplacement);
            }
            ArrayList<Object> results = new ArrayList<Object>(expressions.size());
            for (SExpression sExpression : expressions) {
                int key = sExpression.getDiscriminant();
                Object res = resolvedExpressions.get(key);
                if (res == null && !resolvedExpressions.containsKey(key)) {
                    throw new SExpressionEvaluationException("No result found for the expression " + sExpression);
                }
                results.add(res);
            }
            ArrayList<Object> arrayList = results;
            return arrayList;
        }
        catch (ClassLoaderException e) {
            throw new SExpressionEvaluationException(e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    private boolean variablesAreAllProvided(List<SExpression> variableExpressions, SExpressionContext evaluationContext) {
        boolean containsAll = true;
        Iterator<SExpression> iterator = variableExpressions.iterator();
        Map<String, Object> inputValues = evaluationContext.getInputValues();
        while (containsAll && iterator.hasNext()) {
            SExpression next = iterator.next();
            containsAll = inputValues.containsKey(next.getContent());
        }
        return containsAll;
    }

    private void evaluateExpressionWithResolvedDependencies(SExpression sExpression, Map<String, Object> dependencyValues, Map<Integer, Object> resolvedExpressions, Map<SExpression, SExpression> dataReplacement) throws SExpressionTypeUnknownException, SExpressionEvaluationException, SExpressionDependencyMissingException, SInvalidExpressionException {
        for (SExpression dep : sExpression.getDependencies()) {
            this.evaluateExpressionWithResolvedDependencies(dep, dependencyValues, resolvedExpressions, dataReplacement);
        }
        if (!resolvedExpressions.containsKey(sExpression.getDiscriminant())) {
            Object exprResult = this.expressionService.evaluate(sExpression, dependencyValues, resolvedExpressions);
            this.addResultToMap(resolvedExpressions, dataReplacement, sExpression, exprResult, dependencyValues);
        }
    }

    private void evaluateExpressionsOfKind(Map<String, Object> dependencyValues, Map<ExpressionKind, List<SExpression>> expressionMapByKind, Map<Integer, Object> resolvedExpressions, ExpressionKind kind, Map<SExpression, SExpression> dataReplacement) throws SExpressionTypeUnknownException, SExpressionEvaluationException, SExpressionDependencyMissingException, SInvalidExpressionException {
        List<SExpression> expressionsOfKind = expressionMapByKind.get(kind);
        if (expressionsOfKind != null) {
            List<Object> evaluationResults = this.expressionService.evaluate(kind, expressionsOfKind, dependencyValues, resolvedExpressions);
            Iterator<SExpression> variableIterator = expressionsOfKind.iterator();
            for (Object evaluationResult : evaluationResults) {
                SExpression expression = variableIterator.next();
                this.addResultToMap(resolvedExpressions, dataReplacement, expression, evaluationResult, dependencyValues);
            }
        }
    }

    private void addResultToMap(Map<Integer, Object> resolvedExpressions, Map<SExpression, SExpression> dataReplacement, SExpression expression, Object expressionResult, Map<String, Object> dependencyValues) {
        SExpression replacement;
        resolvedExpressions.put(expression.getDiscriminant(), expressionResult);
        if (this.expressionService.mustPutEvaluatedExpressionInContext(expression.getExpressionKind())) {
            dependencyValues.put(expression.getContent(), expressionResult);
        }
        if ((replacement = dataReplacement.get(expression)) != null) {
            resolvedExpressions.put(replacement.getDiscriminant(), expressionResult);
            if (this.expressionService.mustPutEvaluatedExpressionInContext(expression.getExpressionKind())) {
                dependencyValues.put(replacement.getContent(), expressionResult);
            }
        }
    }

    private int flattenDependencies(Map<ExpressionKind, List<SExpression>> map, Collection<SExpression> collection) {
        int size = 0;
        for (SExpression sExpression : collection) {
            List<SExpression> exprList = this.getExpressionsOfKind(map, sExpression.getExpressionKind());
            if (!exprList.contains(sExpression)) {
                exprList.add(sExpression);
                ++size;
            }
            if (sExpression.getDependencies() == null) continue;
            size += this.flattenDependencies(map, sExpression.getDependencies());
        }
        return size;
    }

    private List<SExpression> getExpressionsOfKind(Map<ExpressionKind, List<SExpression>> map, ExpressionKind expressionKind) {
        List<SExpression> list = map.get(expressionKind);
        if (list == null) {
            list = new ArrayList<SExpression>();
            map.put(expressionKind, list);
        }
        return list;
    }

    private void fillContext(SExpressionContext evaluationContext, Map<String, Object> dependencyValues) throws SInvalidExpressionException {
        if (evaluationContext.getContainerId() == null && evaluationContext.getProcessDefinitionId() != null) {
            try {
                SProcessDefinition processDefinition = this.processDefinitionService.getProcessDefinition(evaluationContext.getProcessDefinitionId());
                evaluationContext.setProcessDefinition(processDefinition);
                evaluationContext.setEvaluateInDefinition(true);
            }
            catch (SBonitaException e) {
                throw new SInvalidExpressionException("Process definition not found with id " + evaluationContext.getProcessDefinitionId(), e);
            }
        }
        if (evaluationContext.getContainerId() != null) {
            dependencyValues.put("containerId", evaluationContext.getContainerId());
        }
        if (evaluationContext.getContainerType() != null) {
            dependencyValues.put("containerType", evaluationContext.getContainerType());
        }
        if (evaluationContext.getProcessDefinitionId() != null) {
            dependencyValues.put("processDefinitionId", evaluationContext.getProcessDefinitionId());
        }
        if (evaluationContext.getTime() != 0L) {
            dependencyValues.put("time", evaluationContext.getTime());
        }
        if (evaluationContext.getInputValues() != null) {
            dependencyValues.putAll(evaluationContext.getInputValues());
        }
    }

    @Override
    public List<Object> evaluate(List<SExpression> expressions, SExpressionContext contextDependency) throws SExpressionTypeUnknownException, SExpressionEvaluationException, SExpressionDependencyMissingException, SInvalidExpressionException {
        return this.evaluateExpressionsFlatten(expressions, contextDependency);
    }
}

