/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.core.expression.control.model;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bonitasoft.engine.core.process.definition.model.SFlowElementContainerDefinition;
import org.bonitasoft.engine.core.process.definition.model.SProcessDefinition;
import org.bonitasoft.engine.data.definition.model.SDataDefinition;
import org.bonitasoft.engine.expression.model.SExpression;

public class SExpressionContext
implements Serializable {
    private static final long serialVersionUID = 6417383664862870145L;
    public static final String containerIdKey = "containerId";
    public static final String containerTypeKey = "containerType";
    public static final String timeKey = "time";
    public static final String processDefinitionIdKey = "processDefinitionId";
    public static final String processDefinitionKey = "processDefinition";
    private Long containerId;
    private String containerType;
    private long time;
    private Long processDefinitionId;
    private SProcessDefinition processDefinition;
    private Map<String, Object> inputValues;
    private boolean evaluateInDefinition = false;
    private Map<String, SExpression> dataMap;
    private Map<SExpression, String> invertedDataMap;

    public SExpressionContext() {
        this.inputValues = new HashMap<String, Object>();
    }

    public SExpressionContext(Long containerId, String containerType, Long processDefinitionId) {
        this.containerId = containerId;
        this.containerType = containerType;
        this.processDefinitionId = processDefinitionId;
        this.inputValues = new HashMap<String, Object>();
    }

    public SExpressionContext(Long containerId, String containerType, Map<String, Serializable> inputValues) {
        this.containerId = containerId;
        this.containerType = containerType;
        this.inputValues = inputValues == null ? new HashMap<String, Object>() : new HashMap<String, Serializable>(inputValues);
    }

    public SExpressionContext(Long containerId, String containerType, Map<String, Serializable> inputValues, long time) {
        this.containerId = containerId;
        this.containerType = containerType;
        this.inputValues = inputValues == null ? new HashMap<String, Object>() : new HashMap<String, Serializable>(inputValues);
        this.time = time;
    }

    public Long getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public void setProcessDefinitionId(Long processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    public void setSerializableInputValues(Map<String, Serializable> inputValues) {
        if (inputValues != null) {
            this.inputValues.putAll(inputValues);
        }
    }

    public long getTime() {
        return this.time;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public void setContainerId(Long containerId) {
        this.containerId = containerId;
    }

    public void setContainerType(String containerType) {
        this.containerType = containerType;
    }

    public Long getContainerId() {
        return this.containerId;
    }

    public String getContainerType() {
        return this.containerType;
    }

    public Map<String, Object> getInputValues() {
        return this.inputValues;
    }

    public SProcessDefinition getProcessDefinition() {
        return this.processDefinition;
    }

    public void setProcessDefinition(SProcessDefinition processDefinition) {
        this.processDefinition = processDefinition;
        SFlowElementContainerDefinition processContainer = processDefinition.getProcessContainer();
        List<SDataDefinition> dataDefinitions = processContainer.getDataDefinitions();
        this.dataMap = new HashMap<String, SExpression>(dataDefinitions.size());
        this.invertedDataMap = new HashMap<SExpression, String>(dataDefinitions.size());
        for (SDataDefinition dataDef : dataDefinitions) {
            this.dataMap.put(dataDef.getName(), dataDef.getDefaultValueExpression());
            this.invertedDataMap.put(dataDef.getDefaultValueExpression(), dataDef.getName());
        }
    }

    public SExpression getDefaultValueFor(String name) {
        if (this.evaluateInDefinition) {
            return this.dataMap.get(name);
        }
        return null;
    }

    public String isDefaultValueOf(SExpression exp) {
        if (this.evaluateInDefinition) {
            return this.invertedDataMap.get(exp);
        }
        return null;
    }

    public void setInputValues(Map<String, Object> inputValues) {
        this.inputValues = inputValues == null ? new HashMap<String, Object>() : inputValues;
    }

    public void setEvaluateInDefinition(boolean evaluateInDefinition) {
        this.evaluateInDefinition = evaluateInDefinition;
    }

    public boolean isEvaluateInDefinition() {
        return this.evaluateInDefinition;
    }
}

