/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.core.process.definition.model.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.bonitasoft.engine.bpm.flownode.ActivityDefinition;
import org.bonitasoft.engine.bpm.flownode.CallActivityDefinition;
import org.bonitasoft.engine.core.operation.model.SOperation;
import org.bonitasoft.engine.core.process.definition.model.SCallActivityDefinition;
import org.bonitasoft.engine.core.process.definition.model.SCallableElementType;
import org.bonitasoft.engine.core.process.definition.model.SFlowNodeType;
import org.bonitasoft.engine.core.process.definition.model.STransitionDefinition;
import org.bonitasoft.engine.core.process.definition.model.builder.ServerModelConvertor;
import org.bonitasoft.engine.core.process.definition.model.impl.SActivityDefinitionImpl;
import org.bonitasoft.engine.expression.model.SExpression;

public class SCallActivityDefinitionImpl
extends SActivityDefinitionImpl
implements SCallActivityDefinition {
    private static final long serialVersionUID = -5347512435504138388L;
    private SExpression callableElement;
    private SExpression callableElementVersion;
    private final List<SOperation> dataInputOperations;
    private final List<SOperation> dataOutputOperations;
    private SCallableElementType callableElementType;

    public SCallActivityDefinitionImpl(long id, String name) {
        super(id, name);
        this.dataInputOperations = new ArrayList<SOperation>(3);
        this.dataOutputOperations = new ArrayList<SOperation>(3);
    }

    public SCallActivityDefinitionImpl(CallActivityDefinition activityDefinition, Map<String, STransitionDefinition> transitionsMap) {
        super((ActivityDefinition)activityDefinition, transitionsMap);
        this.callableElement = ServerModelConvertor.convertExpression(activityDefinition.getCallableElement());
        this.callableElementVersion = ServerModelConvertor.convertExpression(activityDefinition.getCallableElementVersion());
        this.dataInputOperations = ServerModelConvertor.convertOperations(activityDefinition.getDataInputOperations());
        this.dataOutputOperations = ServerModelConvertor.convertOperations(activityDefinition.getDataOutputOperations());
        this.callableElementType = SCallableElementType.valueOf(activityDefinition.getCallableElementType().name());
    }

    @Override
    public SExpression getCallableElement() {
        return this.callableElement;
    }

    public void setCallableElement(SExpression callableElement) {
        this.callableElement = callableElement;
    }

    @Override
    public SExpression getCallableElementVersion() {
        return this.callableElementVersion;
    }

    public void setCallableElementVersion(SExpression callableElementVersion) {
        this.callableElementVersion = callableElementVersion;
    }

    @Override
    public List<SOperation> getDataInputOperations() {
        return Collections.unmodifiableList(this.dataInputOperations);
    }

    public void addDataInputOperation(SOperation dataInputOperation) {
        this.dataInputOperations.add(dataInputOperation);
    }

    @Override
    public List<SOperation> getDataOutputOperations() {
        return Collections.unmodifiableList(this.dataOutputOperations);
    }

    public void addDataOutputOperation(SOperation dataOutputOperation) {
        this.dataOutputOperations.add(dataOutputOperation);
    }

    @Override
    public SCallableElementType getCallableElementType() {
        return this.callableElementType;
    }

    public void setCallableElementType(SCallableElementType callableElementType) {
        this.callableElementType = callableElementType;
    }

    @Override
    public SFlowNodeType getType() {
        return SFlowNodeType.CALL_ACTIVITY;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.callableElement == null ? 0 : this.callableElement.hashCode());
        result = 31 * result + (this.callableElementType == null ? 0 : this.callableElementType.hashCode());
        result = 31 * result + (this.callableElementVersion == null ? 0 : this.callableElementVersion.hashCode());
        result = 31 * result + (this.dataInputOperations == null ? 0 : this.dataInputOperations.hashCode());
        result = 31 * result + (this.dataOutputOperations == null ? 0 : this.dataOutputOperations.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SCallActivityDefinitionImpl other = (SCallActivityDefinitionImpl)obj;
        if (this.callableElement == null ? other.callableElement != null : !this.callableElement.equals(other.callableElement)) {
            return false;
        }
        if (this.callableElementType != other.callableElementType) {
            return false;
        }
        if (this.callableElementVersion == null ? other.callableElementVersion != null : !this.callableElementVersion.equals(other.callableElementVersion)) {
            return false;
        }
        if (this.dataInputOperations == null ? other.dataInputOperations != null : !this.dataInputOperations.equals(other.dataInputOperations)) {
            return false;
        }
        return !(this.dataOutputOperations == null ? other.dataOutputOperations != null : !this.dataOutputOperations.equals(other.dataOutputOperations));
    }
}

