/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.execution.flowmerger;

import org.bonitasoft.engine.core.process.definition.model.SFlowNodeDefinition;
import org.bonitasoft.engine.core.process.definition.model.SFlowNodeType;
import org.bonitasoft.engine.core.process.definition.model.SGatewayDefinition;
import org.bonitasoft.engine.core.process.definition.model.SGatewayType;
import org.bonitasoft.engine.core.process.definition.model.SSubProcessDefinition;
import org.bonitasoft.engine.core.process.definition.model.event.SCatchEventDefinition;

public class SFlowNodeWrapper {
    private SFlowNodeDefinition flowNode;

    public SFlowNodeWrapper(SFlowNodeDefinition flowNode) {
        this.flowNode = flowNode;
    }

    public boolean isParalleleOrInclusive() {
        if (!this.isGateway()) {
            return false;
        }
        SGatewayType gatewayType = ((SGatewayDefinition)this.flowNode).getGatewayType();
        return SGatewayType.PARALLEL.equals((Object)gatewayType) || SGatewayType.INCLUSIVE.equals((Object)gatewayType);
    }

    public boolean isExclusive() {
        if (!this.isGateway()) {
            return false;
        }
        SGatewayType gatewayType = ((SGatewayDefinition)this.flowNode).getGatewayType();
        return SGatewayType.EXCLUSIVE.equals((Object)gatewayType);
    }

    private boolean isGateway() {
        if (this.isNull()) {
            return false;
        }
        return SFlowNodeType.GATEWAY.equals((Object)this.flowNode.getType());
    }

    public SFlowNodeDefinition getFlowNode() {
        return this.flowNode;
    }

    public boolean isBoundaryEvent() {
        if (this.isNull()) {
            return false;
        }
        return SFlowNodeType.BOUNDARY_EVENT.equals((Object)this.flowNode.getType());
    }

    public boolean isInterrupting() {
        if (this.isNull() || !(this.flowNode instanceof SCatchEventDefinition)) {
            return false;
        }
        return ((SCatchEventDefinition)this.flowNode).isInterrupting();
    }

    public boolean isNull() {
        return this.flowNode == null;
    }

    public boolean hasIncomingTransitions() {
        return this.flowNode.hasIncomingTransitions();
    }

    public boolean isEventSubProcess() {
        if (this.isNull()) {
            return false;
        }
        return SFlowNodeType.SUB_PROCESS.equals((Object)this.flowNode.getType()) && ((SSubProcessDefinition)this.flowNode).isTriggeredByEvent();
    }
}

