/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.external.web.forms;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.bonitasoft.engine.api.impl.SessionInfos;
import org.bonitasoft.engine.classloader.ClassLoaderService;
import org.bonitasoft.engine.command.SCommandExecutionException;
import org.bonitasoft.engine.command.SCommandParameterizationException;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.core.expression.control.model.SExpressionContext;
import org.bonitasoft.engine.core.operation.OperationService;
import org.bonitasoft.engine.core.process.instance.api.ActivityInstanceService;
import org.bonitasoft.engine.core.process.instance.model.SFlowNodeInstance;
import org.bonitasoft.engine.data.instance.api.DataInstanceContainer;
import org.bonitasoft.engine.dependency.model.ScopeType;
import org.bonitasoft.engine.exception.BonitaException;
import org.bonitasoft.engine.execution.ProcessExecutor;
import org.bonitasoft.engine.external.web.forms.ExecuteActionsBaseEntry;
import org.bonitasoft.engine.log.LogMessageBuilder;
import org.bonitasoft.engine.log.technical.TechnicalLogSeverity;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;
import org.bonitasoft.engine.operation.Operation;
import org.bonitasoft.engine.operation.OperationExecutionException;
import org.bonitasoft.engine.service.ModelConvertor;
import org.bonitasoft.engine.service.TenantServiceAccessor;
import org.bonitasoft.engine.service.TenantServiceSingleton;

public class ExecuteActionsAndTerminateTask
extends ExecuteActionsBaseEntry {
    public static final String ACTIVITY_INSTANCE_ID_KEY = "ACTIVITY_INSTANCE_ID_KEY";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Serializable execute(Map<String, Serializable> parameters, TenantServiceAccessor serviceAccessor) throws SCommandParameterizationException, SCommandExecutionException {
        List<Operation> operations = this.getOperations(parameters);
        Map<String, Serializable> operationsContext = this.getOperationsContext(parameters);
        long sActivityInstanceID = this.getActivityInstanceId(parameters);
        try {
            TechnicalLoggerService logger = serviceAccessor.getTechnicalLoggerService();
            ClassLoaderService classLoaderService = serviceAccessor.getClassLoaderService();
            ActivityInstanceService activityInstanceService = serviceAccessor.getActivityInstanceService();
            SFlowNodeInstance flowNodeInstance = activityInstanceService.getFlowNodeInstance(sActivityInstanceID);
            long processDefinitionID = flowNodeInstance.getProcessDefinitionId();
            ClassLoader processClassloader = classLoaderService.getLocalClassLoader(ScopeType.PROCESS.name(), processDefinitionID);
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(processClassloader);
                this.updateActivityInstanceVariables(operations, operationsContext, sActivityInstanceID, processDefinitionID);
            }
            finally {
                Thread.currentThread().setContextClassLoader(contextClassLoader);
            }
            this.executeActivity(flowNodeInstance, logger);
        }
        catch (BonitaException e) {
            throw new SCommandExecutionException("Error executing command 'Map<String, Serializable> ExecuteActionsAndTerminateTask(List<Operation>, Map<String, Serializable>, long activityInstanceId)'", e);
        }
        catch (SBonitaException e) {
            throw new SCommandExecutionException("Error executing command 'Map<String, Serializable> ExecuteActionsAndTerminateTask(List<Operation>, Map<String, Serializable>, long activityInstanceId)'", e);
        }
        return null;
    }

    protected long getActivityInstanceId(Map<String, Serializable> parameters) throws SCommandParameterizationException {
        String message = "Mandatory parameter ACTIVITY_INSTANCE_ID_KEY is missing or not convertible to long.";
        Long instanceId = (Long)this.getMandatoryParameter(parameters, ACTIVITY_INSTANCE_ID_KEY, "Mandatory parameter ACTIVITY_INSTANCE_ID_KEY is missing or not convertible to long.");
        return instanceId;
    }

    protected List<Operation> getOperations(Map<String, Serializable> parameters) throws SCommandParameterizationException {
        String message = "Mandatory parameter OPERATIONS_LIST_KEY is missing or not convertible to List.";
        return (List)this.getParameter(parameters, "OPERATIONS_LIST_KEY", "Mandatory parameter OPERATIONS_LIST_KEY is missing or not convertible to List.");
    }

    protected Map<String, Serializable> getOperationsContext(Map<String, Serializable> parameters) throws SCommandParameterizationException {
        String message = "Mandatory parameter OPERATIONS_INPUT_KEY is missing or not convertible to Map.";
        return (Map)this.getParameter(parameters, "OPERATIONS_INPUT_KEY", "Mandatory parameter OPERATIONS_INPUT_KEY is missing or not convertible to Map.");
    }

    protected void updateActivityInstanceVariables(List<Operation> operations, Map<String, Serializable> operationsContext, long activityInstanceId, Long processDefinitionID) throws BonitaException {
        TenantServiceAccessor tenantAccessor = TenantServiceSingleton.getInstance(this.getTenantId());
        OperationService operationService = tenantAccessor.getOperationService();
        Iterator<Operation> iterator = operations.iterator();
        SExpressionContext sExpressionContext = new SExpressionContext();
        sExpressionContext.setSerializableInputValues(operationsContext);
        sExpressionContext.setContainerId(activityInstanceId);
        sExpressionContext.setContainerType(DataInstanceContainer.ACTIVITY_INSTANCE.name());
        sExpressionContext.setProcessDefinitionId(processDefinitionID);
        try {
            while (iterator.hasNext()) {
                Operation entry = iterator.next();
                operationService.execute(ModelConvertor.constructSOperation(entry), activityInstanceId, DataInstanceContainer.ACTIVITY_INSTANCE.name(), sExpressionContext);
            }
        }
        catch (SBonitaException e) {
            throw new OperationExecutionException((Throwable)e);
        }
    }

    protected void executeActivity(SFlowNodeInstance flowNodeInstance, TechnicalLoggerService logger) throws BonitaException {
        TenantServiceAccessor tenantAccessor = TenantServiceSingleton.getInstance(this.getTenantId());
        ProcessExecutor processExecutor = tenantAccessor.getProcessExecutor();
        try {
            SessionInfos sessionInfos = SessionInfos.getSessionInfos();
            long userId = sessionInfos.getUserId();
            long processDefinitionId = flowNodeInstance.getProcessDefinitionId();
            boolean isFirstState = flowNodeInstance.getStateId() == 0;
            processExecutor.executeFlowNode(flowNodeInstance.getId(), null, null, processDefinitionId, userId, userId);
            if (logger.isLoggable(this.getClass(), TechnicalLogSeverity.INFO) && !isFirstState) {
                String message = "The user <" + sessionInfos.getUsername() + "> has performed the task" + LogMessageBuilder.buildFlowNodeContextMessage(flowNodeInstance);
                logger.log(this.getClass(), TechnicalLogSeverity.INFO, message);
            }
        }
        catch (SBonitaException e) {
            this.log(tenantAccessor, e);
            throw new BonitaException(e.getMessage());
        }
    }
}

