/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.search.profile;

import java.util.List;
import org.bonitasoft.engine.persistence.QueryOptions;
import org.bonitasoft.engine.persistence.SBonitaSearchException;
import org.bonitasoft.engine.profile.ProfileEntry;
import org.bonitasoft.engine.profile.ProfileService;
import org.bonitasoft.engine.profile.model.SProfileEntry;
import org.bonitasoft.engine.search.AbstractSearchEntity;
import org.bonitasoft.engine.search.SearchOptions;
import org.bonitasoft.engine.search.descriptor.SearchProfileEntryDescriptor;
import org.bonitasoft.engine.service.ModelConvertor;

public class SearchProfileEntries
extends AbstractSearchEntity<ProfileEntry, SProfileEntry> {
    private final ProfileService profileService;

    public SearchProfileEntries(ProfileService profileService, SearchProfileEntryDescriptor searchDescriptor, SearchOptions options) {
        super(searchDescriptor, options);
        this.profileService = profileService;
    }

    @Override
    public long executeCount(QueryOptions queryOptions) throws SBonitaSearchException {
        return this.profileService.getNumberOfProfileEntries(queryOptions);
    }

    @Override
    public List<SProfileEntry> executeSearch(QueryOptions queryOptions) throws SBonitaSearchException {
        return this.profileService.searchProfileEntries(queryOptions);
    }

    @Override
    public List<ProfileEntry> convertToClientObjects(List<SProfileEntry> serverObjects) {
        return ModelConvertor.toProfileEntries(serverObjects);
    }
}

