/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.sessionaccessor;

import org.bonitasoft.engine.sessionaccessor.SessionAccessor;
import org.bonitasoft.engine.sessionaccessor.SessionIdNotSetException;
import org.bonitasoft.engine.sessionaccessor.TenantIdNotSetException;

public class ThreadLocalSessionAccessor
implements SessionAccessor {
    private final Object mutex = new Object();
    private final ThreadLocal<Long> sessionData = new ThreadLocal();
    private final ThreadLocal<Long> tenantData = new ThreadLocal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getSessionId() throws SessionIdNotSetException {
        Long sessionId = null;
        Object object = this.mutex;
        synchronized (object) {
            sessionId = this.sessionData.get();
            if (sessionId == null) {
                throw new SessionIdNotSetException("No session set.");
            }
        }
        return sessionId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSessionInfo(long sessionId, long tenantId) {
        Object object = this.mutex;
        synchronized (object) {
            this.sessionData.set(sessionId);
            this.tenantData.set(tenantId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTenantId(long tenantId) {
        Object object = this.mutex;
        synchronized (object) {
            this.tenantData.set(tenantId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteSessionId() {
        Object object = this.mutex;
        synchronized (object) {
            this.sessionData.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteTenantId() {
        Object object = this.mutex;
        synchronized (object) {
            this.tenantData.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getTenantId() throws TenantIdNotSetException {
        Long tenantId = null;
        Object object = this.mutex;
        synchronized (object) {
            tenantId = this.tenantData.get();
            if (tenantId == null) {
                throw new TenantIdNotSetException("No tenantId set.");
            }
        }
        return tenantId;
    }
}

