/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.api.impl;

import java.util.Collections;
import java.util.List;
import org.bonitasoft.engine.api.impl.NodeConfiguration;
import org.bonitasoft.engine.commons.RestartHandler;
import org.bonitasoft.engine.commons.ServiceWithLifecycle;
import org.bonitasoft.engine.execution.work.TenantRestartHandler;
import org.bonitasoft.engine.scheduler.JobRegister;

public class NodeConfigurationImpl
implements NodeConfiguration {
    private boolean shouldStartScheduler = true;
    private boolean shouldRestartElements = true;
    private List<RestartHandler> restartHandlers;
    private String eventHandlingJobCron = "*/5 * * * * ?";
    private String cleanInvalidSessionsJobCron = "0 0 */2 * * ?";
    private boolean shouldStartEventHandlingJob = true;
    private List<TenantRestartHandler> tenantRestartHandlers;
    private List<JobRegister> jobsToRegister;
    private List<ServiceWithLifecycle> servicesToStart;

    @Override
    public boolean shouldStartScheduler() {
        return this.shouldStartScheduler;
    }

    @Override
    public boolean shouldResumeElements() {
        return this.shouldRestartElements;
    }

    @Override
    public List<RestartHandler> getRestartHandlers() {
        return this.emptyOrUnmodifiable(this.restartHandlers);
    }

    public void setRestartHandlers(List<RestartHandler> restartHandlers) {
        this.restartHandlers = restartHandlers;
    }

    @Override
    public List<TenantRestartHandler> getTenantRestartHandlers() {
        return this.emptyOrUnmodifiable(this.tenantRestartHandlers);
    }

    public void setTenantRestartHandlers(List<TenantRestartHandler> tenantRestartHandlers) {
        this.tenantRestartHandlers = tenantRestartHandlers;
    }

    @Override
    public String getEventHandlingJobCron() {
        return this.eventHandlingJobCron;
    }

    @Override
    public boolean shouldStartEventHandlingJob() {
        return this.shouldStartEventHandlingJob;
    }

    public void setShouldStartScheduler(boolean shouldStartScheduler) {
        this.shouldStartScheduler = shouldStartScheduler;
    }

    public void setShouldRestartElements(boolean shouldRestartElements) {
        this.shouldRestartElements = shouldRestartElements;
    }

    public void setEventHandlingJobCron(String eventHandlingJobCron) {
        this.eventHandlingJobCron = eventHandlingJobCron;
    }

    public void setShouldStartEventHandlingJob(boolean shouldStartEventHandlingJob) {
        this.shouldStartEventHandlingJob = shouldStartEventHandlingJob;
    }

    public void setJobsToRegister(List<JobRegister> jobsToRegister) {
        this.jobsToRegister = jobsToRegister;
    }

    @Override
    public List<JobRegister> getJobsToRegister() {
        return this.emptyOrUnmodifiable(this.jobsToRegister);
    }

    @Override
    public String getCleanInvalidSessionsJobCron() {
        return this.cleanInvalidSessionsJobCron;
    }

    public void setCleanInvalidSessionsJobCron(String cleanInvalidSessionsJobCron) {
        this.cleanInvalidSessionsJobCron = cleanInvalidSessionsJobCron;
    }

    @Override
    public boolean shouldClearSessions() {
        return true;
    }

    private <T> List<T> emptyOrUnmodifiable(List<T> list) {
        return list == null ? Collections.emptyList() : Collections.unmodifiableList(list);
    }

    @Override
    public List<ServiceWithLifecycle> getServicesToStart() {
        return this.servicesToStart;
    }

    public void setServicesToStart(List<ServiceWithLifecycle> servicesToStart) {
        this.servicesToStart = servicesToStart;
    }
}

