/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.archive.impl;

import java.util.ArrayList;
import java.util.List;
import org.bonitasoft.engine.persistence.ArchivedPersistentObject;
import org.bonitasoft.engine.persistence.PersistentObject;
import org.bonitasoft.engine.services.PersistenceService;
import org.bonitasoft.engine.services.SPersistenceException;
import org.bonitasoft.engine.transaction.BonitaTransactionSynchronization;
import org.bonitasoft.engine.transaction.TransactionState;

public class BatchArchiveSynchronization
implements BonitaTransactionSynchronization {
    private final PersistenceService persistenceService;
    private final List<ArchivedPersistentObject> archivedObjects;

    public BatchArchiveSynchronization(PersistenceService persistenceService) {
        this.persistenceService = persistenceService;
        this.archivedObjects = new ArrayList<ArchivedPersistentObject>();
    }

    @Override
    public void afterCompletion(TransactionState status) {
    }

    @Override
    public void beforeCommit() {
        if (this.archivedObjects != null && !this.archivedObjects.isEmpty()) {
            try {
                this.persistenceService.insertInBatch(new ArrayList<PersistentObject>(this.archivedObjects));
                this.persistenceService.flushStatements();
            }
            catch (SPersistenceException spe) {
                throw new RuntimeException(spe);
            }
            finally {
                this.archivedObjects.clear();
            }
        }
    }

    public void addArchivedObject(ArchivedPersistentObject archivedPersistentObject) {
        this.archivedObjects.add(archivedPersistentObject);
    }
}

