/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.classloader;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.bonitasoft.engine.classloader.MonoParentJarFileClassLoader;
import org.bonitasoft.engine.commons.NullCheckingUtil;
import org.bonitasoft.engine.commons.io.IOUtil;

public class BonitaClassLoader
extends MonoParentJarFileClassLoader {
    private final String type;
    private final long id;
    protected Map<String, byte[]> nonJarResources;
    protected Set<URL> urls;
    private final File temporaryFolder;

    BonitaClassLoader(Map<String, byte[]> resources, String type, long id, String temporaryFolder, ClassLoader parent) {
        super(type + "__" + id, new URL[0], parent);
        NullCheckingUtil.checkArgsNotNull(resources, type, id, temporaryFolder, parent);
        this.type = type;
        this.id = id;
        this.nonJarResources = new HashMap<String, byte[]>();
        this.urls = new HashSet<URL>();
        this.temporaryFolder = new File(temporaryFolder);
        if (!this.temporaryFolder.exists()) {
            this.temporaryFolder.mkdirs();
        }
        this.addResources(resources);
        this.addURLs(this.urls.toArray(new URL[this.urls.size()]));
    }

    protected void addResources(Map<String, byte[]> resources) {
        if (resources != null) {
            for (Map.Entry<String, byte[]> resource : resources.entrySet()) {
                if (resource.getKey().matches(".*\\.jar")) {
                    byte[] data = resource.getValue();
                    try {
                        File file = IOUtil.createTempFile(resource.getKey(), null, this.temporaryFolder);
                        IOUtil.write(file, data);
                        String path = file.getAbsolutePath();
                        URL url = new File(path).toURI().toURL();
                        this.urls.add(url);
                        file.deleteOnExit();
                    }
                    catch (MalformedURLException e) {
                        e.printStackTrace();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                this.nonJarResources.put(resource.getKey(), resource.getValue());
            }
        }
    }

    public InputStream getResourceAsStream(String name) {
        InputStream is = this.getInternalInputstream(name);
        if (is == null && name.length() > 0 && name.charAt(0) == '/') {
            is = this.getInternalInputstream(name.substring(1));
        }
        return is;
    }

    private InputStream getInternalInputstream(String name) {
        byte[] classData = this.loadProcessResource(name);
        if (classData != null) {
            return new ByteArrayInputStream(classData);
        }
        InputStream is = super.getResourceAsStream(name);
        if (is != null) {
            return is;
        }
        return null;
    }

    private byte[] loadProcessResource(String resourceName) {
        if (this.nonJarResources == null) {
            return null;
        }
        return this.nonJarResources.get(resourceName);
    }

    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c;
        block6: {
            c = null;
            c = this.findLoadedClass(name);
            if (c == null) {
                try {
                    c = this.findClass(name);
                }
                catch (ClassNotFoundException e) {
                }
                catch (LinkageError le) {
                    c = this.findLoadedClass(name);
                    if (c != null) break block6;
                    throw le;
                }
            }
        }
        if (c == null) {
            c = this.getParent().loadClass(name);
        }
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    public void release() {
        if (this.temporaryFolder.exists()) {
            this.temporaryFolder.delete();
        }
    }

    public long getId() {
        return this.id;
    }

    public String getType() {
        return this.type;
    }

    public File getTemporaryFolder() {
        return this.temporaryFolder;
    }

    public String toString() {
        return super.toString() + ", type=" + this.type + ", id=" + this.id;
    }
}

