/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.events.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.bonitasoft.engine.commons.LogUtil;
import org.bonitasoft.engine.events.EventActionType;
import org.bonitasoft.engine.events.EventService;
import org.bonitasoft.engine.events.model.FireEventException;
import org.bonitasoft.engine.events.model.HandlerRegistrationException;
import org.bonitasoft.engine.events.model.HandlerUnregistrationException;
import org.bonitasoft.engine.events.model.SEvent;
import org.bonitasoft.engine.events.model.SHandler;
import org.bonitasoft.engine.log.technical.TechnicalLogSeverity;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;

public abstract class AbstractEventServiceImpl
implements EventService {
    protected final TechnicalLoggerService logger;

    protected AbstractEventServiceImpl(TechnicalLoggerService logger) {
        this.logger = logger;
    }

    @Override
    public void fireEvent(SEvent event) throws FireEventException {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "fireEvent"));
        }
        if (event != null) {
            Collection<SHandler<SEvent>> handlers;
            if (this.containsHandlerFor(event.getType()) && (handlers = this.getHandlersFor(event.getType())).size() > 0) {
                if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                    this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, "Found " + handlers.size() + " for event " + event.getType() + " All handlers: " + handlers);
                }
                FireEventException fireEventException = null;
                for (SHandler<SEvent> handler : handlers) {
                    try {
                        if (!handler.isInterested(event)) continue;
                        handler.execute(event);
                    }
                    catch (Exception e) {
                        if (fireEventException == null) {
                            fireEventException = new FireEventException("Unable to execute some handler");
                        }
                        fireEventException.addHandlerException(e);
                        if (!this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.ERROR)) continue;
                        this.logger.log(this.getClass(), TechnicalLogSeverity.ERROR, "Unable to execute handler", e);
                    }
                }
                if (fireEventException != null) {
                    throw fireEventException;
                }
            }
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "fireEvent"));
            }
        } else {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "fireEvent", "Unable to fire a null event"));
            }
            throw new FireEventException("Unable to fire a null event");
        }
    }

    protected abstract Collection<SHandler<SEvent>> getHandlersFor(String var1);

    protected abstract boolean containsHandlerFor(String var1);

    @Override
    public final void addHandler(String eventType, SHandler<SEvent> handler) throws HandlerRegistrationException {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "addHandler"));
        }
        if (handler != null && eventType != null) {
            this.addHandlerFor(eventType, handler);
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "addHandler"));
            }
        } else {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "addHandler", "Event type and/or handler is null"));
            }
            throw new HandlerRegistrationException("One of the parameters is null :  eventType: " + eventType + " handler:" + handler);
        }
    }

    protected abstract void addHandlerFor(String var1, SHandler<SEvent> var2) throws HandlerRegistrationException;

    @Override
    public final void removeAllHandlers(SHandler<SEvent> handler) throws HandlerUnregistrationException {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "removeAllHandlers"));
        }
        if (handler == null) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "removeAllHandlers", "Unable to remove a null event"));
            }
            throw new HandlerUnregistrationException();
        }
        this.removeAllHandlersFor(handler);
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "removeAllHandlers"));
        }
    }

    protected abstract void removeAllHandlersFor(SHandler<SEvent> var1);

    @Override
    public final void removeHandler(String eventType, SHandler<SEvent> h) throws HandlerUnregistrationException {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "removeHandler"));
        }
        if (h == null || eventType == null) {
            throw new HandlerUnregistrationException();
        }
        this.removeHandlerFor(eventType, h);
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "removeHandler"));
        }
    }

    protected abstract void removeHandlerFor(String var1, SHandler<SEvent> var2) throws HandlerUnregistrationException;

    @Override
    public final Set<SHandler<SEvent>> getHandlers(String eventType) {
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "getHandlers"));
        }
        Collection<SHandler<SEvent>> handlers = this.getHandlersFor(eventType);
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "getHandlers"));
        }
        if (handlers == null) {
            return Collections.emptySet();
        }
        HashSet<SHandler<SEvent>> hashSet = new HashSet<SHandler<SEvent>>(handlers.size());
        hashSet.addAll(handlers);
        return hashSet;
    }

    @Override
    public final boolean hasHandlers(String eventType, EventActionType actionType) {
        String key = eventType;
        if (actionType != null) {
            switch (actionType) {
                case CREATED: {
                    key = key + "_CREATED";
                    break;
                }
                case DELETED: {
                    key = key + "_DELETED";
                    break;
                }
                case UPDATED: {
                    key = key + "_UPDATED";
                    break;
                }
                default: {
                    return false;
                }
            }
        }
        return this.containsHandlerFor(key);
    }
}

