/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.execution;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.core.expression.control.model.SExpressionContext;
import org.bonitasoft.engine.core.operation.model.SOperation;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SActivityExecutionException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SFlowNodeExecutionException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SFlowNodeReadException;
import org.bonitasoft.engine.execution.ContainerExecutor;
import org.bonitasoft.engine.execution.work.WorkFactory;
import org.bonitasoft.engine.work.WorkRegisterException;
import org.bonitasoft.engine.work.WorkService;

public class ContainerRegistry {
    private final Map<String, ContainerExecutor> executors = new HashMap<String, ContainerExecutor>(2);
    private final WorkService workService;

    public ContainerRegistry(WorkService workService) {
        this.workService = workService;
    }

    public void addContainerExecutor(ContainerExecutor containerExecutor) {
        this.executors.put(containerExecutor.getHandledType(), containerExecutor);
    }

    public void nodeReachedState(long processDefinitionId, long flowNodeInstanceId, int stateId, long parentId, String parentType) throws SBonitaException {
        ContainerExecutor containerExecutor = this.executors.get(parentType);
        if (containerExecutor == null) {
            throw new SActivityExecutionException("There is no container executor for the container " + parentId + " having the type " + parentType);
        }
        containerExecutor.childFinished(processDefinitionId, flowNodeInstanceId, stateId, parentId);
    }

    private ContainerExecutor getContainerExecutor(String containerType) {
        return this.executors.get(containerType);
    }

    public void executeFlowNode(long flowNodeInstanceId, SExpressionContext contextDependency, List<SOperation> operations, String containerType, long processInstanceId) throws WorkRegisterException {
        this.workService.registerWork(WorkFactory.createExecuteFlowNodeWork(flowNodeInstanceId, operations, contextDependency, processInstanceId));
    }

    public void executeFlowNodeInSameThread(long flowNodeInstanceId, SExpressionContext contextDependency, List<SOperation> operations, String containerType, Long processInstanceId) throws SFlowNodeReadException, SFlowNodeExecutionException {
        ContainerExecutor containerExecutor = this.getContainerExecutor(containerType);
        containerExecutor.executeFlowNode(flowNodeInstanceId, contextDependency, operations, processInstanceId, null, null);
    }
}

