/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.execution.work;

import java.util.List;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.core.process.instance.api.ActivityInstanceService;
import org.bonitasoft.engine.core.process.instance.model.SFlowNodeInstance;
import org.bonitasoft.engine.execution.work.RestartException;
import org.bonitasoft.engine.execution.work.TenantRestartHandler;
import org.bonitasoft.engine.execution.work.WorkFactory;
import org.bonitasoft.engine.log.technical.TechnicalLogSeverity;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;
import org.bonitasoft.engine.persistence.QueryOptions;
import org.bonitasoft.engine.service.PlatformServiceAccessor;
import org.bonitasoft.engine.service.TenantServiceAccessor;
import org.bonitasoft.engine.work.WorkRegisterException;
import org.bonitasoft.engine.work.WorkService;

public class RestartFlowNodesHandler
implements TenantRestartHandler {
    @Override
    public void handleRestart(PlatformServiceAccessor platformServiceAccessor, TenantServiceAccessor tenantServiceAccessor) throws RestartException {
        ActivityInstanceService activityInstanceService = tenantServiceAccessor.getActivityInstanceService();
        WorkService workService = platformServiceAccessor.getWorkService();
        TechnicalLoggerService logger = tenantServiceAccessor.getTechnicalLoggerService();
        try {
            List<SFlowNodeInstance> sFlowNodeInstances;
            QueryOptions queryOptions = QueryOptions.defaultQueryOptions();
            boolean info = logger.isLoggable(this.getClass(), TechnicalLogSeverity.INFO);
            if (info) {
                logger.log(this.getClass(), TechnicalLogSeverity.INFO, "Restarting flow nodes...");
            }
            do {
                sFlowNodeInstances = activityInstanceService.getFlowNodeInstancesToRestart(queryOptions);
                queryOptions = QueryOptions.getNextPage(queryOptions);
                for (SFlowNodeInstance sFlowNodeInstance : sFlowNodeInstances) {
                    if (sFlowNodeInstance.isTerminal()) {
                        if (info) {
                            logger.log(this.getClass(), TechnicalLogSeverity.INFO, "Restarting flow node (Notify...) with name = " + sFlowNodeInstance.getName() + ", and id = " + sFlowNodeInstance.getId() + " in state " + sFlowNodeInstance.getStateName());
                        }
                        workService.registerWork(WorkFactory.createNotifyChildFinishedWork(sFlowNodeInstance.getProcessDefinitionId(), sFlowNodeInstance.getParentProcessInstanceId(), sFlowNodeInstance.getId(), sFlowNodeInstance.getParentContainerId(), sFlowNodeInstance.getParentContainerType().name(), sFlowNodeInstance.getStateId()));
                        continue;
                    }
                    if (info) {
                        logger.log(this.getClass(), TechnicalLogSeverity.INFO, "Restarting flow node (Execute..) with name = " + sFlowNodeInstance.getName() + ", and id = " + sFlowNodeInstance.getId() + " in state " + sFlowNodeInstance.getStateName());
                    }
                    workService.registerWork(WorkFactory.createExecuteFlowNodeWork(sFlowNodeInstance.getId(), null, null, sFlowNodeInstance.getParentProcessInstanceId()));
                }
            } while (sFlowNodeInstances.size() == queryOptions.getNumberOfResults());
        }
        catch (WorkRegisterException e) {
            this.handleException(e, "Unable to restart flowNodes: can't register work");
        }
        catch (SBonitaException e) {
            this.handleException(e, "Unable to restart flowNodes: can't read flow nodes");
        }
    }

    private void handleException(Exception e, String message) throws RestartException {
        throw new RestartException(message, e);
    }
}

