/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bonitasoft.engine.actor.mapping.model.SActor;
import org.bonitasoft.engine.actor.mapping.model.SActorMember;
import org.bonitasoft.engine.api.impl.SessionInfos;
import org.bonitasoft.engine.bpm.actor.ActorInstance;
import org.bonitasoft.engine.bpm.actor.ActorMember;
import org.bonitasoft.engine.bpm.actor.impl.ActorInstanceImpl;
import org.bonitasoft.engine.bpm.actor.impl.ActorMemberImpl;
import org.bonitasoft.engine.bpm.category.Category;
import org.bonitasoft.engine.bpm.category.impl.CategoryImpl;
import org.bonitasoft.engine.bpm.comment.ArchivedComment;
import org.bonitasoft.engine.bpm.comment.Comment;
import org.bonitasoft.engine.bpm.comment.impl.ArchivedCommentImpl;
import org.bonitasoft.engine.bpm.comment.impl.CommentImpl;
import org.bonitasoft.engine.bpm.connector.ArchivedConnectorInstance;
import org.bonitasoft.engine.bpm.connector.ConnectorDefinition;
import org.bonitasoft.engine.bpm.connector.ConnectorImplementationDescriptor;
import org.bonitasoft.engine.bpm.connector.ConnectorInstance;
import org.bonitasoft.engine.bpm.connector.ConnectorInstanceWithFailureInfo;
import org.bonitasoft.engine.bpm.connector.ConnectorState;
import org.bonitasoft.engine.bpm.connector.impl.ArchivedConnectorInstanceImpl;
import org.bonitasoft.engine.bpm.connector.impl.ConnectorDefinitionImpl;
import org.bonitasoft.engine.bpm.connector.impl.ConnectorInstanceImpl;
import org.bonitasoft.engine.bpm.connector.impl.ConnectorInstanceWithFailureInfoImpl;
import org.bonitasoft.engine.bpm.data.ArchivedDataInstance;
import org.bonitasoft.engine.bpm.data.DataDefinition;
import org.bonitasoft.engine.bpm.data.DataInstance;
import org.bonitasoft.engine.bpm.data.impl.ArchivedDataInstanceImpl;
import org.bonitasoft.engine.bpm.data.impl.BlobDataInstanceImpl;
import org.bonitasoft.engine.bpm.data.impl.BooleanDataInstanceImpl;
import org.bonitasoft.engine.bpm.data.impl.DataDefinitionImpl;
import org.bonitasoft.engine.bpm.data.impl.DateDataInstanceImpl;
import org.bonitasoft.engine.bpm.data.impl.DoubleDataInstanceImpl;
import org.bonitasoft.engine.bpm.data.impl.FloatDataInstanceImpl;
import org.bonitasoft.engine.bpm.data.impl.IntegerDataInstanceImpl;
import org.bonitasoft.engine.bpm.data.impl.LongDataInstanceImpl;
import org.bonitasoft.engine.bpm.data.impl.ShortTextDataInstanceImpl;
import org.bonitasoft.engine.bpm.document.ArchivedDocument;
import org.bonitasoft.engine.bpm.document.Document;
import org.bonitasoft.engine.bpm.document.impl.ArchivedDocumentImpl;
import org.bonitasoft.engine.bpm.document.impl.DocumentImpl;
import org.bonitasoft.engine.bpm.flownode.ActivityInstance;
import org.bonitasoft.engine.bpm.flownode.ArchivedActivityInstance;
import org.bonitasoft.engine.bpm.flownode.ArchivedAutomaticTaskInstance;
import org.bonitasoft.engine.bpm.flownode.ArchivedCallActivityInstance;
import org.bonitasoft.engine.bpm.flownode.ArchivedFlowElementInstance;
import org.bonitasoft.engine.bpm.flownode.ArchivedFlowNodeInstance;
import org.bonitasoft.engine.bpm.flownode.ArchivedGatewayInstance;
import org.bonitasoft.engine.bpm.flownode.ArchivedHumanTaskInstance;
import org.bonitasoft.engine.bpm.flownode.ArchivedLoopActivityInstance;
import org.bonitasoft.engine.bpm.flownode.ArchivedManualTaskInstance;
import org.bonitasoft.engine.bpm.flownode.ArchivedReceiveTaskInstance;
import org.bonitasoft.engine.bpm.flownode.ArchivedSendTaskInstance;
import org.bonitasoft.engine.bpm.flownode.ArchivedSubProcessActivityInstance;
import org.bonitasoft.engine.bpm.flownode.ArchivedUserTaskInstance;
import org.bonitasoft.engine.bpm.flownode.BPMEventType;
import org.bonitasoft.engine.bpm.flownode.EventInstance;
import org.bonitasoft.engine.bpm.flownode.FlowNodeInstance;
import org.bonitasoft.engine.bpm.flownode.GatewayInstance;
import org.bonitasoft.engine.bpm.flownode.HumanTaskInstance;
import org.bonitasoft.engine.bpm.flownode.ManualTaskInstance;
import org.bonitasoft.engine.bpm.flownode.StateCategory;
import org.bonitasoft.engine.bpm.flownode.TaskPriority;
import org.bonitasoft.engine.bpm.flownode.UserTaskInstance;
import org.bonitasoft.engine.bpm.flownode.WaitingEvent;
import org.bonitasoft.engine.bpm.flownode.impl.ActivityInstanceImpl;
import org.bonitasoft.engine.bpm.flownode.impl.ArchivedActivityInstanceImpl;
import org.bonitasoft.engine.bpm.flownode.impl.ArchivedAutomaticTaskInstanceImpl;
import org.bonitasoft.engine.bpm.flownode.impl.ArchivedCallActivityInstanceImpl;
import org.bonitasoft.engine.bpm.flownode.impl.ArchivedFlowNodeInstanceImpl;
import org.bonitasoft.engine.bpm.flownode.impl.ArchivedGatewayInstanceImpl;
import org.bonitasoft.engine.bpm.flownode.impl.ArchivedHumanTaskInstanceImpl;
import org.bonitasoft.engine.bpm.flownode.impl.ArchivedLoopActivityInstanceImpl;
import org.bonitasoft.engine.bpm.flownode.impl.ArchivedManualTaskInstanceImpl;
import org.bonitasoft.engine.bpm.flownode.impl.ArchivedMultiInstanceActivityInstanceImpl;
import org.bonitasoft.engine.bpm.flownode.impl.ArchivedReceiveTaskInstanceImpl;
import org.bonitasoft.engine.bpm.flownode.impl.ArchivedSendTaskInstanceImpl;
import org.bonitasoft.engine.bpm.flownode.impl.ArchivedSubProcessActivityInstanceImpl;
import org.bonitasoft.engine.bpm.flownode.impl.ArchivedUserTaskInstanceImpl;
import org.bonitasoft.engine.bpm.flownode.impl.AutomaticTaskInstanceImpl;
import org.bonitasoft.engine.bpm.flownode.impl.BoundaryEventInstanceImpl;
import org.bonitasoft.engine.bpm.flownode.impl.CallActivityInstanceImpl;
import org.bonitasoft.engine.bpm.flownode.impl.EndEventInstanceImpl;
import org.bonitasoft.engine.bpm.flownode.impl.EventInstanceImpl;
import org.bonitasoft.engine.bpm.flownode.impl.FlowNodeInstanceImpl;
import org.bonitasoft.engine.bpm.flownode.impl.GatewayInstanceImpl;
import org.bonitasoft.engine.bpm.flownode.impl.HumanTaskInstanceImpl;
import org.bonitasoft.engine.bpm.flownode.impl.IntermediateCatchEventInstanceImpl;
import org.bonitasoft.engine.bpm.flownode.impl.IntermediateThrowEventInstanceImpl;
import org.bonitasoft.engine.bpm.flownode.impl.LoopActivityInstanceImpl;
import org.bonitasoft.engine.bpm.flownode.impl.ManualTaskInstanceImpl;
import org.bonitasoft.engine.bpm.flownode.impl.MultiInstanceActivityInstanceImpl;
import org.bonitasoft.engine.bpm.flownode.impl.ReceiveTaskInstanceImpl;
import org.bonitasoft.engine.bpm.flownode.impl.SendTaskInstanceImpl;
import org.bonitasoft.engine.bpm.flownode.impl.StartEventInstanceImpl;
import org.bonitasoft.engine.bpm.flownode.impl.SubProcessActivityInstanceImpl;
import org.bonitasoft.engine.bpm.flownode.impl.UserTaskInstanceImpl;
import org.bonitasoft.engine.bpm.flownode.impl.WaitingErrorEventImpl;
import org.bonitasoft.engine.bpm.flownode.impl.WaitingMessageEventImpl;
import org.bonitasoft.engine.bpm.flownode.impl.WaitingSignalEventImpl;
import org.bonitasoft.engine.bpm.process.ActivationState;
import org.bonitasoft.engine.bpm.process.ArchivedProcessInstance;
import org.bonitasoft.engine.bpm.process.ConfigurationState;
import org.bonitasoft.engine.bpm.process.ProcessDefinition;
import org.bonitasoft.engine.bpm.process.ProcessDeploymentInfo;
import org.bonitasoft.engine.bpm.process.ProcessInstance;
import org.bonitasoft.engine.bpm.process.ProcessInstanceState;
import org.bonitasoft.engine.bpm.process.impl.ArchivedProcessInstanceImpl;
import org.bonitasoft.engine.bpm.process.impl.ProcessDefinitionImpl;
import org.bonitasoft.engine.bpm.process.impl.ProcessDeploymentInfoImpl;
import org.bonitasoft.engine.bpm.process.impl.ProcessInstanceBuilder;
import org.bonitasoft.engine.bpm.supervisor.ProcessSupervisor;
import org.bonitasoft.engine.bpm.supervisor.impl.ProcessSupervisorImpl;
import org.bonitasoft.engine.builder.BuilderFactory;
import org.bonitasoft.engine.command.CommandDescriptor;
import org.bonitasoft.engine.command.CommandDescriptorImpl;
import org.bonitasoft.engine.command.model.SCommand;
import org.bonitasoft.engine.core.category.model.SCategory;
import org.bonitasoft.engine.core.connector.parser.SConnectorImplementationDescriptor;
import org.bonitasoft.engine.core.operation.model.SLeftOperand;
import org.bonitasoft.engine.core.operation.model.SOperation;
import org.bonitasoft.engine.core.operation.model.SOperatorType;
import org.bonitasoft.engine.core.operation.model.builder.SLeftOperandBuilderFactory;
import org.bonitasoft.engine.core.operation.model.builder.SOperationBuilderFactory;
import org.bonitasoft.engine.core.process.comment.model.SComment;
import org.bonitasoft.engine.core.process.comment.model.archive.SAComment;
import org.bonitasoft.engine.core.process.definition.ProcessDefinitionService;
import org.bonitasoft.engine.core.process.definition.SProcessDefinitionNotFoundException;
import org.bonitasoft.engine.core.process.definition.exception.SProcessDefinitionReadException;
import org.bonitasoft.engine.core.process.definition.model.SConnectorDefinition;
import org.bonitasoft.engine.core.process.definition.model.SProcessDefinition;
import org.bonitasoft.engine.core.process.definition.model.SProcessDefinitionDeployInfo;
import org.bonitasoft.engine.core.process.document.model.SAProcessDocument;
import org.bonitasoft.engine.core.process.document.model.SProcessDocument;
import org.bonitasoft.engine.core.process.instance.model.SActivityInstance;
import org.bonitasoft.engine.core.process.instance.model.SAutomaticTaskInstance;
import org.bonitasoft.engine.core.process.instance.model.SCallActivityInstance;
import org.bonitasoft.engine.core.process.instance.model.SConnectorInstance;
import org.bonitasoft.engine.core.process.instance.model.SConnectorInstanceWithFailureInfo;
import org.bonitasoft.engine.core.process.instance.model.SFlowNodeInstance;
import org.bonitasoft.engine.core.process.instance.model.SGatewayInstance;
import org.bonitasoft.engine.core.process.instance.model.SHumanTaskInstance;
import org.bonitasoft.engine.core.process.instance.model.SLoopActivityInstance;
import org.bonitasoft.engine.core.process.instance.model.SManualTaskInstance;
import org.bonitasoft.engine.core.process.instance.model.SMultiInstanceActivityInstance;
import org.bonitasoft.engine.core.process.instance.model.SProcessInstance;
import org.bonitasoft.engine.core.process.instance.model.SReceiveTaskInstance;
import org.bonitasoft.engine.core.process.instance.model.SSendTaskInstance;
import org.bonitasoft.engine.core.process.instance.model.SSubProcessActivityInstance;
import org.bonitasoft.engine.core.process.instance.model.SUserTaskInstance;
import org.bonitasoft.engine.core.process.instance.model.archive.SAActivityInstance;
import org.bonitasoft.engine.core.process.instance.model.archive.SAAutomaticTaskInstance;
import org.bonitasoft.engine.core.process.instance.model.archive.SACallActivityInstance;
import org.bonitasoft.engine.core.process.instance.model.archive.SAConnectorInstance;
import org.bonitasoft.engine.core.process.instance.model.archive.SAFlowElementInstance;
import org.bonitasoft.engine.core.process.instance.model.archive.SAFlowNodeInstance;
import org.bonitasoft.engine.core.process.instance.model.archive.SAGatewayInstance;
import org.bonitasoft.engine.core.process.instance.model.archive.SAHumanTaskInstance;
import org.bonitasoft.engine.core.process.instance.model.archive.SALoopActivityInstance;
import org.bonitasoft.engine.core.process.instance.model.archive.SAManualTaskInstance;
import org.bonitasoft.engine.core.process.instance.model.archive.SAMultiInstanceActivityInstance;
import org.bonitasoft.engine.core.process.instance.model.archive.SAProcessInstance;
import org.bonitasoft.engine.core.process.instance.model.archive.SAReceiveTaskInstance;
import org.bonitasoft.engine.core.process.instance.model.archive.SASendTaskInstance;
import org.bonitasoft.engine.core.process.instance.model.archive.SASubProcessActivityInstance;
import org.bonitasoft.engine.core.process.instance.model.archive.SAUserTaskInstance;
import org.bonitasoft.engine.core.process.instance.model.event.SBoundaryEventInstance;
import org.bonitasoft.engine.core.process.instance.model.event.SEventInstance;
import org.bonitasoft.engine.core.process.instance.model.event.handling.SWaitingErrorEvent;
import org.bonitasoft.engine.core.process.instance.model.event.handling.SWaitingEvent;
import org.bonitasoft.engine.core.process.instance.model.event.handling.SWaitingMessageEvent;
import org.bonitasoft.engine.core.process.instance.model.event.handling.SWaitingSignalEvent;
import org.bonitasoft.engine.data.definition.model.SDataDefinition;
import org.bonitasoft.engine.data.instance.model.SDataInstance;
import org.bonitasoft.engine.data.instance.model.archive.SADataInstance;
import org.bonitasoft.engine.exception.UnknownElementType;
import org.bonitasoft.engine.execution.state.FlowNodeStateManager;
import org.bonitasoft.engine.expression.Expression;
import org.bonitasoft.engine.expression.exception.SInvalidExpressionException;
import org.bonitasoft.engine.expression.impl.ExpressionImpl;
import org.bonitasoft.engine.expression.model.SExpression;
import org.bonitasoft.engine.expression.model.builder.SExpressionBuilder;
import org.bonitasoft.engine.expression.model.builder.SExpressionBuilderFactory;
import org.bonitasoft.engine.identity.ContactData;
import org.bonitasoft.engine.identity.ContactDataCreator;
import org.bonitasoft.engine.identity.ExportedUser;
import org.bonitasoft.engine.identity.ExportedUserBuilder;
import org.bonitasoft.engine.identity.ExportedUserBuilderFactory;
import org.bonitasoft.engine.identity.Group;
import org.bonitasoft.engine.identity.GroupCreator;
import org.bonitasoft.engine.identity.Role;
import org.bonitasoft.engine.identity.RoleCreator;
import org.bonitasoft.engine.identity.User;
import org.bonitasoft.engine.identity.UserCreator;
import org.bonitasoft.engine.identity.UserMembership;
import org.bonitasoft.engine.identity.impl.ContactDataImpl;
import org.bonitasoft.engine.identity.impl.GroupImpl;
import org.bonitasoft.engine.identity.impl.RoleImpl;
import org.bonitasoft.engine.identity.impl.UserImpl;
import org.bonitasoft.engine.identity.impl.UserMembershipImpl;
import org.bonitasoft.engine.identity.model.SContactInfo;
import org.bonitasoft.engine.identity.model.SGroup;
import org.bonitasoft.engine.identity.model.SRole;
import org.bonitasoft.engine.identity.model.SUser;
import org.bonitasoft.engine.identity.model.SUserMembership;
import org.bonitasoft.engine.identity.model.builder.SContactInfoBuilder;
import org.bonitasoft.engine.identity.model.builder.SContactInfoBuilderFactory;
import org.bonitasoft.engine.identity.model.builder.SGroupBuilder;
import org.bonitasoft.engine.identity.model.builder.SGroupBuilderFactory;
import org.bonitasoft.engine.identity.model.builder.SRoleBuilder;
import org.bonitasoft.engine.identity.model.builder.SRoleBuilderFactory;
import org.bonitasoft.engine.identity.model.builder.SUserBuilder;
import org.bonitasoft.engine.identity.model.builder.SUserBuilderFactory;
import org.bonitasoft.engine.job.FailedJob;
import org.bonitasoft.engine.job.impl.FailedJobImpl;
import org.bonitasoft.engine.operation.LeftOperand;
import org.bonitasoft.engine.operation.Operation;
import org.bonitasoft.engine.operation.OperatorType;
import org.bonitasoft.engine.operation.impl.LeftOperandImpl;
import org.bonitasoft.engine.operation.impl.OperationImpl;
import org.bonitasoft.engine.platform.Platform;
import org.bonitasoft.engine.platform.command.model.SPlatformCommand;
import org.bonitasoft.engine.platform.impl.PlatformImpl;
import org.bonitasoft.engine.platform.model.SPlatform;
import org.bonitasoft.engine.profile.Profile;
import org.bonitasoft.engine.profile.ProfileEntry;
import org.bonitasoft.engine.profile.ProfileMember;
import org.bonitasoft.engine.profile.ProfileMemberCreator;
import org.bonitasoft.engine.profile.builder.SProfileMemberBuilder;
import org.bonitasoft.engine.profile.builder.SProfileMemberBuilderFactory;
import org.bonitasoft.engine.profile.impl.ProfileEntryImpl;
import org.bonitasoft.engine.profile.impl.ProfileImpl;
import org.bonitasoft.engine.profile.impl.ProfileMemberImpl;
import org.bonitasoft.engine.profile.model.SProfile;
import org.bonitasoft.engine.profile.model.SProfileEntry;
import org.bonitasoft.engine.profile.model.SProfileMember;
import org.bonitasoft.engine.scheduler.model.SFailedJob;
import org.bonitasoft.engine.session.APISession;
import org.bonitasoft.engine.session.impl.APISessionImpl;
import org.bonitasoft.engine.session.model.SSession;
import org.bonitasoft.engine.supervisor.mapping.model.SProcessSupervisor;
import org.bonitasoft.engine.theme.Theme;
import org.bonitasoft.engine.theme.ThemeType;
import org.bonitasoft.engine.theme.impl.ThemeImpl;
import org.bonitasoft.engine.theme.model.STheme;

public class ModelConvertor {
    public static APISession toAPISession(SSession session, String tenant) {
        long tenantId = session.getTenantId();
        long id = session.getId();
        long userId = session.getUserId();
        String userName = session.getUserName();
        Date creationDate = session.getCreationDate();
        long duration = session.getDuration();
        boolean technicalUser = session.isTechnicalUser();
        APISessionImpl apiSession = new APISessionImpl(id, creationDate, duration, userName, userId, tenant, tenantId);
        apiSession.setTechnicalUser(technicalUser);
        return apiSession;
    }

    public static Platform toPlatform(SPlatform sPlatform) {
        return new PlatformImpl(sPlatform.getVersion(), sPlatform.getPreviousVersion(), sPlatform.getInitialVersion(), sPlatform.getCreatedBy(), sPlatform.getCreated());
    }

    public static List<ActivityInstance> toActivityInstances(List<SActivityInstance> sActivities, FlowNodeStateManager flowNodeStateManager) {
        ArrayList<ActivityInstance> activityInstances = new ArrayList<ActivityInstance>();
        for (SActivityInstance sActivity : sActivities) {
            ActivityInstance activityInstance = ModelConvertor.toActivityInstance(sActivity, flowNodeStateManager);
            activityInstances.add(activityInstance);
        }
        return activityInstances;
    }

    public static List<FlowNodeInstance> toFlowNodeInstances(List<SFlowNodeInstance> sFlowNodes, FlowNodeStateManager flowNodeStateManager) {
        ArrayList<FlowNodeInstance> flowNodeInstances = new ArrayList<FlowNodeInstance>();
        for (SFlowNodeInstance sFlowNode : sFlowNodes) {
            FlowNodeInstance flowNodeInstance = ModelConvertor.toFlowNodeInstance(sFlowNode, flowNodeStateManager);
            flowNodeInstances.add(flowNodeInstance);
        }
        return flowNodeInstances;
    }

    private static void updateFlowNode(FlowNodeInstanceImpl flowNode, SFlowNodeInstance sflowNode, String state) {
        flowNode.setId(sflowNode.getId());
        flowNode.setState(state);
        flowNode.setParentContainerId(sflowNode.getParentContainerId());
        flowNode.setRootContainerId(sflowNode.getRootContainerId());
        flowNode.setProcessDefinitionId(sflowNode.getLogicalGroup(0));
        flowNode.setParentProcessInstanceId(sflowNode.getLogicalGroup(3));
        flowNode.setDisplayName(sflowNode.getDisplayName());
        flowNode.setDisplayDescription(sflowNode.getDisplayDescription());
        flowNode.setDescription(sflowNode.getDescription());
        flowNode.setExecutedBy(sflowNode.getExecutedBy());
        flowNode.setExecutedByDelegate(sflowNode.getExecutedByDelegate());
        flowNode.setStateCategory(StateCategory.valueOf((String)sflowNode.getStateCategory().name()));
    }

    public static ActivityInstance toActivityInstance(SActivityInstance sActivity, FlowNodeStateManager flowNodeStateManager) {
        switch (sActivity.getType()) {
            case AUTOMATIC_TASK: {
                return ModelConvertor.toAutomaticTask((SAutomaticTaskInstance)sActivity, flowNodeStateManager);
            }
            case MANUAL_TASK: {
                return ModelConvertor.toManualTask((SManualTaskInstance)sActivity, flowNodeStateManager);
            }
            case USER_TASK: {
                return ModelConvertor.toUserTaskInstance((SUserTaskInstance)sActivity, flowNodeStateManager);
            }
            case RECEIVE_TASK: {
                return ModelConvertor.toReceiveTaskInstance((SReceiveTaskInstance)sActivity, flowNodeStateManager);
            }
            case SEND_TASK: {
                return ModelConvertor.toSendTaskInstance((SSendTaskInstance)sActivity, flowNodeStateManager);
            }
            case CALL_ACTIVITY: {
                return ModelConvertor.toCallActivityInstance((SCallActivityInstance)sActivity, flowNodeStateManager);
            }
            case SUB_PROCESS: {
                return ModelConvertor.toSubProcessActivityInstance((SSubProcessActivityInstance)sActivity, flowNodeStateManager);
            }
            case LOOP_ACTIVITY: {
                return ModelConvertor.toLoopActivityInstance((SLoopActivityInstance)sActivity, flowNodeStateManager);
            }
            case MULTI_INSTANCE_ACTIVITY: {
                return ModelConvertor.toMultiInstanceActivityInstance((SMultiInstanceActivityInstance)sActivity, flowNodeStateManager);
            }
        }
        throw new UnknownElementType(sActivity.getType().name());
    }

    public static FlowNodeInstance toFlowNodeInstance(SFlowNodeInstance sFlowNode, FlowNodeStateManager flowNodeStateManager) {
        switch (sFlowNode.getType()) {
            case START_EVENT: {
                return ModelConvertor.toEventInstance((SEventInstance)sFlowNode, flowNodeStateManager);
            }
            case INTERMEDIATE_CATCH_EVENT: {
                return ModelConvertor.toEventInstance((SEventInstance)sFlowNode, flowNodeStateManager);
            }
            case BOUNDARY_EVENT: {
                return ModelConvertor.toEventInstance((SEventInstance)sFlowNode, flowNodeStateManager);
            }
            case INTERMEDIATE_THROW_EVENT: {
                return ModelConvertor.toEventInstance((SEventInstance)sFlowNode, flowNodeStateManager);
            }
            case END_EVENT: {
                return ModelConvertor.toEventInstance((SEventInstance)sFlowNode, flowNodeStateManager);
            }
            case GATEWAY: {
                return ModelConvertor.toGatewayInstance((SGatewayInstance)sFlowNode, flowNodeStateManager);
            }
        }
        if (sFlowNode instanceof SActivityInstance) {
            return ModelConvertor.toActivityInstance((SActivityInstance)sFlowNode, flowNodeStateManager);
        }
        throw new UnknownElementType(sFlowNode.getType().name());
    }

    public static ActivityInstance toAutomaticTask(SAutomaticTaskInstance sActivity, FlowNodeStateManager flowNodeStateManager) {
        AutomaticTaskInstanceImpl automaticTaskInstance = new AutomaticTaskInstanceImpl(sActivity.getName(), sActivity.getFlowNodeDefinitionId());
        ModelConvertor.updateActivityInstance(sActivity, flowNodeStateManager, (ActivityInstanceImpl)automaticTaskInstance);
        return automaticTaskInstance;
    }

    public static ActivityInstance toCallActivityInstance(SCallActivityInstance sActivity, FlowNodeStateManager flowNodeStateManager) {
        CallActivityInstanceImpl callActivityInstance = new CallActivityInstanceImpl(sActivity.getName(), sActivity.getFlowNodeDefinitionId());
        ModelConvertor.updateActivityInstance(sActivity, flowNodeStateManager, (ActivityInstanceImpl)callActivityInstance);
        return callActivityInstance;
    }

    public static ActivityInstance toCallActivityInstance(SSubProcessActivityInstance sActivity, FlowNodeStateManager flowNodeStateManager) {
        SubProcessActivityInstanceImpl subProcActivityInstance = new SubProcessActivityInstanceImpl(sActivity.getName(), sActivity.getFlowNodeDefinitionId(), sActivity.isTriggeredByEvent());
        ModelConvertor.updateActivityInstance(sActivity, flowNodeStateManager, (ActivityInstanceImpl)subProcActivityInstance);
        return subProcActivityInstance;
    }

    public static ActivityInstance toSubProcessActivityInstance(SSubProcessActivityInstance sActivity, FlowNodeStateManager flowNodeStateManager) {
        SubProcessActivityInstanceImpl subProcessActivityInstance = new SubProcessActivityInstanceImpl(sActivity.getName(), sActivity.getFlowNodeDefinitionId(), sActivity.isTriggeredByEvent());
        ModelConvertor.updateActivityInstance(sActivity, flowNodeStateManager, (ActivityInstanceImpl)subProcessActivityInstance);
        return subProcessActivityInstance;
    }

    public static ActivityInstance toLoopActivityInstance(SLoopActivityInstance sActivity, FlowNodeStateManager flowNodeStateManager) {
        LoopActivityInstanceImpl loopActivityInstance = new LoopActivityInstanceImpl(sActivity.getName(), sActivity.getFlowNodeDefinitionId(), sActivity.getLoopCounter());
        ModelConvertor.updateActivityInstance(sActivity, flowNodeStateManager, (ActivityInstanceImpl)loopActivityInstance);
        return loopActivityInstance;
    }

    public static ActivityInstance toMultiInstanceActivityInstance(SMultiInstanceActivityInstance sActivity, FlowNodeStateManager flowNodeStateManager) {
        MultiInstanceActivityInstanceImpl loopActivityInstance = new MultiInstanceActivityInstanceImpl(sActivity.getName(), sActivity.getFlowNodeDefinitionId(), sActivity.isSequential(), sActivity.getLoopDataInputRef(), sActivity.getLoopDataOutputRef(), sActivity.getDataInputItemRef(), sActivity.getDataOutputItemRef(), sActivity.getNumberOfActiveInstances(), sActivity.getNumberOfCompletedInstances(), sActivity.getNumberOfTerminatedInstances(), sActivity.getLoopCardinality());
        ModelConvertor.updateActivityInstance(sActivity, flowNodeStateManager, (ActivityInstanceImpl)loopActivityInstance);
        return loopActivityInstance;
    }

    public static GatewayInstance toGatewayInstance(SGatewayInstance sGatewayInstance, FlowNodeStateManager flowNodeStateManager) {
        GatewayInstanceImpl gatewayInstance = new GatewayInstanceImpl(sGatewayInstance.getName(), sGatewayInstance.getFlowNodeDefinitionId());
        String state = flowNodeStateManager.getState(sGatewayInstance.getStateId()).getName();
        ModelConvertor.updateFlowNode((FlowNodeInstanceImpl)gatewayInstance, sGatewayInstance, state);
        return gatewayInstance;
    }

    public static ArchivedGatewayInstance toArchivedGatewayInstance(SAGatewayInstance saGatewayInstance, FlowNodeStateManager flowNodeStateManager) {
        String name = saGatewayInstance.getName();
        ArchivedGatewayInstanceImpl aGatewayInstance = new ArchivedGatewayInstanceImpl(name);
        String state = flowNodeStateManager.getState(saGatewayInstance.getStateId()).getName();
        ModelConvertor.updateArchivedFlowNodeInstance((ArchivedFlowNodeInstanceImpl)aGatewayInstance, saGatewayInstance, state);
        return aGatewayInstance;
    }

    private static void updateActivityInstance(SActivityInstance sActivity, FlowNodeStateManager flowNodeStateManager, ActivityInstanceImpl activity) {
        String state = flowNodeStateManager.getState(sActivity.getStateId()).getName();
        ModelConvertor.updateFlowNode((FlowNodeInstanceImpl)activity, sActivity, state);
        activity.setReachedSateDate(new Date(sActivity.getReachedStateDate()));
        activity.setLastUpdateDate(new Date(sActivity.getLastUpdateDate()));
    }

    public static List<UserTaskInstance> toUserTaskInstances(List<SUserTaskInstance> sUserTasks, FlowNodeStateManager flowNodeStateManager) {
        ArrayList<UserTaskInstance> userTaskInstances = new ArrayList<UserTaskInstance>();
        for (SUserTaskInstance sUserTask : sUserTasks) {
            UserTaskInstance userTask = ModelConvertor.toUserTaskInstance(sUserTask, flowNodeStateManager);
            userTaskInstances.add(userTask);
        }
        return userTaskInstances;
    }

    public static UserTaskInstance toUserTaskInstance(SUserTaskInstance sUserTask, FlowNodeStateManager flowNodeStateManager) {
        UserTaskInstanceImpl userTaskInstance = new UserTaskInstanceImpl(sUserTask.getName(), sUserTask.getFlowNodeDefinitionId(), sUserTask.getActorId());
        ModelConvertor.updateHumanTaskInstance(sUserTask, flowNodeStateManager, (HumanTaskInstanceImpl)userTaskInstance);
        return userTaskInstance;
    }

    public static ActivityInstance toReceiveTaskInstance(SReceiveTaskInstance sReceiveTask, FlowNodeStateManager flowNodeStateManager) {
        ReceiveTaskInstanceImpl receiveTaskInstance = new ReceiveTaskInstanceImpl(sReceiveTask.getName(), sReceiveTask.getFlowNodeDefinitionId());
        ModelConvertor.updateActivityInstance(sReceiveTask, flowNodeStateManager, (ActivityInstanceImpl)receiveTaskInstance);
        return receiveTaskInstance;
    }

    public static ActivityInstance toSendTaskInstance(SSendTaskInstance sSendTask, FlowNodeStateManager flowNodeStateManager) {
        SendTaskInstanceImpl sendTask = new SendTaskInstanceImpl(sSendTask.getName(), sSendTask.getFlowNodeDefinitionId());
        ModelConvertor.updateActivityInstance(sSendTask, flowNodeStateManager, (ActivityInstanceImpl)sendTask);
        return sendTask;
    }

    private static void updateHumanTaskInstance(SHumanTaskInstance sHumanTask, FlowNodeStateManager flowNodeStateManager, HumanTaskInstanceImpl humanTaskInstance) {
        ModelConvertor.updateActivityInstance(sHumanTask, flowNodeStateManager, (ActivityInstanceImpl)humanTaskInstance);
        humanTaskInstance.setAssigneeId(sHumanTask.getAssigneeId());
        long claimedDate = sHumanTask.getClaimedDate();
        if (claimedDate > 0L) {
            humanTaskInstance.setClaimedDate(new Date(claimedDate));
        }
        humanTaskInstance.setPriority(TaskPriority.valueOf((String)sHumanTask.getPriority().name()));
        long expectedEndDate = sHumanTask.getExpectedEndDate();
        if (expectedEndDate > 0L) {
            humanTaskInstance.setExpectedEndDate(new Date(expectedEndDate));
        }
    }

    public static List<HumanTaskInstance> toHumanTaskInstances(List<? extends SHumanTaskInstance> sHumanTasks, FlowNodeStateManager flowNodeStateManager) {
        ArrayList<HumanTaskInstance> humanTaskInstances = new ArrayList<HumanTaskInstance>(sHumanTasks.size());
        for (SHumanTaskInstance sHumanTaskInstance : sHumanTasks) {
            HumanTaskInstance userTask = ModelConvertor.toHumanTaskInstance(sHumanTaskInstance, flowNodeStateManager);
            humanTaskInstances.add(userTask);
        }
        return humanTaskInstances;
    }

    public static HumanTaskInstance toHumanTaskInstance(SHumanTaskInstance sHumanTask, FlowNodeStateManager flowNodeStateManager) {
        switch (sHumanTask.getType()) {
            case USER_TASK: {
                return ModelConvertor.toUserTaskInstance((SUserTaskInstance)sHumanTask, flowNodeStateManager);
            }
            case MANUAL_TASK: {
                return ModelConvertor.toManualTask((SManualTaskInstance)sHumanTask, flowNodeStateManager);
            }
        }
        throw new UnknownElementType(sHumanTask.getType().name());
    }

    public static ManualTaskInstance toManualTask(SManualTaskInstance sHumanTask, FlowNodeStateManager flowNodeStateManager) {
        ManualTaskInstanceImpl manualTaskInstance = new ManualTaskInstanceImpl(sHumanTask.getName(), sHumanTask.getFlowNodeDefinitionId(), sHumanTask.getActorId());
        ModelConvertor.updateHumanTaskInstance(sHumanTask, flowNodeStateManager, (HumanTaskInstanceImpl)manualTaskInstance);
        return manualTaskInstance;
    }

    public static ProcessDefinition toProcessDefinition(SProcessDefinition sDefinition) {
        ProcessDefinitionImpl processDefinitionImpl = new ProcessDefinitionImpl(sDefinition.getName(), sDefinition.getVersion());
        processDefinitionImpl.setId(sDefinition.getId().longValue());
        processDefinitionImpl.setDescription(sDefinition.getDescription());
        return processDefinitionImpl;
    }

    public static List<ProcessInstance> toProcessInstances(List<SProcessInstance> sProcessInstances, ProcessDefinitionService processDefinitionService) {
        ArrayList<ProcessInstance> clientProcessInstances = new ArrayList<ProcessInstance>();
        HashMap<Long, SProcessDefinition> processDefinitions = new HashMap<Long, SProcessDefinition>();
        if (sProcessInstances != null) {
            for (SProcessInstance sProcessInstance : sProcessInstances) {
                SProcessDefinition sProcessDefinition = (SProcessDefinition)processDefinitions.get(sProcessInstance.getProcessDefinitionId());
                if (sProcessDefinition == null) {
                    try {
                        sProcessDefinition = processDefinitionService.getProcessDefinition(sProcessInstance.getProcessDefinitionId());
                        processDefinitions.put(sProcessDefinition.getId(), sProcessDefinition);
                    }
                    catch (SProcessDefinitionNotFoundException e) {
                    }
                    catch (SProcessDefinitionReadException e) {
                        // empty catch block
                    }
                }
                clientProcessInstances.add(ModelConvertor.toProcessInstance(sProcessDefinition, sProcessInstance));
            }
        }
        return Collections.unmodifiableList(clientProcessInstances);
    }

    public static ProcessInstance toProcessInstance(SProcessDefinition definition, SProcessInstance sInstance) {
        ProcessInstanceBuilder clientProcessInstanceBuilder = ProcessInstanceBuilder.getInstance().createNewInstance(sInstance.getName());
        clientProcessInstanceBuilder.setId(sInstance.getId());
        clientProcessInstanceBuilder.setState(ProcessInstanceState.getFromId((int)sInstance.getStateId()).name().toLowerCase());
        if (sInstance.getStartDate() > 0L) {
            clientProcessInstanceBuilder.setStartDate(sInstance.getStartDate());
        }
        clientProcessInstanceBuilder.setStartedBy(sInstance.getStartedBy());
        clientProcessInstanceBuilder.setStartedByDelegate(sInstance.getStartedByDelegate());
        if (sInstance.getEndDate() > 0L) {
            clientProcessInstanceBuilder.setEndDate(sInstance.getEndDate());
        }
        clientProcessInstanceBuilder.setLastUpdate(sInstance.getLastUpdate());
        clientProcessInstanceBuilder.setProcessDefinitionId(sInstance.getProcessDefinitionId());
        clientProcessInstanceBuilder.setDescription(sInstance.getDescription());
        clientProcessInstanceBuilder.setRootProcessInstanceId(sInstance.getRootProcessInstanceId());
        clientProcessInstanceBuilder.setCallerId(sInstance.getCallerId());
        if (definition != null) {
            for (int i = 1; i <= 5; ++i) {
                clientProcessInstanceBuilder.setStringIndexLabel(i, definition.getStringIndexLabel(i));
            }
        }
        clientProcessInstanceBuilder.setStringIndex1(sInstance.getStringIndex1());
        clientProcessInstanceBuilder.setStringIndex2(sInstance.getStringIndex2());
        clientProcessInstanceBuilder.setStringIndex3(sInstance.getStringIndex3());
        clientProcessInstanceBuilder.setStringIndex4(sInstance.getStringIndex4());
        clientProcessInstanceBuilder.setStringIndex5(sInstance.getStringIndex5());
        return clientProcessInstanceBuilder.done();
    }

    public static List<ProcessDeploymentInfo> toProcessDeploymentInfo(List<SProcessDefinitionDeployInfo> processDefinitionDIs) {
        ArrayList<ProcessDeploymentInfo> deploymentInfos = new ArrayList<ProcessDeploymentInfo>();
        for (SProcessDefinitionDeployInfo processDefinitionDI : processDefinitionDIs) {
            ProcessDeploymentInfo deploymentInfo = ModelConvertor.toProcessDeploymentInfo(processDefinitionDI);
            deploymentInfos.add(deploymentInfo);
        }
        return deploymentInfos;
    }

    public static ProcessDeploymentInfo toProcessDeploymentInfo(SProcessDefinitionDeployInfo processDefinitionDI) {
        return new ProcessDeploymentInfoImpl(processDefinitionDI.getId(), processDefinitionDI.getProcessId(), processDefinitionDI.getName(), processDefinitionDI.getVersion(), processDefinitionDI.getDescription(), new Date(processDefinitionDI.getDeploymentDate()), processDefinitionDI.getDeployedBy(), ActivationState.valueOf((String)processDefinitionDI.getActivationState()), ConfigurationState.valueOf((String)processDefinitionDI.getConfigurationState()), processDefinitionDI.getDisplayName(), new Date(processDefinitionDI.getLastUpdateDate()), processDefinitionDI.getIconPath(), processDefinitionDI.getDisplayDescription());
    }

    public static ArchivedUserTaskInstance toArchivedUserTaskInstance(SAUserTaskInstance sInstance, FlowNodeStateManager flowNodeStateManager) {
        ArchivedUserTaskInstanceImpl archivedUserTaskInstanceImpl = new ArchivedUserTaskInstanceImpl(sInstance.getName());
        ModelConvertor.updateArchivedHumanTaskInstance((ArchivedHumanTaskInstanceImpl)archivedUserTaskInstanceImpl, flowNodeStateManager, sInstance);
        return archivedUserTaskInstanceImpl;
    }

    public static ArchivedReceiveTaskInstance toArchivedReceiveTaskInstance(SAReceiveTaskInstance sInstance, FlowNodeStateManager flowNodeStateManager) {
        ArchivedReceiveTaskInstanceImpl archivedReceiveTaskInstanceImpl = new ArchivedReceiveTaskInstanceImpl(sInstance.getName());
        ModelConvertor.updateArchivedReceiveTaskInstance((ArchivedHumanTaskInstanceImpl)archivedReceiveTaskInstanceImpl, flowNodeStateManager, sInstance);
        return archivedReceiveTaskInstanceImpl;
    }

    public static ArchivedSendTaskInstance toArchivedSendTaskInstance(SASendTaskInstance sInstance, FlowNodeStateManager flowNodeStateManager) {
        ArchivedSendTaskInstanceImpl archivedSendTaskInstanceImpl = new ArchivedSendTaskInstanceImpl(sInstance.getName());
        ModelConvertor.updateArchivedSendTaskInstance((ArchivedHumanTaskInstanceImpl)archivedSendTaskInstanceImpl, flowNodeStateManager, sInstance);
        return archivedSendTaskInstanceImpl;
    }

    private static void updateArchivedHumanTaskInstance(ArchivedHumanTaskInstanceImpl activity, FlowNodeStateManager flowNodeStateManager, SAHumanTaskInstance saHumanTask) {
        ModelConvertor.updateArchivedActivityInstance((ArchivedActivityInstanceImpl)activity, flowNodeStateManager, saHumanTask);
        activity.setAssigneeId(saHumanTask.getAssigneeId());
        activity.setPriority(TaskPriority.valueOf((String)saHumanTask.getPriority().name()));
        activity.setActorId(saHumanTask.getActorId());
        if (saHumanTask.getExpectedEndDate() > 0L) {
            activity.setExpectedEndDate(new Date(saHumanTask.getExpectedEndDate()));
        }
    }

    private static void updateArchivedReceiveTaskInstance(ArchivedHumanTaskInstanceImpl activity, FlowNodeStateManager flowNodeStateManager, SAReceiveTaskInstance sActivity) {
        String state = flowNodeStateManager.getState(sActivity.getStateId()).getName();
        ModelConvertor.updateArchivedFlowNodeInstance((ArchivedFlowNodeInstanceImpl)activity, sActivity, state);
        activity.setReachedStateDate(new Date(sActivity.getReachedStateDate()));
        activity.setLastUpdateDate(new Date(sActivity.getLastUpdateDate()));
    }

    private static void updateArchivedSendTaskInstance(ArchivedHumanTaskInstanceImpl activity, FlowNodeStateManager flowNodeStateManager, SASendTaskInstance sActivity) {
        String state = flowNodeStateManager.getState(sActivity.getStateId()).getName();
        ModelConvertor.updateArchivedFlowNodeInstance((ArchivedFlowNodeInstanceImpl)activity, sActivity, state);
        activity.setReachedStateDate(new Date(sActivity.getReachedStateDate()));
        activity.setLastUpdateDate(new Date(sActivity.getLastUpdateDate()));
    }

    private static void updateArchivedActivityInstance(ArchivedActivityInstanceImpl activity, FlowNodeStateManager flowNodeStateManager, SAActivityInstance sActivity) {
        String state = flowNodeStateManager.getState(sActivity.getStateId()).getName();
        ModelConvertor.updateArchivedFlowNodeInstance((ArchivedFlowNodeInstanceImpl)activity, sActivity, state);
        activity.setReachedStateDate(new Date(sActivity.getReachedStateDate()));
        activity.setLastUpdateDate(new Date(sActivity.getLastUpdateDate()));
    }

    private static void updateArchivedFlowNodeInstance(ArchivedFlowNodeInstanceImpl aFlowNode, SAFlowNodeInstance saFlowNode, String state) {
        aFlowNode.setId(saFlowNode.getId());
        aFlowNode.setState(state);
        aFlowNode.setParentContainerId(saFlowNode.getParentContainerId());
        aFlowNode.setRootContainerId(saFlowNode.getRootContainerId());
        aFlowNode.setSourceObjectId(saFlowNode.getSourceObjectId());
        aFlowNode.setProcessDefinitionId(saFlowNode.getLogicalGroup(0));
        aFlowNode.setProcessInstanceId(saFlowNode.getLogicalGroup(1));
        aFlowNode.setParentActivityInstanceId(saFlowNode.getLogicalGroup(2));
        aFlowNode.setDescription(saFlowNode.getDescription());
        aFlowNode.setDisplayName(saFlowNode.getDisplayName());
        aFlowNode.setDisplayDescription(saFlowNode.getDisplayDescription());
        if (saFlowNode.getArchiveDate() > 0L) {
            aFlowNode.setArchiveDate(new Date(saFlowNode.getArchiveDate()));
        }
        aFlowNode.setExecutedBy(saFlowNode.getExecutedBy());
        aFlowNode.setExecutedByDelegate(saFlowNode.getExecutedByDelegate());
        aFlowNode.setFlownodeDefinitionId(saFlowNode.getFlowNodeDefinitionId());
        aFlowNode.setTerminal(saFlowNode.isTerminal());
    }

    public static List<ArchivedUserTaskInstance> toArchivedUserTaskInstances(List<SAUserTaskInstance> sInstances, FlowNodeStateManager flowNodeStateManager) {
        ArrayList<ArchivedUserTaskInstance> archivedUserTaskInstances = new ArrayList<ArchivedUserTaskInstance>();
        for (SAUserTaskInstance sAUserTaskInstance : sInstances) {
            ArchivedUserTaskInstance archivedUserTaskInstance = ModelConvertor.toArchivedUserTaskInstance(sAUserTaskInstance, flowNodeStateManager);
            archivedUserTaskInstances.add(archivedUserTaskInstance);
        }
        return archivedUserTaskInstances;
    }

    public static List<ArchivedReceiveTaskInstance> toArchivedReceiveTaskInstances(List<SAReceiveTaskInstance> sInstances, FlowNodeStateManager flowNodeStateManager) {
        ArrayList<ArchivedReceiveTaskInstance> archivedReceiveTaskInstances = new ArrayList<ArchivedReceiveTaskInstance>();
        for (SAReceiveTaskInstance sAReceiveTaskInstance : sInstances) {
            ArchivedReceiveTaskInstance archivedReceiveTaskInstance = ModelConvertor.toArchivedReceiveTaskInstance(sAReceiveTaskInstance, flowNodeStateManager);
            archivedReceiveTaskInstances.add(archivedReceiveTaskInstance);
        }
        return archivedReceiveTaskInstances;
    }

    public static List<ArchivedHumanTaskInstance> toArchivedHumanTaskInstances(List<? extends SAHumanTaskInstance> sInstances, FlowNodeStateManager flowNodeStateManager) {
        ArrayList<ArchivedHumanTaskInstance> archivedUserTaskInstances = new ArrayList<ArchivedHumanTaskInstance>();
        for (SAHumanTaskInstance sAHumanTaskInstance : sInstances) {
            ArchivedHumanTaskInstance archivedUserTaskInstance = ModelConvertor.toArchivedHumanTaskInstance(sAHumanTaskInstance, flowNodeStateManager);
            archivedUserTaskInstances.add(archivedUserTaskInstance);
        }
        return archivedUserTaskInstances;
    }

    public static ArchivedHumanTaskInstance toArchivedHumanTaskInstance(SAHumanTaskInstance sInstance, FlowNodeStateManager flowNodeStateManager) {
        switch (sInstance.getType()) {
            case MANUAL_TASK: {
                return ModelConvertor.toArchivedManualTaskInstance((SAManualTaskInstance)sInstance, flowNodeStateManager);
            }
            case USER_TASK: {
                return ModelConvertor.toArchivedUserTaskInstance((SAUserTaskInstance)sInstance, flowNodeStateManager);
            }
        }
        throw new UnknownElementType(sInstance.getType().name());
    }

    public static ArchivedActivityInstance toArchivedActivityInstance(SAActivityInstance sInstance, FlowNodeStateManager flowNodeStateManager) {
        switch (sInstance.getType()) {
            case AUTOMATIC_TASK: {
                return ModelConvertor.toArchivedAutomaticTaskInstance(sInstance, flowNodeStateManager);
            }
            case MANUAL_TASK: {
                return ModelConvertor.toArchivedManualTaskInstance((SAManualTaskInstance)sInstance, flowNodeStateManager);
            }
            case USER_TASK: {
                return ModelConvertor.toArchivedUserTaskInstance((SAUserTaskInstance)sInstance, flowNodeStateManager);
            }
            case RECEIVE_TASK: {
                return ModelConvertor.toArchivedReceiveTaskInstance((SAReceiveTaskInstance)sInstance, flowNodeStateManager);
            }
            case SEND_TASK: {
                return ModelConvertor.toArchivedSendTaskInstance((SASendTaskInstance)sInstance, flowNodeStateManager);
            }
            case LOOP_ACTIVITY: {
                return ModelConvertor.toArchivedLoopActivityInstance((SALoopActivityInstance)sInstance, flowNodeStateManager);
            }
            case CALL_ACTIVITY: {
                return ModelConvertor.toArchivedCallActivityInstance((SACallActivityInstance)sInstance, flowNodeStateManager);
            }
            case SUB_PROCESS: {
                return ModelConvertor.toArchivedSubProcessActivityInstance((SASubProcessActivityInstance)sInstance, flowNodeStateManager);
            }
            case MULTI_INSTANCE_ACTIVITY: {
                return ModelConvertor.toArchivedMultiInstanceActivityInstance((SAMultiInstanceActivityInstance)sInstance, flowNodeStateManager);
            }
            case START_EVENT: 
            case INTERMEDIATE_CATCH_EVENT: 
            case BOUNDARY_EVENT: 
            case INTERMEDIATE_THROW_EVENT: 
            case END_EVENT: 
            case GATEWAY: {
                throw new UnknownElementType("Events are not yet archived");
            }
        }
        throw new UnknownElementType(sInstance.getType().name());
    }

    private static ArchivedLoopActivityInstance toArchivedLoopActivityInstance(SALoopActivityInstance sInstance, FlowNodeStateManager flowNodeStateManager) {
        ArchivedLoopActivityInstanceImpl archivedloopActivityInstanceImpl = new ArchivedLoopActivityInstanceImpl(sInstance.getName());
        archivedloopActivityInstanceImpl.setLoopCounter(sInstance.getLoopCounter());
        archivedloopActivityInstanceImpl.setLoopMax(sInstance.getLoopMax());
        ModelConvertor.updateArchivedActivityInstance((ArchivedActivityInstanceImpl)archivedloopActivityInstanceImpl, flowNodeStateManager, sInstance);
        return archivedloopActivityInstanceImpl;
    }

    private static ArchivedMultiInstanceActivityInstanceImpl toArchivedMultiInstanceActivityInstance(SAMultiInstanceActivityInstance sInstance, FlowNodeStateManager flowNodeStateManager) {
        ArchivedMultiInstanceActivityInstanceImpl archivedMultiInstanceActivityInstanceImpl = new ArchivedMultiInstanceActivityInstanceImpl(sInstance.getName(), sInstance.getFlowNodeDefinitionId(), sInstance.isSequential(), sInstance.getLoopDataInputRef(), sInstance.getLoopDataOutputRef(), sInstance.getDataInputItemRef(), sInstance.getDataOutputItemRef(), sInstance.getNumberOfActiveInstances(), sInstance.getNumberOfCompletedInstances(), sInstance.getNumberOfTerminatedInstances(), sInstance.getLoopCardinality());
        ModelConvertor.updateArchivedActivityInstance((ArchivedActivityInstanceImpl)archivedMultiInstanceActivityInstanceImpl, flowNodeStateManager, sInstance);
        return archivedMultiInstanceActivityInstanceImpl;
    }

    public static ArchivedManualTaskInstance toArchivedManualTaskInstance(SAManualTaskInstance sInstance, FlowNodeStateManager flowNodeStateManager) {
        ArchivedManualTaskInstanceImpl archivedUserTaskInstanceImpl = new ArchivedManualTaskInstanceImpl(sInstance.getName());
        ModelConvertor.updateArchivedHumanTaskInstance((ArchivedHumanTaskInstanceImpl)archivedUserTaskInstanceImpl, flowNodeStateManager, sInstance);
        return archivedUserTaskInstanceImpl;
    }

    public static ArchivedCallActivityInstance toArchivedCallActivityInstance(SACallActivityInstance sInstance, FlowNodeStateManager flowNodeStateManager) {
        ArchivedCallActivityInstanceImpl archivedCallActivityInstanceImpl = new ArchivedCallActivityInstanceImpl(sInstance.getName());
        ModelConvertor.updateArchivedActivityInstance((ArchivedActivityInstanceImpl)archivedCallActivityInstanceImpl, flowNodeStateManager, sInstance);
        return archivedCallActivityInstanceImpl;
    }

    public static ArchivedSubProcessActivityInstance toArchivedSubProcessActivityInstance(SASubProcessActivityInstance sInstance, FlowNodeStateManager flowNodeStateManager) {
        ArchivedSubProcessActivityInstanceImpl archivedSubProcActivityInstanceImpl = new ArchivedSubProcessActivityInstanceImpl(sInstance.getName(), sInstance.isTriggeredByEvent());
        ModelConvertor.updateArchivedActivityInstance((ArchivedActivityInstanceImpl)archivedSubProcActivityInstanceImpl, flowNodeStateManager, sInstance);
        return archivedSubProcActivityInstanceImpl;
    }

    public static ArchivedAutomaticTaskInstance toArchivedAutomaticTaskInstance(SAActivityInstance sInstance, FlowNodeStateManager flowNodeStateManager) {
        ArchivedAutomaticTaskInstanceImpl archivedUserTaskInstanceImpl = new ArchivedAutomaticTaskInstanceImpl(sInstance.getName());
        ModelConvertor.updateArchivedActivityInstance((ArchivedActivityInstanceImpl)archivedUserTaskInstanceImpl, flowNodeStateManager, sInstance);
        return archivedUserTaskInstanceImpl;
    }

    public static List<ArchivedActivityInstance> toArchivedActivityInstances(List<SAActivityInstance> saActivityInstances, FlowNodeStateManager flowNodeStateManager) {
        ArrayList<ArchivedActivityInstance> archivedActivityInstances = new ArrayList<ArchivedActivityInstance>();
        for (SAActivityInstance saActivityInstance : saActivityInstances) {
            ArchivedActivityInstance archivedActivityInstance = ModelConvertor.toArchivedActivityInstance(saActivityInstance, flowNodeStateManager);
            archivedActivityInstances.add(archivedActivityInstance);
        }
        return archivedActivityInstances;
    }

    public static List<ArchivedProcessInstance> toArchivedProcessInstances(List<SAProcessInstance> sProcessInstances) {
        ArrayList<ArchivedProcessInstance> clientProcessInstances = new ArrayList<ArchivedProcessInstance>(sProcessInstances.size());
        for (SAProcessInstance sProcessInstance : sProcessInstances) {
            clientProcessInstances.add(ModelConvertor.toArchivedProcessInstance(sProcessInstance));
        }
        return Collections.unmodifiableList(clientProcessInstances);
    }

    public static ArchivedProcessInstance toArchivedProcessInstance(SAProcessInstance sInstance) {
        ArchivedProcessInstanceImpl archivedInstance = new ArchivedProcessInstanceImpl(sInstance.getName());
        archivedInstance.setId(sInstance.getId());
        int stateId = sInstance.getStateId();
        archivedInstance.setStateId(stateId);
        archivedInstance.setState(ProcessInstanceState.getFromId((int)stateId).name().toLowerCase());
        if (sInstance.getStartDate() > 0L) {
            archivedInstance.setStartDate(new Date(sInstance.getStartDate()));
        }
        archivedInstance.setStartedBy(sInstance.getStartedBy());
        if (sInstance.getEndDate() > 0L) {
            archivedInstance.setEndDate(new Date(sInstance.getEndDate()));
        }
        if (sInstance.getArchiveDate() > 0L) {
            archivedInstance.setArchiveDate(new Date(sInstance.getArchiveDate()));
        }
        if (sInstance.getLastUpdate() > 0L) {
            archivedInstance.setLastUpdate(new Date(sInstance.getLastUpdate()));
        }
        archivedInstance.setProcessDefinitionId(sInstance.getProcessDefinitionId());
        archivedInstance.setDescription(sInstance.getDescription());
        archivedInstance.setSourceObjectId(sInstance.getSourceObjectId());
        archivedInstance.setRootProcessInstanceId(sInstance.getRootProcessInstanceId());
        archivedInstance.setCallerId(sInstance.getCallerId());
        return archivedInstance;
    }

    public static List<Group> toGroups(List<SGroup> sGroups) {
        ArrayList<Group> clientGroups = new ArrayList<Group>();
        if (sGroups != null) {
            for (SGroup sGroup : sGroups) {
                clientGroups.add(ModelConvertor.toGroup(sGroup));
            }
        }
        return Collections.unmodifiableList(clientGroups);
    }

    public static Group toGroup(SGroup sGroup) {
        GroupImpl group = new GroupImpl(sGroup.getId(), sGroup.getName());
        group.setParentPath(sGroup.getParentPath());
        group.setCreatedBy(sGroup.getCreatedBy());
        group.setCreationDate(new Date(sGroup.getCreationDate()));
        group.setDescription(sGroup.getDescription());
        group.setDisplayName(sGroup.getDisplayName());
        group.setIconName(sGroup.getIconName());
        group.setIconPath(sGroup.getIconPath());
        group.setLastUpdate(new Date(sGroup.getLastUpdate()));
        return group;
    }

    public static User toUser(SUser sUser) {
        return ModelConvertor.toUser(sUser, null);
    }

    public static User toUser(SUser sUser, Map<Long, SUser> userIdToUser) {
        UserImpl user = new UserImpl(sUser.getId(), sUser.getUserName(), "");
        user.setFirstName(sUser.getFirstName());
        user.setLastName(sUser.getLastName());
        user.setTitle(sUser.getTitle());
        user.setJobTitle(sUser.getJobTitle());
        user.setCreatedBy(sUser.getCreatedBy());
        user.setCreationDate(new Date(sUser.getCreationDate()));
        user.setIconName(sUser.getIconName());
        user.setIconPath(sUser.getIconPath());
        user.setLastUpdate(new Date(sUser.getLastUpdate()));
        user.setEnabled(sUser.isEnabled());
        long managerUserId = sUser.getManagerUserId();
        user.setManagerUserId(managerUserId);
        if (managerUserId > 0L && userIdToUser != null) {
            user.setManagerUserName(userIdToUser.get(managerUserId).getUserName());
        }
        if (sUser.getLastConnection() != null) {
            user.setLastConnection(new Date(sUser.getLastConnection()));
        }
        return user;
    }

    public static ContactData toUserContactData(SContactInfo sContactData) {
        ContactDataImpl contactData = new ContactDataImpl(sContactData.getUserId().longValue());
        contactData.setAddress(sContactData.getAddress());
        contactData.setBuilding(sContactData.getBuilding());
        contactData.setCity(sContactData.getCity());
        contactData.setCountry(sContactData.getCountry());
        contactData.setEmail(sContactData.getEmail());
        contactData.setFaxNumber(sContactData.getFaxNumber());
        contactData.setMobileNumber(sContactData.getMobileNumber());
        contactData.setPersonal(sContactData.isPersonal());
        contactData.setPhoneNumber(sContactData.getPhoneNumber());
        contactData.setRoom(sContactData.getRoom());
        contactData.setState(sContactData.getState());
        contactData.setWebsite(sContactData.getWebsite());
        contactData.setZipCode(sContactData.getZipCode());
        return contactData;
    }

    public static List<User> toUsers(List<SUser> sUsers, Map<Long, SUser> userIdToUser) {
        ArrayList<User> users = new ArrayList<User>();
        if (sUsers != null) {
            for (SUser sUser : sUsers) {
                User user = ModelConvertor.toUser(sUser, userIdToUser);
                users.add(user);
            }
        }
        return Collections.unmodifiableList(users);
    }

    public static List<User> toUsers(List<SUser> sUsers) {
        return ModelConvertor.toUsers(sUsers, null);
    }

    public static Role toRole(SRole sRole) {
        RoleImpl role = new RoleImpl(sRole.getId(), sRole.getName());
        role.setDisplayName(sRole.getDisplayName());
        role.setDescription(sRole.getDescription());
        role.setIconName(sRole.getIconName());
        role.setIconPath(sRole.getIconPath());
        role.setCreatedBy(sRole.getCreatedBy());
        role.setCreationDate(new Date(sRole.getCreationDate()));
        role.setLastUpdate(new Date(sRole.getLastUpdate()));
        return role;
    }

    public static List<Role> toRoles(List<SRole> sRoles) {
        ArrayList<Role> lightRoles = new ArrayList<Role>();
        if (sRoles != null) {
            for (SRole sRole : sRoles) {
                Role role = ModelConvertor.toRole(sRole);
                lightRoles.add(role);
            }
        }
        return Collections.unmodifiableList(lightRoles);
    }

    public static UserMembership toUserMembership(SUserMembership sUserMembership) {
        UserMembershipImpl userMembership = new UserMembershipImpl(sUserMembership.getId(), sUserMembership.getUserId(), sUserMembership.getGroupId(), sUserMembership.getRoleId());
        userMembership.setAssignedBy(sUserMembership.getAssignedBy());
        userMembership.setAssignedDate(new Date(sUserMembership.getAssignedDate()));
        userMembership.setGroupName(sUserMembership.getGroupName());
        userMembership.setRoleName(sUserMembership.getRoleName());
        userMembership.setUsername(sUserMembership.getUsername());
        return userMembership;
    }

    public static List<UserMembership> toUserMembership(List<SUserMembership> sUserMemberships) {
        ArrayList<UserMembership> userMemberships = new ArrayList<UserMembership>();
        if (sUserMemberships != null) {
            for (SUserMembership sMembership : sUserMemberships) {
                UserMembership userMembership = ModelConvertor.toUserMembership(sMembership);
                userMemberships.add(userMembership);
            }
        }
        return Collections.unmodifiableList(userMemberships);
    }

    public static List<UserMembership> toUserMembership(List<SUserMembership> sUserMemberships, Map<Long, String> userNames, Map<Long, String> groupIdToGroup) {
        ArrayList<UserMembership> userMemberships = new ArrayList<UserMembership>();
        if (sUserMemberships != null) {
            for (SUserMembership sMembership : sUserMemberships) {
                UserMembership userMembership = ModelConvertor.toUserMembership(sMembership, userNames, groupIdToGroup);
                userMemberships.add(userMembership);
            }
        }
        return Collections.unmodifiableList(userMemberships);
    }

    private static UserMembership toUserMembership(SUserMembership sUserMembership, Map<Long, String> userNames, Map<Long, String> groupIdToGroup) {
        UserMembershipImpl userMembership = new UserMembershipImpl(sUserMembership.getId(), sUserMembership.getUserId(), sUserMembership.getGroupId(), sUserMembership.getRoleId());
        userMembership.setGroupName(sUserMembership.getGroupName());
        userMembership.setGroupParentPath(groupIdToGroup.get(sUserMembership.getGroupId()));
        userMembership.setRoleName(sUserMembership.getRoleName());
        userMembership.setUsername(sUserMembership.getUsername());
        long assignedBy = sUserMembership.getAssignedBy();
        userMembership.setAssignedBy(assignedBy);
        if (assignedBy > 0L) {
            userMembership.setAssignedByName(userNames.get(assignedBy));
        }
        userMembership.setAssignedDate(new Date(sUserMembership.getAssignedDate()));
        return userMembership;
    }

    public static Category toCategory(SCategory sCategory) {
        CategoryImpl category = new CategoryImpl(sCategory.getId(), sCategory.getName());
        category.setDescription(sCategory.getDescription());
        category.setCreator(sCategory.getCreator());
        category.setCreationDate(new Date(sCategory.getCreationDate()));
        category.setLastUpdate(new Date(sCategory.getLastUpdateDate()));
        return category;
    }

    public static CommandDescriptor toCommandDescriptor(SCommand command) {
        CommandDescriptorImpl commandDescriptor = new CommandDescriptorImpl(command.getName(), command.getDescription(), command.getImplementation());
        commandDescriptor.setId(command.getId());
        commandDescriptor.setSystem(command.getSystem());
        return commandDescriptor;
    }

    public static CommandDescriptor toCommandDescriptor(SPlatformCommand platformCommand) {
        CommandDescriptorImpl commandDescriptor = new CommandDescriptorImpl(platformCommand.getName(), platformCommand.getDescription(), platformCommand.getImplementation());
        commandDescriptor.setId(platformCommand.getId());
        return commandDescriptor;
    }

    public static List<CommandDescriptor> toCommandDescriptors(List<SCommand> sCommands) {
        if (sCommands != null) {
            ArrayList<CommandDescriptor> commandList = new ArrayList<CommandDescriptor>();
            for (SCommand sCommand : sCommands) {
                commandList.add(ModelConvertor.toCommandDescriptor(sCommand));
            }
            return Collections.unmodifiableList(commandList);
        }
        return Collections.emptyList();
    }

    public static List<CommandDescriptor> toPlatformCommandDescriptors(List<SPlatformCommand> sPlatformCommands) {
        if (sPlatformCommands != null) {
            ArrayList<CommandDescriptor> platformCommandList = new ArrayList<CommandDescriptor>();
            for (SPlatformCommand sCommand : sPlatformCommands) {
                platformCommandList.add(ModelConvertor.toCommandDescriptor(sCommand));
            }
            return Collections.unmodifiableList(platformCommandList);
        }
        return Collections.emptyList();
    }

    public static List<Category> toCategories(List<SCategory> sCategories) {
        if (sCategories != null) {
            ArrayList<Category> categoryList = new ArrayList<Category>();
            for (SCategory sCategory : sCategories) {
                categoryList.add(ModelConvertor.toCategory(sCategory));
            }
            return Collections.unmodifiableList(categoryList);
        }
        return Collections.emptyList();
    }

    public static List<EventInstance> toEventInstances(Collection<SEventInstance> sEvents, FlowNodeStateManager flowNodeStateManager) {
        ArrayList<EventInstance> eventInstances = new ArrayList<EventInstance>();
        for (SEventInstance sEvent : sEvents) {
            EventInstance eventInstance = ModelConvertor.toEventInstance(sEvent, flowNodeStateManager);
            eventInstances.add(eventInstance);
        }
        return eventInstances;
    }

    public static EventInstance toEventInstance(SEventInstance sEvent, FlowNodeStateManager flowNodeStateManager) {
        EventInstanceImpl eventInstance = ModelConvertor.getEventInstance(sEvent);
        ModelConvertor.updateFlowNode((FlowNodeInstanceImpl)eventInstance, sEvent, flowNodeStateManager.getState(sEvent.getStateId()).getName());
        return eventInstance;
    }

    public static WaitingEvent toWaitingEvent(SWaitingEvent sWaitingEvent) {
        WaitingErrorEventImpl waitingEvent;
        BPMEventType bpmEventType = BPMEventType.valueOf((String)sWaitingEvent.getEventType().name());
        long processDefinitionId = sWaitingEvent.getProcessDefinitionId();
        String processName = sWaitingEvent.getProcessName();
        long flowNodeDefinitionId = sWaitingEvent.getFlowNodeDefinitionId();
        switch (sWaitingEvent.getEventTriggerType()) {
            case ERROR: {
                SWaitingErrorEvent sWaitingErrorEvent = (SWaitingErrorEvent)sWaitingEvent;
                waitingEvent = new WaitingErrorEventImpl(bpmEventType, processDefinitionId, processName, flowNodeDefinitionId, sWaitingErrorEvent.getErrorCode());
                break;
            }
            case MESSAGE: {
                SWaitingMessageEvent sWaitingMessageEvent = (SWaitingMessageEvent)sWaitingEvent;
                waitingEvent = new WaitingMessageEventImpl(bpmEventType, processDefinitionId, processName, flowNodeDefinitionId, sWaitingMessageEvent.getMessageName());
                break;
            }
            case SIGNAL: {
                SWaitingSignalEvent sWaitingSignalEvent = (SWaitingSignalEvent)sWaitingEvent;
                waitingEvent = new WaitingSignalEventImpl(bpmEventType, processDefinitionId, processName, flowNodeDefinitionId, sWaitingSignalEvent.getSignalName());
                break;
            }
            default: {
                throw new UnknownElementType(sWaitingEvent.getClass().getName());
            }
        }
        return waitingEvent;
    }

    public static List<WaitingEvent> toWaitingEvents(List<SWaitingEvent> sWaitingEvents) {
        ArrayList<WaitingEvent> waitingEvents = new ArrayList<WaitingEvent>(sWaitingEvents.size());
        for (SWaitingEvent sWaitingEvent : sWaitingEvents) {
            waitingEvents.add(ModelConvertor.toWaitingEvent(sWaitingEvent));
        }
        return Collections.unmodifiableList(waitingEvents);
    }

    private static EventInstanceImpl getEventInstance(SEventInstance sEvent) {
        switch (sEvent.getType()) {
            case END_EVENT: {
                return new EndEventInstanceImpl(sEvent.getName(), sEvent.getFlowNodeDefinitionId());
            }
            case INTERMEDIATE_CATCH_EVENT: {
                return new IntermediateCatchEventInstanceImpl(sEvent.getName(), sEvent.getFlowNodeDefinitionId());
            }
            case INTERMEDIATE_THROW_EVENT: {
                return new IntermediateThrowEventInstanceImpl(sEvent.getName(), sEvent.getFlowNodeDefinitionId());
            }
            case BOUNDARY_EVENT: {
                return new BoundaryEventInstanceImpl(sEvent.getName(), sEvent.getFlowNodeDefinitionId(), ((SBoundaryEventInstance)sEvent).getActivityInstanceId());
            }
            case START_EVENT: {
                return new StartEventInstanceImpl(sEvent.getName(), sEvent.getFlowNodeDefinitionId());
            }
        }
        throw new UnknownElementType(sEvent.getType().name());
    }

    public static List<DataInstance> toDataInstances(List<SDataInstance> sDataInstances) {
        if (sDataInstances != null) {
            ArrayList<DataInstance> dataInstanceList = new ArrayList<DataInstance>();
            for (SDataInstance sDataInstance : sDataInstances) {
                dataInstanceList.add(ModelConvertor.toDataInstance(sDataInstance));
            }
            return Collections.unmodifiableList(dataInstanceList);
        }
        return Collections.emptyList();
    }

    public static List<DataDefinition> toDataDefinitions(List<SDataDefinition> sDataDefinitions) {
        if (sDataDefinitions != null) {
            ArrayList<DataDefinition> dataDefinitionList = new ArrayList<DataDefinition>();
            for (SDataDefinition sDataDefinition : sDataDefinitions) {
                dataDefinitionList.add(ModelConvertor.toDataDefinition(sDataDefinition));
            }
            return Collections.unmodifiableList(dataDefinitionList);
        }
        return Collections.emptyList();
    }

    public static DataDefinition toDataDefinition(SDataDefinition sDataDefinition) {
        DataDefinitionImpl dataDefinitionImpl = null;
        if (sDataDefinition != null) {
            dataDefinitionImpl = new DataDefinitionImpl(sDataDefinition.getName(), ModelConvertor.toExpression(sDataDefinition.getDefaultValueExpression()));
            dataDefinitionImpl.setClassName(sDataDefinition.getClassName());
            dataDefinitionImpl.setDescription(sDataDefinition.getDescription());
            dataDefinitionImpl.setTransientData(sDataDefinition.isTransientData().booleanValue());
        }
        return dataDefinitionImpl;
    }

    public static List<Expression> toExpressions(List<SExpression> sExpressions) {
        if (sExpressions != null && !sExpressions.isEmpty()) {
            ArrayList<Expression> expList = new ArrayList<Expression>(sExpressions.size());
            for (SExpression sexp : sExpressions) {
                expList.add(ModelConvertor.toExpression(sexp));
            }
            return expList;
        }
        return Collections.emptyList();
    }

    public static Expression toExpression(SExpression sexp) {
        ExpressionImpl exp = new ExpressionImpl();
        if (sexp != null) {
            exp.setContent(sexp.getContent());
            exp.setExpressionType(sexp.getExpressionType());
            exp.setInterpreter(sexp.getInterpreter());
            exp.setName(sexp.getName());
            exp.setReturnType(sexp.getReturnType());
            exp.setDependencies(ModelConvertor.toExpressions(sexp.getDependencies()));
        }
        return exp;
    }

    public static DataInstance toDataInstance(SDataInstance sDataInstance) {
        Object dataInstance = sDataInstance.getClassName().equals(Integer.class.getName()) ? new IntegerDataInstanceImpl() : (sDataInstance.getClassName().equals(Long.class.getName()) ? new LongDataInstanceImpl() : (sDataInstance.getClassName().equals(Boolean.class.getName()) ? new BooleanDataInstanceImpl() : (sDataInstance.getClassName().equals(Date.class.getName()) ? new DateDataInstanceImpl() : (sDataInstance.getClassName().equals(Double.class.getName()) ? new DoubleDataInstanceImpl() : (sDataInstance.getClassName().equals(Float.class.getName()) ? new FloatDataInstanceImpl() : (sDataInstance.getClassName().equals(String.class.getName()) ? new ShortTextDataInstanceImpl() : new BlobDataInstanceImpl()))))));
        dataInstance.setTransientData(sDataInstance.isTransientData().booleanValue());
        dataInstance.setClassName(sDataInstance.getClassName());
        dataInstance.setContainerId(sDataInstance.getContainerId());
        dataInstance.setContainerType(sDataInstance.getContainerType());
        dataInstance.setDataTypeClassName(sDataInstance.getClassName());
        dataInstance.setDescription(sDataInstance.getDescription());
        dataInstance.setId(sDataInstance.getId());
        dataInstance.setName(sDataInstance.getName());
        dataInstance.setValue(sDataInstance.getValue());
        return dataInstance;
    }

    public static List<ArchivedDataInstance> toArchivedDataInstances(List<SADataInstance> sADataInstances) {
        ArrayList<ArchivedDataInstance> dataInstances = new ArrayList<ArchivedDataInstance>();
        for (SADataInstance sADataInstance : sADataInstances) {
            ArchivedDataInstance dataInstance = ModelConvertor.toArchivedDataInstance(sADataInstance);
            dataInstances.add(dataInstance);
        }
        return dataInstances;
    }

    public static ArchivedDataInstance toArchivedDataInstance(SADataInstance sDataInstance) {
        ArchivedDataInstanceImpl dataInstance = new ArchivedDataInstanceImpl();
        dataInstance.setClassName(sDataInstance.getClassName());
        dataInstance.setContainerId(sDataInstance.getContainerId());
        dataInstance.setContainerType(sDataInstance.getContainerType());
        dataInstance.setDataTypeClassName(sDataInstance.getClassName());
        dataInstance.setDescription(sDataInstance.getDescription());
        dataInstance.setId(sDataInstance.getId());
        dataInstance.setName(sDataInstance.getName());
        dataInstance.setValue(sDataInstance.getValue());
        dataInstance.setArchiveDate(new Date(sDataInstance.getArchiveDate()));
        dataInstance.setSourceObjectId(sDataInstance.getSourceObjectId());
        return dataInstance;
    }

    public static ActorMember toActorMember(SActorMember sActorMember) {
        return new ActorMemberImpl(sActorMember.getId(), sActorMember.getUserId(), sActorMember.getGroupId(), sActorMember.getRoleId());
    }

    public static List<ActorMember> toActorMembers(List<SActorMember> sActorMembers) {
        ArrayList<ActorMember> actorMembers = new ArrayList<ActorMember>();
        for (SActorMember sActorMember : sActorMembers) {
            ActorMember actorMember = ModelConvertor.toActorMember(sActorMember);
            actorMembers.add(actorMember);
        }
        return actorMembers;
    }

    public static ActorInstance toActorInstance(SActor actor) {
        String name = actor.getName();
        String description = actor.getDescription();
        long scopeId = actor.getScopeId();
        String displayName = actor.getDisplayName();
        boolean initiator = actor.isInitiator();
        ActorInstanceImpl actorInstance = new ActorInstanceImpl(name, description, displayName, scopeId, initiator);
        actorInstance.setId(actor.getId());
        return actorInstance;
    }

    public static SUser constructSUser(UserCreator creator) {
        Boolean enabled;
        String title;
        String jobTitle;
        String iconPath;
        String iconName;
        String lastName;
        long now = System.currentTimeMillis();
        SUserBuilder userBuilder = BuilderFactory.get(SUserBuilderFactory.class).createNewInstance();
        Map fields = creator.getFields();
        userBuilder.setUserName((String)fields.get(UserCreator.UserField.NAME));
        userBuilder.setPassword((String)fields.get(UserCreator.UserField.PASSWORD));
        String firstName = (String)fields.get(UserCreator.UserField.FIRST_NAME);
        if (firstName != null) {
            userBuilder.setFirstName(firstName);
        }
        if ((lastName = (String)fields.get(UserCreator.UserField.LAST_NAME)) != null) {
            userBuilder.setLastName(lastName);
        }
        if ((iconName = (String)fields.get(UserCreator.UserField.ICON_NAME)) != null) {
            userBuilder.setIconName(iconName);
        }
        if ((iconPath = (String)fields.get(UserCreator.UserField.ICON_PATH)) != null) {
            userBuilder.setIconPath(iconPath);
        }
        if ((jobTitle = (String)fields.get(UserCreator.UserField.JOB_TITLE)) != null) {
            userBuilder.setJobTitle(jobTitle);
        }
        if ((title = (String)fields.get(UserCreator.UserField.TITLE)) != null) {
            userBuilder.setTitle(title);
        }
        userBuilder.setCreatedBy(SessionInfos.getUserIdFromSession());
        Long managerUserId = (Long)fields.get(UserCreator.UserField.MANAGER_ID);
        if (managerUserId != null) {
            userBuilder.setManagerUserId(managerUserId);
        }
        if ((enabled = (Boolean)fields.get(UserCreator.UserField.ENABLED)) != null) {
            userBuilder.setEnabled(enabled);
        } else {
            userBuilder.setEnabled(Boolean.FALSE);
        }
        userBuilder.setCreationDate(now);
        userBuilder.setLastUpdate(now);
        userBuilder.setLastConnection(null);
        return userBuilder.done();
    }

    public static SContactInfo constructSUserContactInfo(UserCreator creator, long userId, boolean personal) {
        Map fields = personal ? creator.getPersoFields() : creator.getProFields();
        if (fields != null && !fields.isEmpty()) {
            String zipCode;
            String website;
            String state;
            String room;
            String phone;
            String mobile;
            String fax;
            String country;
            String city;
            String building;
            String email;
            SContactInfoBuilder contactInfoBuilder = BuilderFactory.get(SContactInfoBuilderFactory.class).createNewInstance(userId, personal);
            String address = (String)fields.get(ContactDataCreator.ContactDataField.ADDRESS);
            if (address != null) {
                contactInfoBuilder.setAddress(address);
            }
            if ((email = (String)fields.get(ContactDataCreator.ContactDataField.EMAIL)) != null) {
                contactInfoBuilder.setEmail(email);
            }
            if ((building = (String)fields.get(ContactDataCreator.ContactDataField.BUILDING)) != null) {
                contactInfoBuilder.setBuilding(building);
            }
            if ((city = (String)fields.get(ContactDataCreator.ContactDataField.CITY)) != null) {
                contactInfoBuilder.setCity(city);
            }
            if ((country = (String)fields.get(ContactDataCreator.ContactDataField.COUNTRY)) != null) {
                contactInfoBuilder.setCountry(country);
            }
            if ((fax = (String)fields.get(ContactDataCreator.ContactDataField.FAX)) != null) {
                contactInfoBuilder.setFaxNumber(fax);
            }
            if ((mobile = (String)fields.get(ContactDataCreator.ContactDataField.MOBILE)) != null) {
                contactInfoBuilder.setMobileNumber(mobile);
            }
            if ((phone = (String)fields.get(ContactDataCreator.ContactDataField.PHONE)) != null) {
                contactInfoBuilder.setPhoneNumber(phone);
            }
            if ((room = (String)fields.get(ContactDataCreator.ContactDataField.ROOM)) != null) {
                contactInfoBuilder.setRoom(room);
            }
            if ((state = (String)fields.get(ContactDataCreator.ContactDataField.STATE)) != null) {
                contactInfoBuilder.setState(state);
            }
            if ((website = (String)fields.get(ContactDataCreator.ContactDataField.WEBSITE)) != null) {
                contactInfoBuilder.setWebsite(website);
            }
            if ((zipCode = (String)fields.get(ContactDataCreator.ContactDataField.ZIP_CODE)) != null) {
                contactInfoBuilder.setZipCode(zipCode);
            }
            return contactInfoBuilder.done();
        }
        return null;
    }

    public static SUser constructSUser(ExportedUser newUser) {
        SUserBuilder userBuilder = BuilderFactory.get(SUserBuilderFactory.class).createNewInstance();
        long now = System.currentTimeMillis();
        userBuilder.setCreationDate(now);
        userBuilder.setLastUpdate(now);
        userBuilder.setLastConnection(null);
        userBuilder.setUserName(newUser.getUserName());
        userBuilder.setPassword(newUser.getPassword());
        userBuilder.setFirstName(newUser.getFirstName());
        userBuilder.setLastName(newUser.getLastName());
        userBuilder.setIconName(newUser.getIconName());
        userBuilder.setIconPath(newUser.getIconPath());
        userBuilder.setJobTitle(newUser.getJobTitle());
        userBuilder.setTitle(newUser.getTitle());
        userBuilder.setCreatedBy(newUser.getCreatedBy() == 0L ? SessionInfos.getUserIdFromSession() : newUser.getCreatedBy());
        userBuilder.setManagerUserId(newUser.getManagerUserId());
        userBuilder.setEnabled(newUser.isEnabled());
        return userBuilder.done();
    }

    public static SContactInfo constructSUserContactInfo(ExportedUser user, boolean isPersonal, long userId) {
        SContactInfoBuilder contactInfoBuilder = BuilderFactory.get(SContactInfoBuilderFactory.class).createNewInstance(userId, isPersonal);
        if (isPersonal) {
            contactInfoBuilder.setAddress(user.getPersonalAddress());
            contactInfoBuilder.setBuilding(user.getPersonalBuilding());
            contactInfoBuilder.setCity(user.getPersonalCity());
            contactInfoBuilder.setCountry(user.getPersonalCountry());
            contactInfoBuilder.setEmail(user.getPersonalEmail());
            contactInfoBuilder.setFaxNumber(user.getPersonalFaxNumber());
            contactInfoBuilder.setMobileNumber(user.getPersonalMobileNumber());
            contactInfoBuilder.setPhoneNumber(user.getPersonalPhoneNumber());
            contactInfoBuilder.setRoom(user.getPersonalRoom());
            contactInfoBuilder.setState(user.getPersonalState());
            contactInfoBuilder.setWebsite(user.getPersonalWebsite());
            contactInfoBuilder.setZipCode(user.getPersonalZipCode());
        } else {
            contactInfoBuilder.setAddress(user.getProfessionalAddress());
            contactInfoBuilder.setBuilding(user.getProfessionalBuilding());
            contactInfoBuilder.setCity(user.getProfessionalCity());
            contactInfoBuilder.setCountry(user.getProfessionalCountry());
            contactInfoBuilder.setEmail(user.getProfessionalEmail());
            contactInfoBuilder.setFaxNumber(user.getProfessionalFaxNumber());
            contactInfoBuilder.setMobileNumber(user.getProfessionalMobileNumber());
            contactInfoBuilder.setPhoneNumber(user.getProfessionalPhoneNumber());
            contactInfoBuilder.setRoom(user.getProfessionalRoom());
            contactInfoBuilder.setState(user.getProfessionalState());
            contactInfoBuilder.setWebsite(user.getProfessionalWebsite());
            contactInfoBuilder.setZipCode(user.getProfessionalZipCode());
        }
        return contactInfoBuilder.done();
    }

    public static ExportedUser toExportedUser(SUser sUser, SContactInfo persoInfo, SContactInfo proInfo, String managerUserName) {
        ExportedUserBuilder clientUserbuilder = ExportedUserBuilderFactory.createNewInstance(sUser.getUserName(), sUser.getPassword());
        clientUserbuilder.setPasswordEncrypted(true);
        clientUserbuilder.setFirstName(sUser.getFirstName());
        clientUserbuilder.setLastName(sUser.getLastName());
        clientUserbuilder.setTitle(sUser.getTitle());
        clientUserbuilder.setJobTitle(sUser.getJobTitle());
        clientUserbuilder.setCreatedBy(sUser.getCreatedBy());
        clientUserbuilder.setIconName(sUser.getIconName());
        clientUserbuilder.setIconPath(sUser.getIconPath());
        clientUserbuilder.setEnabled(sUser.isEnabled());
        long managerUserId = sUser.getManagerUserId();
        clientUserbuilder.setManagerUserId(managerUserId);
        clientUserbuilder.setManagerUserName(managerUserName);
        if (persoInfo != null) {
            clientUserbuilder.setPersonalData(ModelConvertor.toUserContactData(persoInfo));
        }
        if (proInfo != null) {
            clientUserbuilder.setProfessionalData(ModelConvertor.toUserContactData(proInfo));
        }
        return clientUserbuilder.done();
    }

    public static SRole constructSRole(RoleCreator creator) {
        String iconPath;
        String iconName;
        String description;
        long now = System.currentTimeMillis();
        SRoleBuilder roleBuilder = BuilderFactory.get(SRoleBuilderFactory.class).createNewInstance();
        roleBuilder.setCreatedBy(SessionInfos.getUserIdFromSession());
        roleBuilder.setCreationDate(now).setLastUpdate(now);
        Map fields = creator.getFields();
        roleBuilder.setName((String)fields.get(RoleCreator.RoleField.NAME));
        String displayName = (String)fields.get(RoleCreator.RoleField.DISPLAY_NAME);
        if (displayName != null) {
            roleBuilder.setDisplayName(displayName);
        }
        if ((description = (String)fields.get(RoleCreator.RoleField.DESCRIPTION)) != null) {
            roleBuilder.setDescription(description);
        }
        if ((iconName = (String)fields.get(RoleCreator.RoleField.ICON_NAME)) != null) {
            roleBuilder.setIconName(iconName);
        }
        if ((iconPath = (String)fields.get(RoleCreator.RoleField.ICON_PATH)) != null) {
            roleBuilder.setIconPath(iconPath);
        }
        return roleBuilder.done();
    }

    public static SGroup constructSGroup(GroupCreator creator) {
        String iconPath;
        String iconName;
        String description;
        String displayName;
        long now = System.currentTimeMillis();
        SGroupBuilder groupBuilder = BuilderFactory.get(SGroupBuilderFactory.class).createNewInstance();
        groupBuilder.setCreatedBy(SessionInfos.getUserIdFromSession());
        groupBuilder.setCreationDate(now).setLastUpdate(now);
        Map fields = creator.getFields();
        groupBuilder.setName((String)fields.get(GroupCreator.GroupField.NAME));
        String parentPath = (String)fields.get(GroupCreator.GroupField.PARENT_PATH);
        if (parentPath != null) {
            groupBuilder.setParentPath(parentPath);
        }
        if ((displayName = (String)fields.get(GroupCreator.GroupField.DISPLAY_NAME)) != null) {
            groupBuilder.setDisplayName(displayName);
        }
        if ((description = (String)fields.get(GroupCreator.GroupField.DESCRIPTION)) != null) {
            groupBuilder.setDescription(description);
        }
        if ((iconName = (String)fields.get(GroupCreator.GroupField.ICON_NAME)) != null) {
            groupBuilder.setIconName(iconName);
        }
        if ((iconPath = (String)fields.get(GroupCreator.GroupField.ICON_PATH)) != null) {
            groupBuilder.setIconPath(iconPath);
        }
        return groupBuilder.done();
    }

    public static List<ProcessSupervisor> toProcessSupervisors(List<SProcessSupervisor> sSupervisors) {
        ArrayList<ProcessSupervisor> processSupervisors = new ArrayList<ProcessSupervisor>();
        if (sSupervisors != null) {
            for (SProcessSupervisor sSupervisor : sSupervisors) {
                processSupervisors.add(ModelConvertor.toProcessSupervisor(sSupervisor));
            }
        }
        return processSupervisors;
    }

    public static ProcessSupervisor toProcessSupervisor(SProcessSupervisor sSupervisor) {
        ProcessSupervisorImpl supervisor = new ProcessSupervisorImpl();
        supervisor.setId(sSupervisor.getId());
        supervisor.setProcessDefinitionId(sSupervisor.getProcessDefId());
        supervisor.setUserId(sSupervisor.getUserId());
        supervisor.setGroupId(sSupervisor.getGroupId());
        supervisor.setRoleId(sSupervisor.getRoleId());
        return supervisor;
    }

    public static List<Document> toDocuments(Collection<SProcessDocument> attachments) {
        ArrayList<Document> documents = new ArrayList<Document>();
        for (SProcessDocument sProcessDocument : attachments) {
            Document document = ModelConvertor.toDocument(sProcessDocument);
            documents.add(document);
        }
        return documents;
    }

    public static Document toDocument(SProcessDocument attachment) {
        DocumentImpl documentImpl = new DocumentImpl();
        documentImpl.setId(attachment.getId());
        documentImpl.setProcessInstanceId(attachment.getProcessInstanceId());
        documentImpl.setName(attachment.getName());
        documentImpl.setAuthor(attachment.getAuthor());
        documentImpl.setCreationDate(new Date(attachment.getCreationDate()));
        documentImpl.setHasContent(attachment.hasContent());
        documentImpl.setContentMimeType(attachment.getContentMimeType());
        documentImpl.setFileName(attachment.getContentFileName());
        documentImpl.setContentStorageId(attachment.getContentStorageId());
        documentImpl.setUrl(attachment.getURL());
        return documentImpl;
    }

    public static List<ArchivedDocument> toArchivedDocuments(Collection<SAProcessDocument> attachments) {
        ArrayList<ArchivedDocument> documents = new ArrayList<ArchivedDocument>();
        for (SAProcessDocument sAProcessDocument : attachments) {
            ArchivedDocument document = ModelConvertor.toArchivedDocument(sAProcessDocument);
            documents.add(document);
        }
        return documents;
    }

    public static ArchivedDocument toArchivedDocument(SAProcessDocument attachment) {
        ArchivedDocumentImpl documentImpl = new ArchivedDocumentImpl(attachment.getName());
        documentImpl.setId(attachment.getId());
        documentImpl.setProcessInstanceId(attachment.getProcessInstanceId());
        documentImpl.setArchiveDate(new Date(attachment.getArchiveDate()));
        documentImpl.setContentStorageId(attachment.getContentStorageId());
        documentImpl.setDocumentAuthor(attachment.getAuthor());
        documentImpl.setDocumentContentFileName(attachment.getContentFileName());
        documentImpl.setDocumentContentMimeType(attachment.getContentMimeType());
        documentImpl.setDocumentCreationDate(new Date(attachment.getCreationDate()));
        documentImpl.setDocumentHasContent(attachment.hasContent());
        documentImpl.setDocumentURL(attachment.getURL());
        documentImpl.setSourceObjectId(attachment.getSourceObjectId());
        return documentImpl;
    }

    public static int getServerActivityStateId(String state) {
        int stateId = -1;
        if (state.equalsIgnoreCase("ready")) {
            stateId = 4;
        } else if (state.equalsIgnoreCase("completing")) {
            stateId = 9;
        } else if (state.equalsIgnoreCase("completed")) {
            stateId = 2;
        } else if (state.equalsIgnoreCase("executing")) {
            stateId = 1;
        } else if (state.equalsIgnoreCase("initializing")) {
            stateId = 0;
        } else if (state.equalsIgnoreCase("skipped")) {
            stateId = 12;
        } else if (state.equalsIgnoreCase("cancelling subtasks")) {
            stateId = 13;
        } else if (state.equalsIgnoreCase("cancelled")) {
            stateId = 14;
        }
        return stateId;
    }

    public static ProcessInstanceState getProcessInstanceState(String state) {
        ProcessInstanceState pis = null;
        if (state.equalsIgnoreCase(ProcessInstanceState.ABORTED.toString())) {
            pis = ProcessInstanceState.ABORTED;
        } else if (state.equalsIgnoreCase(ProcessInstanceState.CANCELLED.toString())) {
            pis = ProcessInstanceState.CANCELLED;
        } else if (state.equalsIgnoreCase(ProcessInstanceState.COMPLETED.toString())) {
            pis = ProcessInstanceState.COMPLETED;
        } else if (state.equalsIgnoreCase(ProcessInstanceState.COMPLETING.toString())) {
            pis = ProcessInstanceState.COMPLETING;
        } else if (state.equalsIgnoreCase(ProcessInstanceState.ERROR.toString())) {
            pis = ProcessInstanceState.ERROR;
        } else if (state.equalsIgnoreCase(ProcessInstanceState.INITIALIZING.toString())) {
            pis = ProcessInstanceState.INITIALIZING;
        } else if (state.equalsIgnoreCase(ProcessInstanceState.STARTED.toString())) {
            pis = ProcessInstanceState.STARTED;
        } else if (state.equalsIgnoreCase(ProcessInstanceState.SUSPENDED.toString())) {
            pis = ProcessInstanceState.SUSPENDED;
        }
        return pis;
    }

    public static Comment toComment(SComment sComment) {
        CommentImpl commentImpl = new CommentImpl();
        commentImpl.setTenantId(sComment.getTenantId());
        commentImpl.setId(sComment.getId());
        commentImpl.setUserId(sComment.getUserId());
        commentImpl.setProcessInstanceId(sComment.getProcessInstanceId());
        commentImpl.setPostDate(sComment.getPostDate());
        commentImpl.setContent(sComment.getContent());
        return commentImpl;
    }

    public static List<Comment> toComments(List<SComment> sComments) {
        ArrayList<Comment> comments = new ArrayList<Comment>();
        for (SComment sComment : sComments) {
            comments.add(ModelConvertor.toComment(sComment));
        }
        return comments;
    }

    public static Map<String, SExpression> constructExpressions(Map<String, Expression> inputs) {
        HashMap<String, SExpression> result = new HashMap<String, SExpression>(inputs.size());
        for (Map.Entry<String, Expression> expression : inputs.entrySet()) {
            result.put(expression.getKey(), ModelConvertor.constructSExpression(expression.getValue()));
        }
        return result;
    }

    public static SExpression constructSExpression(Expression model) {
        ArrayList<SExpression> dependencies = new ArrayList<SExpression>();
        for (Expression dep : model.getDependencies()) {
            dependencies.add(ModelConvertor.constructSExpression(dep));
        }
        SExpressionBuilder expressionBuilder = BuilderFactory.get(SExpressionBuilderFactory.class).createNewInstance();
        expressionBuilder.setName(model.getName());
        expressionBuilder.setContent(model.getContent());
        expressionBuilder.setExpressionType(model.getExpressionType());
        expressionBuilder.setInterpreter(model.getInterpreter());
        expressionBuilder.setReturnType(model.getReturnType());
        expressionBuilder.setDependencies(dependencies);
        try {
            return expressionBuilder.done();
        }
        catch (SInvalidExpressionException e) {
            throw new IllegalArgumentException("Error constructing SExpression");
        }
    }

    public static SOperation constructSOperation(Operation operation) {
        SExpression rightOperand = ModelConvertor.constructSExpression(operation.getRightOperand());
        SOperatorType operatorType = SOperatorType.valueOf(operation.getType().name());
        SLeftOperand sLeftOperand = ModelConvertor.constructSLeftOperand(operation.getLeftOperand());
        return BuilderFactory.get(SOperationBuilderFactory.class).createNewInstance().setOperator(operation.getOperator()).setRightOperand(rightOperand).setType(operatorType).setLeftOperand(sLeftOperand).done();
    }

    private static SLeftOperand constructSLeftOperand(LeftOperand variableToSet) {
        return BuilderFactory.get(SLeftOperandBuilderFactory.class).createNewInstance().setName(variableToSet.getName()).setExternal(variableToSet.isExternal()).done();
    }

    public static List<ConnectorImplementationDescriptor> toConnectorImplementationDescriptors(List<SConnectorImplementationDescriptor> sConnectorImplementationDescriptors) {
        if (sConnectorImplementationDescriptors != null) {
            ArrayList<ConnectorImplementationDescriptor> connectorImplementationDescriptors = new ArrayList<ConnectorImplementationDescriptor>(sConnectorImplementationDescriptors.size());
            for (SConnectorImplementationDescriptor sConnectorImplementationDescriptor : sConnectorImplementationDescriptors) {
                connectorImplementationDescriptors.add(ModelConvertor.toConnectorImplementationDescriptor(sConnectorImplementationDescriptor));
            }
            return connectorImplementationDescriptors;
        }
        return Collections.emptyList();
    }

    public static ConnectorImplementationDescriptor toConnectorImplementationDescriptor(SConnectorImplementationDescriptor sConnectorImplementationDescriptor) {
        return new ConnectorImplementationDescriptor(sConnectorImplementationDescriptor.getImplementationClassName(), sConnectorImplementationDescriptor.getId(), sConnectorImplementationDescriptor.getVersion(), sConnectorImplementationDescriptor.getDefinitionId(), sConnectorImplementationDescriptor.getDefinitionVersion(), sConnectorImplementationDescriptor.getJarDependencies().getDependencies());
    }

    public static List<ArchivedComment> toArchivedComments(List<SAComment> serverObjects) {
        ArrayList<ArchivedComment> commments = new ArrayList<ArchivedComment>();
        for (SAComment saComment : serverObjects) {
            ArchivedComment comment = ModelConvertor.toArchivedComment(saComment);
            commments.add(comment);
        }
        return commments;
    }

    public static ArchivedComment toArchivedComment(SAComment saComment) {
        ArchivedCommentImpl commentImpl = new ArchivedCommentImpl(saComment.getContent());
        commentImpl.setId(saComment.getId());
        commentImpl.setProcessInstanceId(saComment.getProcessInstanceId());
        commentImpl.setArchiveDate(new Date(saComment.getArchiveDate()));
        commentImpl.setContent(saComment.getContent());
        commentImpl.setSourceObjectId(saComment.getSourceObjectId());
        commentImpl.setUserId(saComment.getUserId());
        commentImpl.setPostDate(new Date(saComment.getPostDate()));
        return commentImpl;
    }

    public static Operation toOperation(SOperation operation) {
        OperationImpl operationImpl = new OperationImpl();
        operationImpl.setRightOperand(ModelConvertor.toExpression(operation.getRightOperand()));
        operationImpl.setOperator(operation.getOperator());
        operationImpl.setType(ModelConvertor.toOperatorType(operation.getType()));
        LeftOperandImpl variableToSet = new LeftOperandImpl();
        SLeftOperand variableToSet2 = operation.getLeftOperand();
        variableToSet.setName(variableToSet2.getName());
        variableToSet.setExternal(variableToSet2.isExternal());
        operationImpl.setLeftOperand((LeftOperand)variableToSet);
        return operationImpl;
    }

    private static OperatorType toOperatorType(SOperatorType type) {
        OperatorType operatorType = null;
        if (SOperatorType.ASSIGNMENT.equals((Object)type)) {
            operatorType = OperatorType.ASSIGNMENT;
        } else if (SOperatorType.JAVA_METHOD.equals((Object)type)) {
            operatorType = OperatorType.JAVA_METHOD;
        } else if (SOperatorType.XPATH_UPDATE_QUERY.equals((Object)type)) {
            operatorType = OperatorType.XPATH_UPDATE_QUERY;
        }
        return operatorType;
    }

    public static ConnectorDefinition toConnectorDefinition(SConnectorDefinition connector) {
        ConnectorDefinitionImpl connectorDefinitionImpl = new ConnectorDefinitionImpl(connector.getName(), connector.getConnectorId(), connector.getVersion(), connector.getActivationEvent());
        for (Map.Entry<String, SExpression> input : connector.getInputs().entrySet()) {
            connectorDefinitionImpl.addInput(input.getKey(), ModelConvertor.toExpression(input.getValue()));
        }
        for (SOperation operation : connector.getOutputs()) {
            connectorDefinitionImpl.addOutput(ModelConvertor.toOperation(operation));
        }
        return connectorDefinitionImpl;
    }

    public static List<ActorInstance> toActors(List<SActor> sActors) {
        ArrayList<ActorInstance> actors = new ArrayList<ActorInstance>();
        for (SActor sActor : sActors) {
            ActorInstance actor = ModelConvertor.toActorInstance(sActor);
            actors.add(actor);
        }
        return actors;
    }

    public static List<ArchivedFlowElementInstance> toArchivedFlowElementInstances(List<SAFlowElementInstance> serverObjects) {
        return null;
    }

    public static List<ArchivedFlowNodeInstance> toArchivedFlowNodeInstances(List<SAFlowNodeInstance> saFlowNodes, FlowNodeStateManager flowNodeStateManager) {
        ArrayList<ArchivedFlowNodeInstance> flowNodeInstances = new ArrayList<ArchivedFlowNodeInstance>();
        for (SAFlowNodeInstance saFlowNode : saFlowNodes) {
            ArchivedFlowNodeInstance flowNodeInstance = ModelConvertor.toArchivedFlowNodeInstance(saFlowNode, flowNodeStateManager);
            flowNodeInstances.add(flowNodeInstance);
        }
        return flowNodeInstances;
    }

    public static ArchivedFlowNodeInstance toArchivedFlowNodeInstance(SAFlowNodeInstance saFlowNode, FlowNodeStateManager flowNodeStateManager) {
        ArchivedAutomaticTaskInstance archiveFlowNodeInstance = null;
        switch (saFlowNode.getType()) {
            case AUTOMATIC_TASK: {
                archiveFlowNodeInstance = ModelConvertor.toArchivedAutomaticTaskInstance((SAAutomaticTaskInstance)saFlowNode, flowNodeStateManager);
                break;
            }
            case MANUAL_TASK: {
                archiveFlowNodeInstance = ModelConvertor.toArchivedManualTaskInstance((SAManualTaskInstance)saFlowNode, flowNodeStateManager);
                break;
            }
            case USER_TASK: {
                archiveFlowNodeInstance = ModelConvertor.toArchivedUserTaskInstance((SAUserTaskInstance)saFlowNode, flowNodeStateManager);
                break;
            }
            case RECEIVE_TASK: {
                archiveFlowNodeInstance = ModelConvertor.toArchivedReceiveTaskInstance((SAReceiveTaskInstance)saFlowNode, flowNodeStateManager);
                break;
            }
            case SEND_TASK: {
                archiveFlowNodeInstance = ModelConvertor.toArchivedSendTaskInstance((SASendTaskInstance)saFlowNode, flowNodeStateManager);
                break;
            }
            case CALL_ACTIVITY: {
                archiveFlowNodeInstance = ModelConvertor.toArchivedCallActivityInstance((SACallActivityInstance)saFlowNode, flowNodeStateManager);
                break;
            }
            case LOOP_ACTIVITY: {
                archiveFlowNodeInstance = ModelConvertor.toArchivedLoopActivityInstance((SALoopActivityInstance)saFlowNode, flowNodeStateManager);
                break;
            }
            case SUB_PROCESS: {
                archiveFlowNodeInstance = ModelConvertor.toArchivedSubProcessActivityInstance((SASubProcessActivityInstance)saFlowNode, flowNodeStateManager);
                break;
            }
            case GATEWAY: {
                archiveFlowNodeInstance = ModelConvertor.toArchivedGatewayInstance((SAGatewayInstance)saFlowNode, flowNodeStateManager);
                break;
            }
            case MULTI_INSTANCE_ACTIVITY: {
                archiveFlowNodeInstance = ModelConvertor.toArchivedMultiInstanceActivityInstance((SAMultiInstanceActivityInstance)saFlowNode, flowNodeStateManager);
                break;
            }
            case START_EVENT: 
            case INTERMEDIATE_CATCH_EVENT: 
            case BOUNDARY_EVENT: 
            case INTERMEDIATE_THROW_EVENT: 
            case END_EVENT: {
                break;
            }
            default: {
                throw new UnknownElementType(saFlowNode.getType().name());
            }
        }
        return archiveFlowNodeInstance;
    }

    public static List<ConnectorInstance> toConnectorInstances(List<SConnectorInstance> sConnectorInstances) {
        ArrayList<ConnectorInstance> connectorInstances = new ArrayList<ConnectorInstance>(sConnectorInstances.size());
        for (SConnectorInstance sConnectorInstance : sConnectorInstances) {
            connectorInstances.add(ModelConvertor.toConnectorInstance(sConnectorInstance));
        }
        return connectorInstances;
    }

    private static ConnectorInstance toConnectorInstance(SConnectorInstance sConnectorInstance) {
        ConnectorInstanceImpl connectorInstanceImpl = new ConnectorInstanceImpl(sConnectorInstance.getName(), sConnectorInstance.getContainerId(), sConnectorInstance.getContainerType(), sConnectorInstance.getConnectorId(), sConnectorInstance.getVersion(), ConnectorState.valueOf((String)sConnectorInstance.getState()), sConnectorInstance.getActivationEvent());
        connectorInstanceImpl.setId(sConnectorInstance.getId());
        return connectorInstanceImpl;
    }

    public static ConnectorInstanceWithFailureInfo toConnectorInstanceWithFailureInfo(SConnectorInstanceWithFailureInfo sConnectorInstanceWithFailureInfo) {
        ConnectorInstanceWithFailureInfoImpl connectorInstanceImpl = new ConnectorInstanceWithFailureInfoImpl(sConnectorInstanceWithFailureInfo.getName(), sConnectorInstanceWithFailureInfo.getContainerId(), sConnectorInstanceWithFailureInfo.getContainerType(), sConnectorInstanceWithFailureInfo.getConnectorId(), sConnectorInstanceWithFailureInfo.getVersion(), ConnectorState.valueOf((String)sConnectorInstanceWithFailureInfo.getState()), sConnectorInstanceWithFailureInfo.getActivationEvent(), sConnectorInstanceWithFailureInfo.getExceptionMessage(), sConnectorInstanceWithFailureInfo.getStackTrace());
        connectorInstanceImpl.setId(sConnectorInstanceWithFailureInfo.getId());
        return connectorInstanceImpl;
    }

    public static ArchivedConnectorInstance toArchivedConnectorInstance(SAConnectorInstance sAConnectorInstance) {
        ArchivedConnectorInstanceImpl connectorInstanceImpl = new ArchivedConnectorInstanceImpl(sAConnectorInstance.getName(), new Date(sAConnectorInstance.getArchiveDate()), sAConnectorInstance.getContainerId(), sAConnectorInstance.getContainerType(), sAConnectorInstance.getConnectorId(), sAConnectorInstance.getVersion(), sAConnectorInstance.getActivationEvent(), ConnectorState.valueOf((String)sAConnectorInstance.getState()), sAConnectorInstance.getSourceObjectId());
        connectorInstanceImpl.setId(sAConnectorInstance.getId());
        return connectorInstanceImpl;
    }

    public static List<ArchivedConnectorInstance> toArchivedConnectorInstances(List<SAConnectorInstance> serverObjects) {
        ArrayList<ArchivedConnectorInstance> commments = new ArrayList<ArchivedConnectorInstance>();
        for (SAConnectorInstance saConnectorInstance : serverObjects) {
            ArchivedConnectorInstance archivedConnectorInstance = ModelConvertor.toArchivedConnectorInstance(saConnectorInstance);
            commments.add(archivedConnectorInstance);
        }
        return commments;
    }

    public static List<Profile> toProfiles(List<SProfile> sProfiles) {
        ArrayList<Profile> profiles = new ArrayList<Profile>(sProfiles.size());
        for (SProfile sProfile : sProfiles) {
            Profile profile = ModelConvertor.toProfile(sProfile);
            profiles.add(profile);
        }
        return profiles;
    }

    public static Profile toProfile(SProfile sProfile) {
        ProfileImpl profileImpl = new ProfileImpl(sProfile.getName());
        profileImpl.setId(sProfile.getId());
        profileImpl.setDefault(sProfile.isDefault());
        profileImpl.setDescription(sProfile.getDescription());
        profileImpl.setIconPath(sProfile.getIconPath());
        profileImpl.setCreationDate(new Date(sProfile.getCreationDate()));
        profileImpl.setCreatedBy(sProfile.getCreatedBy());
        profileImpl.setLastUpdateDate(new Date(sProfile.getLastUpdateDate()));
        profileImpl.setLastUpdatedBy(sProfile.getLastUpdatedBy());
        return profileImpl;
    }

    public static List<ProfileEntry> toProfileEntries(List<SProfileEntry> sProfileEntries) {
        ArrayList<ProfileEntry> profiles = new ArrayList<ProfileEntry>(sProfileEntries.size());
        for (SProfileEntry sProfileEntry : sProfileEntries) {
            ProfileEntry profile = ModelConvertor.toProfileEntry(sProfileEntry);
            profiles.add(profile);
        }
        return profiles;
    }

    public static ProfileEntry toProfileEntry(SProfileEntry sProfileEntry) {
        ProfileEntryImpl profileEntryImpl = new ProfileEntryImpl(sProfileEntry.getName(), sProfileEntry.getProfileId());
        profileEntryImpl.setId(sProfileEntry.getId());
        profileEntryImpl.setDescription(sProfileEntry.getDescription());
        profileEntryImpl.setIndex(sProfileEntry.getIndex());
        profileEntryImpl.setPage(sProfileEntry.getPage());
        profileEntryImpl.setParentId(sProfileEntry.getParentId());
        profileEntryImpl.setType(sProfileEntry.getType());
        return profileEntryImpl;
    }

    public static List<ProfileMember> toProfileMembers(List<SProfileMember> sProfileMembers) {
        ArrayList<ProfileMember> profiles = new ArrayList<ProfileMember>(sProfileMembers.size());
        for (SProfileMember sProfileMember : sProfileMembers) {
            ProfileMember profile = ModelConvertor.toProfileMember(sProfileMember);
            profiles.add(profile);
        }
        return profiles;
    }

    public static ProfileMember toProfileMember(SProfileMember sProfileMember) {
        ProfileMemberImpl profileMemberImpl = new ProfileMemberImpl();
        profileMemberImpl.setId(sProfileMember.getId());
        profileMemberImpl.setDisplayNamePart1(sProfileMember.getDisplayNamePart1());
        profileMemberImpl.setDisplayNamePart2(sProfileMember.getDisplayNamePart2());
        profileMemberImpl.setDisplayNamePart3(sProfileMember.getDisplayNamePart3());
        profileMemberImpl.setGroupId(sProfileMember.getGroupId());
        profileMemberImpl.setProfileId(sProfileMember.getProfileId());
        profileMemberImpl.setRoleId(sProfileMember.getRoleId());
        profileMemberImpl.setUserId(sProfileMember.getUserId());
        return profileMemberImpl;
    }

    public static SProfileMember constructSProfileMember(ProfileMemberCreator creator) {
        Long userId;
        Long roleId;
        Map fields = creator.getFields();
        SProfileMemberBuilder newSProfileMemberBuilder = BuilderFactory.get(SProfileMemberBuilderFactory.class).createNewInstance((Long)fields.get(ProfileMemberCreator.ProfileMemberField.PROFILE_ID));
        Long groupeId = (Long)fields.get(ProfileMemberCreator.ProfileMemberField.GROUP_ID);
        if (groupeId != null) {
            newSProfileMemberBuilder.setGroupId(groupeId);
        }
        if ((roleId = (Long)fields.get(ProfileMemberCreator.ProfileMemberField.ROLE_ID)) != null) {
            newSProfileMemberBuilder.setRoleId(roleId);
        }
        if ((userId = (Long)fields.get(ProfileMemberCreator.ProfileMemberField.USER_ID)) != null) {
            newSProfileMemberBuilder.setUserId(userId);
        }
        return newSProfileMemberBuilder.done();
    }

    public static List<FailedJob> toFailedJobs(List<SFailedJob> sFailedJobs) {
        ArrayList<FailedJob> failedJobs = new ArrayList<FailedJob>(sFailedJobs.size());
        for (SFailedJob sFailedJob : sFailedJobs) {
            failedJobs.add(ModelConvertor.toFailedJob(sFailedJob));
        }
        return failedJobs;
    }

    public static FailedJob toFailedJob(SFailedJob sFailedJob) {
        FailedJobImpl failedJob = new FailedJobImpl(sFailedJob.getJobDescriptorId(), sFailedJob.getJobName());
        failedJob.setDescription(sFailedJob.getDescription());
        failedJob.setLastMessage(sFailedJob.getLastMessage());
        failedJob.setRetryNumber(sFailedJob.getRetryNumber());
        failedJob.setLastUpdateDate(new Date(sFailedJob.getLastUpdateDate()));
        return failedJob;
    }

    public static List<Theme> toThemes(List<STheme> sThemes) {
        ArrayList<Theme> themes = new ArrayList<Theme>(sThemes.size());
        for (STheme sTheme : sThemes) {
            Theme theme = ModelConvertor.toTheme(sTheme);
            themes.add(theme);
        }
        return themes;
    }

    public static Theme toTheme(STheme sTheme) {
        ThemeType type = ThemeType.valueOf((String)sTheme.getType().name());
        Date lastUpdateDate = new Date(sTheme.getLastUpdateDate());
        ThemeImpl themeImpl = new ThemeImpl(sTheme.getContent(), sTheme.getCssContent(), sTheme.isDefault(), type, lastUpdateDate);
        return themeImpl;
    }

    public static List<SOperation> toSOperation(List<Operation> operations) {
        if (operations == null) {
            return null;
        }
        if (operations.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<SOperation> sOperations = new ArrayList<SOperation>(operations.size());
        for (Operation operation : operations) {
            SOperation sOperation = ModelConvertor.toSOperation(operation);
            sOperations.add(sOperation);
        }
        return sOperations;
    }

    public static SOperation toSOperation(Operation operation) {
        SExpression rightOperand = ModelConvertor.constructSExpression(operation.getRightOperand());
        SOperatorType operatorType = SOperatorType.valueOf(operation.getType().name());
        SLeftOperand sLeftOperand = ModelConvertor.toSLeftOperand(operation.getLeftOperand());
        return BuilderFactory.get(SOperationBuilderFactory.class).createNewInstance().setOperator(operation.getOperator()).setRightOperand(rightOperand).setType(operatorType).setLeftOperand(sLeftOperand).done();
    }

    private static SLeftOperand toSLeftOperand(LeftOperand variableToSet) {
        return BuilderFactory.get(SLeftOperandBuilderFactory.class).createNewInstance().setName(variableToSet.getName()).done();
    }
}

