/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.supervisor.mapping.impl;

import java.util.List;
import org.bonitasoft.engine.builder.BuilderFactory;
import org.bonitasoft.engine.events.EventActionType;
import org.bonitasoft.engine.events.EventService;
import org.bonitasoft.engine.events.model.SDeleteEvent;
import org.bonitasoft.engine.events.model.SInsertEvent;
import org.bonitasoft.engine.events.model.builders.SEventBuilderFactory;
import org.bonitasoft.engine.persistence.QueryOptions;
import org.bonitasoft.engine.persistence.ReadPersistenceService;
import org.bonitasoft.engine.persistence.SBonitaReadException;
import org.bonitasoft.engine.persistence.SBonitaSearchException;
import org.bonitasoft.engine.persistence.SelectByIdDescriptor;
import org.bonitasoft.engine.persistence.SelectOneDescriptor;
import org.bonitasoft.engine.queriablelogger.model.SQueriableLog;
import org.bonitasoft.engine.queriablelogger.model.SQueriableLogSeverity;
import org.bonitasoft.engine.queriablelogger.model.builder.ActionType;
import org.bonitasoft.engine.queriablelogger.model.builder.HasCRUDEAction;
import org.bonitasoft.engine.queriablelogger.model.builder.SLogBuilder;
import org.bonitasoft.engine.queriablelogger.model.builder.SPersistenceLogBuilder;
import org.bonitasoft.engine.recorder.Recorder;
import org.bonitasoft.engine.recorder.SRecorderException;
import org.bonitasoft.engine.recorder.model.DeleteAllRecord;
import org.bonitasoft.engine.recorder.model.DeleteRecord;
import org.bonitasoft.engine.recorder.model.InsertRecord;
import org.bonitasoft.engine.services.QueriableLoggerService;
import org.bonitasoft.engine.supervisor.mapping.SSupervisorCreationException;
import org.bonitasoft.engine.supervisor.mapping.SSupervisorDeletionException;
import org.bonitasoft.engine.supervisor.mapping.SSupervisorNotFoundException;
import org.bonitasoft.engine.supervisor.mapping.SupervisorMappingService;
import org.bonitasoft.engine.supervisor.mapping.impl.SelectDescriptorBuilder;
import org.bonitasoft.engine.supervisor.mapping.model.SProcessSupervisor;
import org.bonitasoft.engine.supervisor.mapping.model.SProcessSupervisorLogBuilder;
import org.bonitasoft.engine.supervisor.mapping.model.SProcessSupervisorLogBuilderFactory;

public class SupervisorMappingServiceImpl
implements SupervisorMappingService {
    private final ReadPersistenceService persistenceService;
    private final Recorder recorder;
    private final EventService eventService;
    private final QueriableLoggerService queriableLoggerService;

    public SupervisorMappingServiceImpl(ReadPersistenceService persistenceService, Recorder recorder, EventService eventService, QueriableLoggerService queriableLoggerService) {
        this.persistenceService = persistenceService;
        this.recorder = recorder;
        this.eventService = eventService;
        this.queriableLoggerService = queriableLoggerService;
    }

    @Override
    public SProcessSupervisor createSupervisor(SProcessSupervisor supervisor) throws SSupervisorCreationException {
        SProcessSupervisorLogBuilder logBuilder = this.getQueriableLog(ActionType.CREATED, "Adding a new supervisor");
        InsertRecord insertRecord = new InsertRecord(supervisor);
        SInsertEvent insertEvent = null;
        if (this.eventService.hasHandlers("SUPERVISOR", EventActionType.CREATED)) {
            insertEvent = (SInsertEvent)BuilderFactory.get(SEventBuilderFactory.class).createInsertEvent("SUPERVISOR").setObject(supervisor).done();
        }
        try {
            this.recorder.recordInsert(insertRecord, insertEvent);
            this.initiateLogBuilder(supervisor.getId(), 1, logBuilder, "createSupervisor");
            return supervisor;
        }
        catch (SRecorderException re) {
            this.initiateLogBuilder(supervisor.getId(), 0, logBuilder, "createSupervisor");
            throw new SSupervisorCreationException(re);
        }
    }

    @Override
    public SProcessSupervisor getSupervisor(long supervisorId) throws SSupervisorNotFoundException {
        SelectByIdDescriptor<SProcessSupervisor> selectByIdDescriptor = SelectDescriptorBuilder.getSupervisor(supervisorId);
        try {
            SProcessSupervisor supervisor = this.persistenceService.selectById(selectByIdDescriptor);
            if (supervisor == null) {
                throw new SSupervisorNotFoundException(supervisorId + " does not refer to any supervisor");
            }
            return supervisor;
        }
        catch (SBonitaReadException bre) {
            throw new SSupervisorNotFoundException(bre);
        }
    }

    @Override
    public void deleteSupervisor(long supervisorId) throws SSupervisorNotFoundException, SSupervisorDeletionException {
        SProcessSupervisor sSupervisor = this.getSupervisor(supervisorId);
        this.deleteSupervisor(sSupervisor);
    }

    @Override
    public void deleteSupervisor(SProcessSupervisor supervisor) throws SSupervisorDeletionException {
        SDeleteEvent deleteEvent = null;
        if (this.eventService.hasHandlers("SUPERVISOR", EventActionType.DELETED)) {
            deleteEvent = (SDeleteEvent)BuilderFactory.get(SEventBuilderFactory.class).createDeleteEvent("SUPERVISOR").setObject(supervisor).done();
        }
        DeleteRecord record = new DeleteRecord(supervisor);
        SProcessSupervisorLogBuilder logBuilder = this.getQueriableLog(ActionType.DELETED, "deleting supervisor");
        try {
            this.recorder.recordDelete(record, deleteEvent);
            this.initiateLogBuilder(supervisor.getId(), 1, logBuilder, "createSupervisor");
        }
        catch (SRecorderException e) {
            this.initiateLogBuilder(supervisor.getId(), 0, logBuilder, "createSupervisor");
            throw new SSupervisorDeletionException("Can't delete process supervisor " + supervisor, e);
        }
    }

    @Override
    public void deleteAllSupervisors() throws SSupervisorDeletionException {
        try {
            DeleteAllRecord record = new DeleteAllRecord(SProcessSupervisor.class, null);
            this.recorder.recordDeleteAll(record);
        }
        catch (SRecorderException e) {
            throw new SSupervisorDeletionException("Can't delete all process supervisors.", e);
        }
    }

    private SProcessSupervisorLogBuilder getQueriableLog(ActionType actionType, String message) {
        SProcessSupervisorLogBuilder logBuilder = BuilderFactory.get(SProcessSupervisorLogBuilderFactory.class).createNewInstance();
        this.initializeLogBuilder(logBuilder, message);
        this.updateLog(actionType, logBuilder);
        return logBuilder;
    }

    private <T extends SLogBuilder> void initializeLogBuilder(T logBuilder, String message) {
        logBuilder.actionStatus(0).severity(SQueriableLogSeverity.INTERNAL).rawMessage(message);
    }

    private <T extends HasCRUDEAction> void updateLog(ActionType actionType, T logBuilder) {
        logBuilder.setActionType(actionType);
    }

    @Override
    public Boolean isProcessSupervisor(long processDefinitionId, long userId) throws SBonitaReadException {
        SelectOneDescriptor<SProcessSupervisor> descriptor = SelectDescriptorBuilder.getSupervisor(processDefinitionId, userId);
        SProcessSupervisor supervisor = this.persistenceService.selectOne(descriptor);
        return supervisor != null;
    }

    @Override
    public List<SProcessSupervisor> searchProcessDefSupervisors(QueryOptions queryOptions) throws SBonitaSearchException {
        try {
            return this.persistenceService.searchEntity(SProcessSupervisor.class, null, queryOptions, null);
        }
        catch (SBonitaReadException bre) {
            throw new SBonitaSearchException(bre);
        }
    }

    @Override
    public long getNumberOfProcessDefSupervisors(QueryOptions searchOptions) throws SBonitaSearchException {
        try {
            return this.persistenceService.getNumberOfEntities(SProcessSupervisor.class, null, searchOptions, null);
        }
        catch (SBonitaReadException bre) {
            throw new SBonitaSearchException(bre);
        }
    }

    private void initiateLogBuilder(long objectId, int sQueriableLogStatus, SPersistenceLogBuilder logBuilder, String callerMethodName) {
        logBuilder.actionScope(String.valueOf(objectId));
        logBuilder.actionStatus(sQueriableLogStatus);
        logBuilder.objectId(objectId);
        SQueriableLog log = logBuilder.done();
        if (this.queriableLoggerService.isLoggable(log.getActionType(), log.getSeverity())) {
            this.queriableLoggerService.log(this.getClass().getName(), callerMethodName, log);
        }
    }
}

