/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.transaction;

import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicLong;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.bonitasoft.engine.log.technical.TechnicalLogSeverity;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;
import org.bonitasoft.engine.transaction.BonitaTransactionManagerLookup;
import org.bonitasoft.engine.transaction.BonitaTransactionSynchronization;
import org.bonitasoft.engine.transaction.JTATransactionWrapper;
import org.bonitasoft.engine.transaction.STransactionCommitException;
import org.bonitasoft.engine.transaction.STransactionCreationException;
import org.bonitasoft.engine.transaction.STransactionException;
import org.bonitasoft.engine.transaction.STransactionNotFoundException;
import org.bonitasoft.engine.transaction.STransactionRollbackException;
import org.bonitasoft.engine.transaction.TransactionService;
import org.bonitasoft.engine.transaction.TransactionState;

public class JTATransactionServiceImpl
implements TransactionService {
    protected final TechnicalLoggerService logger;
    private final TransactionManager txManager;
    private final AtomicLong numberOfActiveTransactions = new AtomicLong(0L);
    private final TransactionServiceContextThreadLocal txContextThreadLocal;

    public JTATransactionServiceImpl(TechnicalLoggerService logger, BonitaTransactionManagerLookup txManagerLookup) {
        this(logger, txManagerLookup.getTransactionManager());
    }

    public JTATransactionServiceImpl(TechnicalLoggerService logger, TransactionManager txManager) {
        this.logger = logger;
        if (txManager == null) {
            throw new IllegalArgumentException("The parameter txManager can't be null.");
        }
        this.txManager = txManager;
        this.txContextThreadLocal = new TransactionServiceContextThreadLocal(txManager);
    }

    @Override
    public void begin() throws STransactionCreationException {
        block12: {
            try {
                Transaction tx;
                TransactionServiceContext txContext = (TransactionServiceContext)this.txContextThreadLocal.get();
                if (txContext.reentrantCounter() == 1L) {
                    throw new STransactionCreationException("We do not support nested calls to the transaction service.");
                }
                txContext.incrementReentrantCounter();
                if (!txContext.isAlreadyManaged()) {
                    boolean transactionStarted = false;
                    try {
                        this.txManager.begin();
                        transactionStarted = true;
                        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                            Transaction tx2 = this.txManager.getTransaction();
                            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, "Beginning transaction in thread " + Thread.currentThread().getId() + " " + tx2.toString());
                        }
                        this.numberOfActiveTransactions.getAndIncrement();
                    }
                    catch (NotSupportedException e) {
                        throw new STransactionCreationException(e);
                    }
                    catch (Throwable t) {
                        if (transactionStarted) {
                            this.txManager.rollback();
                        }
                        throw new STransactionCreationException(t);
                    }
                }
                if ((tx = this.txManager.getTransaction()) == null) break block12;
                try {
                    tx.registerSynchronization((Synchronization)new ResetCounterSynchronization(this));
                    tx.registerSynchronization((Synchronization)new DecrementNumberOfActiveTransactionsSynchronization(this));
                }
                catch (IllegalStateException e) {
                    throw new STransactionCreationException(e);
                }
                catch (RollbackException e) {
                    throw new STransactionCreationException(e);
                }
            }
            catch (SystemException e) {
                throw new STransactionCreationException(e);
            }
        }
    }

    @Override
    public void complete() throws STransactionCommitException, STransactionRollbackException {
        block16: {
            try {
                int status;
                Transaction tx = this.txManager.getTransaction();
                if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                    this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, "Completing transaction in thread " + Thread.currentThread().getId() + " " + tx.toString());
                }
                if ((status = this.txManager.getStatus()) == 6) {
                    throw new RuntimeException("No transaction started.");
                }
                TransactionServiceContext txContext = (TransactionServiceContext)this.txContextThreadLocal.get();
                if (txContext.isAlreadyManaged()) {
                    txContext.decrementReentrantCounter();
                    return;
                }
                if (status == 1) {
                    try {
                        this.txManager.rollback();
                        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, "Rollbacking transaction in thread " + Thread.currentThread().getId() + " " + tx.toString());
                        }
                        break block16;
                    }
                    catch (IllegalStateException e) {
                        throw new STransactionRollbackException("", e);
                    }
                    catch (SecurityException e) {
                        throw new STransactionRollbackException("", e);
                    }
                }
                try {
                    this.txManager.commit();
                }
                catch (SecurityException e) {
                    throw new STransactionCommitException("", e);
                }
                catch (IllegalStateException e) {
                    throw new STransactionCommitException("", e);
                }
                catch (RollbackException e) {
                    throw new STransactionCommitException("", e);
                }
                catch (HeuristicMixedException e) {
                    throw new STransactionCommitException("", e);
                }
                catch (HeuristicRollbackException e) {
                    throw new STransactionCommitException("", e);
                }
            }
            catch (SystemException e) {
                throw new STransactionCommitException("", e);
            }
        }
    }

    @Override
    public TransactionState getState() throws STransactionException {
        try {
            int status = this.txManager.getStatus();
            switch (status) {
                case 0: {
                    return TransactionState.ACTIVE;
                }
                case 3: {
                    return TransactionState.COMMITTED;
                }
                case 1: {
                    return TransactionState.ROLLBACKONLY;
                }
                case 4: {
                    return TransactionState.ROLLEDBACK;
                }
                case 6: {
                    return TransactionState.NO_TRANSACTION;
                }
            }
            throw new STransactionException("Can't map the JTA status : " + status);
        }
        catch (SystemException e) {
            throw new STransactionException("", e);
        }
    }

    @Override
    public boolean isTransactionActive() throws STransactionException {
        try {
            return this.txManager.getStatus() == 0;
        }
        catch (SystemException e) {
            throw new STransactionException("", e);
        }
    }

    @Override
    public void setRollbackOnly() throws STransactionException {
        try {
            this.txManager.setRollbackOnly();
        }
        catch (IllegalStateException e) {
            throw new STransactionException("", e);
        }
        catch (SystemException e) {
            throw new STransactionException("", e);
        }
    }

    @Override
    public boolean isRollbackOnly() throws STransactionException {
        try {
            return this.txManager.getStatus() == 1;
        }
        catch (SystemException e) {
            throw new STransactionException("Error while trying to get the transaction's status.", e);
        }
    }

    @Override
    public void registerBonitaSynchronization(BonitaTransactionSynchronization txSync) throws STransactionNotFoundException {
        try {
            Transaction transaction = this.txManager.getTransaction();
            if (transaction == null) {
                throw new STransactionNotFoundException("No active transaction");
            }
            transaction.registerSynchronization((Synchronization)new JTATransactionWrapper(txSync));
        }
        catch (IllegalStateException e) {
            throw new STransactionNotFoundException(e.getMessage());
        }
        catch (RollbackException e) {
            throw new STransactionNotFoundException(e.getMessage());
        }
        catch (SystemException e) {
            throw new STransactionNotFoundException(e.getMessage());
        }
    }

    @Override
    public <T> T executeInTransaction(Callable<T> callable) throws Exception {
        this.begin();
        try {
            T t = callable.call();
            return t;
        }
        catch (Exception e) {
            this.setRollbackOnly();
            throw e;
        }
        catch (Throwable t) {
            this.setRollbackOnly();
            throw new RuntimeException(t);
        }
        finally {
            this.complete();
        }
    }

    @Override
    public long getNumberOfActiveTransactions() {
        return this.numberOfActiveTransactions.get();
    }

    private static class TransactionServiceContextThreadLocal
    extends ThreadLocal<TransactionServiceContext> {
        private final TransactionManager txManager;

        public TransactionServiceContextThreadLocal(TransactionManager txManager) {
            this.txManager = txManager;
        }

        @Override
        protected TransactionServiceContext initialValue() {
            try {
                return new TransactionServiceContext(this.txManager.getStatus() == 0);
            }
            catch (SystemException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class TransactionServiceContext {
        private final AtomicLong reentrantCounter = new AtomicLong();
        private final boolean boundaryManagedOutside;

        public TransactionServiceContext(boolean boundaryManagedOutside) {
            this.boundaryManagedOutside = boundaryManagedOutside;
        }

        public long incrementReentrantCounter() {
            return this.reentrantCounter.getAndIncrement();
        }

        public long decrementReentrantCounter() {
            return this.reentrantCounter.getAndDecrement();
        }

        public long reentrantCounter() {
            return this.reentrantCounter.get();
        }

        public boolean isAlreadyManaged() {
            return this.boundaryManagedOutside;
        }
    }

    private static class DecrementNumberOfActiveTransactionsSynchronization
    implements Synchronization {
        private final JTATransactionServiceImpl txService;

        public DecrementNumberOfActiveTransactionsSynchronization(JTATransactionServiceImpl txService) {
            this.txService = txService;
        }

        public void beforeCompletion() {
        }

        public void afterCompletion(int status) {
            this.txService.numberOfActiveTransactions.getAndDecrement();
        }
    }

    private static class ResetCounterSynchronization
    implements Synchronization {
        private final JTATransactionServiceImpl txService;

        public ResetCounterSynchronization(JTATransactionServiceImpl txService) {
            this.txService = txService;
        }

        public void beforeCompletion() {
        }

        public void afterCompletion(int status) {
            this.txService.txContextThreadLocal.remove();
        }
    }
}

