/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.api.impl.transaction.activity;

import java.util.List;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.commons.transaction.TransactionContentWithResult;
import org.bonitasoft.engine.core.process.instance.api.ActivityInstanceService;
import org.bonitasoft.engine.core.process.instance.model.archive.SAActivityInstance;
import org.bonitasoft.engine.persistence.OrderByType;
import org.bonitasoft.engine.persistence.QueryOptions;

public class GetArchivedActivityInstances
implements TransactionContentWithResult<List<SAActivityInstance>> {
    private final ActivityInstanceService activityInstanceService;
    private final long processInstanceId;
    private final int pageIndex;
    private final int numberPerPage;
    private final String field;
    private final OrderByType order;
    private List<SAActivityInstance> archivedActivityInstances;

    public GetArchivedActivityInstances(ActivityInstanceService activityInstanceService, long processInstanceId, int pageIndex, int numberPerPage, String field, OrderByType order) {
        this.activityInstanceService = activityInstanceService;
        this.processInstanceId = processInstanceId;
        this.pageIndex = pageIndex;
        this.numberPerPage = numberPerPage;
        this.field = field;
        this.order = order;
    }

    @Override
    public void execute() throws SBonitaException {
        QueryOptions queryOptions = new QueryOptions(this.pageIndex * this.numberPerPage, this.numberPerPage, SAActivityInstance.class, this.field, this.order);
        this.archivedActivityInstances = this.activityInstanceService.getArchivedActivityInstances(this.processInstanceId, queryOptions);
    }

    @Override
    public List<SAActivityInstance> getResult() {
        return this.archivedActivityInstances;
    }
}

