/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.api.impl.transaction.process;

import java.util.ArrayList;
import java.util.List;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.commons.transaction.TransactionContentWithResult;
import org.bonitasoft.engine.core.category.CategoryService;

public class GetUncategorizedProcessIds
implements TransactionContentWithResult<List<Long>> {
    private final CategoryService categoryService;
    private final List<Long> processDefinitionIds;
    private final List<Long> uncategorizedProcessIds;

    public GetUncategorizedProcessIds(CategoryService categoryService, List<Long> processDefinitionIds) {
        this.categoryService = categoryService;
        this.processDefinitionIds = processDefinitionIds;
        this.uncategorizedProcessIds = new ArrayList<Long>(processDefinitionIds);
    }

    @Override
    public void execute() throws SBonitaException {
        List<Long> categorizedProcessIds = this.categoryService.getCategorizedProcessIds(this.processDefinitionIds);
        this.uncategorizedProcessIds.removeAll(categorizedProcessIds);
    }

    @Override
    public List<Long> getResult() {
        return this.uncategorizedProcessIds;
    }
}

