/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.archive.impl;

import org.bonitasoft.engine.archive.ArchiveInsertRecord;
import org.bonitasoft.engine.archive.ArchiveService;
import org.bonitasoft.engine.archive.ArchivingStrategy;
import org.bonitasoft.engine.archive.SArchiveDescriptor;
import org.bonitasoft.engine.archive.impl.BatchArchiveSynchronization;
import org.bonitasoft.engine.commons.ClassReflector;
import org.bonitasoft.engine.commons.LogUtil;
import org.bonitasoft.engine.log.technical.TechnicalLogSeverity;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;
import org.bonitasoft.engine.persistence.ArchivedPersistentObject;
import org.bonitasoft.engine.persistence.PersistentObject;
import org.bonitasoft.engine.persistence.ReadPersistenceService;
import org.bonitasoft.engine.recorder.SRecorderException;
import org.bonitasoft.engine.recorder.model.DeleteRecord;
import org.bonitasoft.engine.services.PersistenceService;
import org.bonitasoft.engine.services.SPersistenceException;
import org.bonitasoft.engine.transaction.STransactionNotFoundException;
import org.bonitasoft.engine.transaction.TransactionService;

public class ArchiveServiceImpl
implements ArchiveService {
    private final SArchiveDescriptor definitiveArchiveDescriptor;
    private final ThreadLocal<BatchArchiveSynchronization> synchronizations = new ThreadLocal();
    private final TransactionService transactionService;
    private final PersistenceService definitiveArchivePersistenceService;
    private final TechnicalLoggerService logger;
    private final ArchivingStrategy archivingStrategy;

    public ArchiveServiceImpl(SArchiveDescriptor definitiveArchiveDescriptor, PersistenceService definitiveArchivePersistenceService, TechnicalLoggerService logger, ArchivingStrategy archivingStrategy, TransactionService transactionService) {
        this.definitiveArchiveDescriptor = definitiveArchiveDescriptor;
        this.definitiveArchivePersistenceService = definitiveArchivePersistenceService;
        this.archivingStrategy = archivingStrategy;
        this.logger = logger;
        this.transactionService = transactionService;
    }

    @Override
    public void recordInsert(long time, ArchiveInsertRecord record) throws SRecorderException {
        if (this.isArchivable(record.getEntity().getPersistentObjectInterface())) {
            block5: {
                if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                    this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "recordInsert"));
                }
                ArchivedPersistentObject entity = record.getEntity();
                this.setArchiveDate(entity, time);
                try {
                    BatchArchiveSynchronization synchro = this.getBatchArchiveSynchronization();
                    synchro.addArchivedObject(entity);
                }
                catch (STransactionNotFoundException e) {
                    if (!this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.ERROR)) break block5;
                    this.logger.log(this.getClass(), TechnicalLogSeverity.ERROR, "Unable to register synchronization for the archives : transaction not found", e);
                }
            }
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "recordInsert"));
            }
        }
    }

    @Override
    public void recordInserts(long time, ArchiveInsertRecord ... records) throws SRecorderException {
        block5: {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "recordInsert"));
            }
            try {
                BatchArchiveSynchronization synchro = this.getBatchArchiveSynchronization();
                for (ArchiveInsertRecord record : records) {
                    ArchivedPersistentObject entity = record.getEntity();
                    this.setArchiveDate(entity, time);
                    synchro.addArchivedObject(entity);
                }
            }
            catch (STransactionNotFoundException e) {
                if (!this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) break block5;
                this.logger.log(this.getClass(), TechnicalLogSeverity.ERROR, "Unable to register synchronization to log queriable logs: transaction not found", e);
            }
        }
        if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "recordInsert"));
        }
    }

    private synchronized BatchArchiveSynchronization getBatchArchiveSynchronization() throws STransactionNotFoundException {
        BatchArchiveSynchronization synchro = this.synchronizations.get();
        if (synchro == null) {
            synchro = new BatchArchiveSynchronization(this.definitiveArchivePersistenceService);
            this.transactionService.registerBonitaSynchronization(synchro);
        }
        return synchro;
    }

    private void setArchiveDate(ArchivedPersistentObject entity, long time) throws SRecorderException {
        if (entity.getArchiveDate() <= 0L) {
            try {
                ClassReflector.invokeSetter(entity, "setArchiveDate", Long.TYPE, time);
            }
            catch (Exception e) {
                throw new SRecorderException(e);
            }
        }
    }

    @Override
    public void recordDelete(DeleteRecord record) throws SRecorderException {
        try {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogBeforeMethod(this.getClass(), "recordDelete"));
            }
            this.definitiveArchivePersistenceService.delete(record.getEntity());
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogAfterMethod(this.getClass(), "recordDelete"));
            }
        }
        catch (SPersistenceException e) {
            if (this.logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE)) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, LogUtil.getLogOnExceptionMethod(this.getClass(), "recordDelete", e));
            }
            throw new SRecorderException(e);
        }
    }

    @Override
    public SArchiveDescriptor getDefinitiveArchiveDescriptor() {
        return this.definitiveArchiveDescriptor;
    }

    @Override
    public boolean isArchivable(Class<? extends PersistentObject> sourceObjectClass) {
        return this.archivingStrategy.isArchivable(sourceObjectClass);
    }

    @Override
    public ReadPersistenceService getDefinitiveArchiveReadPersistenceService() {
        return this.definitiveArchivePersistenceService;
    }
}

