/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.core.platform.login.impl;

import org.bonitasoft.engine.core.platform.login.PlatformLoginService;
import org.bonitasoft.engine.core.platform.login.SPlatformLoginException;
import org.bonitasoft.engine.platform.authentication.PlatformAuthenticationService;
import org.bonitasoft.engine.platform.authentication.SInvalidPasswordException;
import org.bonitasoft.engine.platform.authentication.SInvalidUserException;
import org.bonitasoft.engine.platform.session.PlatformSessionService;
import org.bonitasoft.engine.platform.session.SSessionException;
import org.bonitasoft.engine.platform.session.SSessionNotFoundException;
import org.bonitasoft.engine.platform.session.model.SPlatformSession;

public class PlatformLoginServiceImpl
implements PlatformLoginService {
    private final PlatformAuthenticationService authenticationService;
    private final PlatformSessionService sessionService;

    public PlatformLoginServiceImpl(PlatformAuthenticationService platformAuthenticationService, PlatformSessionService platformSessionService) {
        this.authenticationService = platformAuthenticationService;
        this.sessionService = platformSessionService;
    }

    @Override
    public SPlatformSession login(String userName, String password) throws SPlatformLoginException {
        try {
            this.authenticationService.checkUserCredentials(userName, password);
            return this.sessionService.createSession(userName);
        }
        catch (SInvalidUserException e) {
            throw new SPlatformLoginException(e);
        }
        catch (SInvalidPasswordException e) {
            throw new SPlatformLoginException(e);
        }
        catch (SSessionException e) {
            throw new SPlatformLoginException(e);
        }
    }

    @Override
    public void logout(long sessionId) throws SSessionNotFoundException {
        this.sessionService.deleteSession(sessionId);
    }

    @Override
    public boolean isValid(long sessionId) {
        try {
            return this.sessionService.isValid(sessionId);
        }
        catch (SSessionNotFoundException ssnfe) {
            return false;
        }
    }
}

