/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.dependency.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bonitasoft.engine.classloader.ClassLoaderException;
import org.bonitasoft.engine.classloader.ClassLoaderService;
import org.bonitasoft.engine.commons.NullCheckingUtil;
import org.bonitasoft.engine.dependency.ArtifactAccessor;
import org.bonitasoft.engine.dependency.DependencyService;
import org.bonitasoft.engine.dependency.SDependencyCreationException;
import org.bonitasoft.engine.dependency.SDependencyDeletionException;
import org.bonitasoft.engine.dependency.SDependencyException;
import org.bonitasoft.engine.dependency.SDependencyMappingNotFoundException;
import org.bonitasoft.engine.dependency.SDependencyNotFoundException;
import org.bonitasoft.engine.dependency.model.SDependency;
import org.bonitasoft.engine.dependency.model.SDependencyMapping;
import org.bonitasoft.engine.dependency.model.ScopeType;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;
import org.bonitasoft.engine.persistence.QueryOptions;
import org.bonitasoft.engine.persistence.SBonitaReadException;
import org.bonitasoft.engine.persistence.SelectByIdDescriptor;
import org.bonitasoft.engine.persistence.SelectListDescriptor;
import org.bonitasoft.engine.persistence.SelectOneDescriptor;
import org.bonitasoft.engine.recorder.model.EntityUpdateDescriptor;
import org.bonitasoft.engine.services.PersistenceService;
import org.bonitasoft.engine.services.SPersistenceException;
import org.bonitasoft.engine.services.UpdateDescriptor;

public class PlatformDependencyServiceImpl
implements DependencyService {
    private final PersistenceService platformPersistenceService;
    private final ClassLoaderService classLoaderService;
    private final Map<String, Long> lastUpdates = Collections.synchronizedMap(new HashMap());

    public PlatformDependencyServiceImpl(PersistenceService platformPersistenceService, TechnicalLoggerService logger, ClassLoaderService classLoaderService) {
        this.platformPersistenceService = platformPersistenceService;
        this.classLoaderService = classLoaderService;
    }

    @Override
    public void createDependency(SDependency dependency) throws SDependencyCreationException {
        NullCheckingUtil.checkArgsNotNull(dependency);
        try {
            this.platformPersistenceService.insert(dependency);
        }
        catch (SPersistenceException pe) {
            throw new SDependencyCreationException(pe);
        }
    }

    @Override
    public void deleteDependency(long id) throws SDependencyNotFoundException, SDependencyDeletionException {
        SDependency dependency = this.getDependency(id);
        this.deleteDependency(dependency);
    }

    @Override
    public void deleteDependency(SDependency dependency) throws SDependencyDeletionException {
        try {
            this.platformPersistenceService.delete(dependency);
        }
        catch (SPersistenceException pe) {
            throw new SDependencyDeletionException(pe);
        }
    }

    @Override
    public void deleteDependency(String name) throws SDependencyNotFoundException, SDependencyDeletionException {
        SDependency dependency = this.getDependency(name);
        this.deleteDependency(dependency);
    }

    @Override
    public void deleteAllDependencies() throws SDependencyDeletionException {
        QueryOptions queryOptions = QueryOptions.defaultQueryOptions();
        List<SDependency> dependencies = null;
        do {
            try {
                dependencies = this.getDependencies(queryOptions);
            }
            catch (SDependencyException e) {
                throw new SDependencyDeletionException(e);
            }
            for (SDependency dependency : dependencies) {
                this.deleteDependency(dependency);
            }
        } while (dependencies.size() == queryOptions.getNumberOfResults());
    }

    @Override
    public void updateDependency(SDependency dependency, EntityUpdateDescriptor descriptor) throws SDependencyException {
        UpdateDescriptor desc = new UpdateDescriptor(dependency);
        desc.addFields(descriptor.getFields());
        try {
            this.platformPersistenceService.update(desc);
            QueryOptions queryOptions = QueryOptions.defaultQueryOptions();
            List<SDependencyMapping> dependencyMappings = null;
            long updateTimeStamp = System.currentTimeMillis();
            do {
                dependencyMappings = this.getDependencyMappings(dependency.getId(), queryOptions);
                for (SDependencyMapping dependencyMapping : dependencyMappings) {
                    this.lastUpdates.put(this.getKey(dependencyMapping.getArtifactType(), dependencyMapping.getArtifactId()), updateTimeStamp);
                }
                queryOptions = QueryOptions.getNextPage(queryOptions);
            } while (dependencyMappings.size() == queryOptions.getNumberOfResults());
        }
        catch (SPersistenceException pe) {
            throw new SDependencyException(pe);
        }
        this.refreshClassLoader();
    }

    @Override
    public SDependency getDependency(long id) throws SDependencyNotFoundException {
        SelectByIdDescriptor<SDependency> selectByIdDescriptor = new SelectByIdDescriptor<SDependency>("getPlatformDependencyById", SDependency.class, id);
        try {
            SDependency sDependency = this.platformPersistenceService.selectById(selectByIdDescriptor);
            if (sDependency == null) {
                throw new SDependencyNotFoundException("No dependency exists using id: " + id);
            }
            return sDependency;
        }
        catch (SBonitaReadException bre) {
            throw new SDependencyNotFoundException(bre);
        }
    }

    private SDependency getDependency(String name) throws SDependencyNotFoundException {
        Map<String, Object> parameters = Collections.singletonMap("name", name);
        try {
            SDependency sDependency = (SDependency)this.platformPersistenceService.selectOne(new SelectOneDescriptor("getPlatformDependencyByName", parameters, SDependency.class));
            if (sDependency == null) {
                throw new SDependencyNotFoundException("No dependency exists using name: " + name);
            }
            return sDependency;
        }
        catch (SBonitaReadException bre) {
            throw new SDependencyNotFoundException(bre);
        }
    }

    @Override
    public List<SDependency> getDependencies(QueryOptions queryOptions) throws SDependencyException {
        Map<String, Object> parameters = Collections.emptyMap();
        try {
            List<SDependency> dependencies = this.platformPersistenceService.selectList(new SelectListDescriptor("getPlatformDependencies", parameters, SDependency.class, queryOptions));
            return dependencies;
        }
        catch (SBonitaReadException bre) {
            throw new SDependencyException(bre);
        }
    }

    @Override
    public List<SDependency> getDependencies(Collection<Long> ids) throws SDependencyException {
        Map<String, Object> parameters = Collections.singletonMap("ids", ids);
        try {
            List<SDependency> dependencies = this.platformPersistenceService.selectList(new SelectListDescriptor("getPlatformDependenciesById", parameters, SDependency.class));
            return dependencies;
        }
        catch (SBonitaReadException bre) {
            throw new SDependencyException(bre);
        }
    }

    @Override
    public void createDependencyMapping(SDependencyMapping dependencyMapping) throws SDependencyException {
        try {
            this.platformPersistenceService.insert(dependencyMapping);
            this.lastUpdates.put(this.getKey(dependencyMapping.getArtifactType(), dependencyMapping.getArtifactId()), System.currentTimeMillis());
            this.refreshClassLoader();
        }
        catch (SPersistenceException pe) {
            throw new SDependencyException(pe);
        }
    }

    @Override
    public void deleteDependencyMapping(long id) throws SDependencyException, SDependencyMappingNotFoundException {
        SDependencyMapping dependencyMapping = this.getDependencyMapping(id);
        this.deleteDependencyMapping(dependencyMapping);
    }

    @Override
    public void deleteDependencyMapping(SDependencyMapping dependencyMapping) throws SDependencyException {
        try {
            this.platformPersistenceService.delete(dependencyMapping);
            this.lastUpdates.put(this.getKey(dependencyMapping.getArtifactType(), dependencyMapping.getArtifactId()), System.currentTimeMillis());
            this.refreshClassLoader();
        }
        catch (SPersistenceException pe) {
            throw new SDependencyException(pe);
        }
    }

    @Override
    public void deleteAllDependencyMappings() throws SDependencyException {
        QueryOptions queryOptions = QueryOptions.defaultQueryOptions();
        List<SDependencyMapping> dependencyMappings = null;
        do {
            dependencyMappings = this.getDependencyMappings(queryOptions);
            for (SDependencyMapping dependencyMapping : dependencyMappings) {
                this.deleteDependencyMapping(dependencyMapping);
            }
        } while (dependencyMappings.size() == queryOptions.getNumberOfResults());
    }

    @Override
    public void updateDependencyMapping(SDependencyMapping dependencyMapping, EntityUpdateDescriptor descriptor) throws SDependencyException {
        UpdateDescriptor desc = new UpdateDescriptor(dependencyMapping);
        desc.addFields(descriptor.getFields());
        try {
            this.platformPersistenceService.update(desc);
            this.lastUpdates.put(this.getKey(dependencyMapping.getArtifactType(), dependencyMapping.getArtifactId()), System.currentTimeMillis());
            this.refreshClassLoader();
        }
        catch (SPersistenceException pe) {
            throw new SDependencyException(pe);
        }
    }

    @Override
    public SDependencyMapping getDependencyMapping(long id) throws SDependencyMappingNotFoundException {
        SelectByIdDescriptor<SDependencyMapping> selectByIdDescriptor = new SelectByIdDescriptor<SDependencyMapping>("getPlatformDependencyMappingById", SDependencyMapping.class, id);
        try {
            SDependencyMapping sDependency = this.platformPersistenceService.selectById(selectByIdDescriptor);
            if (sDependency == null) {
                throw new SDependencyMappingNotFoundException("No dependency mapping exists using id: " + id);
            }
            return sDependency;
        }
        catch (SBonitaReadException bre) {
            throw new SDependencyMappingNotFoundException(bre);
        }
    }

    @Override
    public List<SDependencyMapping> getDependencyMappings(QueryOptions queryOptions) throws SDependencyException {
        try {
            return this.platformPersistenceService.selectList(new SelectListDescriptor("getPlatformDependencyMappings", null, SDependencyMapping.class, queryOptions));
        }
        catch (SBonitaReadException e) {
            throw new SDependencyException("can't get dependency mappings", e);
        }
    }

    @Override
    public List<SDependencyMapping> getDependencyMappings(long artifactId, ScopeType artifactType, QueryOptions queryOptions) throws SDependencyException {
        try {
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("artifactId", artifactId);
            parameters.put("artifactType", (Object)artifactType);
            SelectListDescriptor desc = new SelectListDescriptor("getPlatformDependencyMappingsByArtifact", parameters, SDependencyMapping.class, queryOptions);
            return this.platformPersistenceService.selectList(desc);
        }
        catch (SBonitaReadException e) {
            throw new SDependencyException("can't get dependency mappings by artifact: " + (Object)((Object)artifactType) + ", " + artifactId, e);
        }
    }

    @Override
    public List<SDependencyMapping> getDependencyMappings(long dependencyId, QueryOptions queryOptions) throws SDependencyException {
        try {
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("dependencyId", dependencyId);
            SelectListDescriptor desc = new SelectListDescriptor("getPlatformDependencyMappingsByDependency", parameters, SDependencyMapping.class, queryOptions);
            return this.platformPersistenceService.selectList(desc);
        }
        catch (SBonitaReadException e) {
            throw new SDependencyException("can't get dependency mappings by dependencyId: " + dependencyId, e);
        }
    }

    @Override
    public List<Long> getDependencyIds(long artifactId, ScopeType artifactType, QueryOptions queryOptions) throws SDependencyException {
        try {
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("artifactId", artifactId);
            parameters.put("artifactType", (Object)artifactType);
            SelectListDescriptor<Long> desc = new SelectListDescriptor<Long>("getPlatformDependencyIds", parameters, SDependency.class, Long.class, queryOptions);
            return this.platformPersistenceService.selectList(desc);
        }
        catch (SBonitaReadException e) {
            throw new SDependencyException(e);
        }
    }

    @Override
    public long getLastUpdatedTimestamp(ScopeType artifactType, long artifactId) {
        String key = this.getKey(artifactType, artifactId);
        if (this.lastUpdates.containsKey(key)) {
            return this.lastUpdates.get(key);
        }
        return 0L;
    }

    @Override
    public List<SDependencyMapping> removeDisconnectedDependencyMappings(ArtifactAccessor artifactAccessor) throws SDependencyException {
        QueryOptions loopQueryOptions = QueryOptions.defaultQueryOptions();
        List<SDependencyMapping> dependencyMappings = null;
        ArrayList<SDependencyMapping> result = new ArrayList<SDependencyMapping>();
        do {
            dependencyMappings = this.getDependencyMappings(loopQueryOptions);
            for (SDependencyMapping dependencyMapping : dependencyMappings) {
                if (artifactAccessor.artifactExists(dependencyMapping.getArtifactType(), dependencyMapping.getArtifactId())) continue;
                result.add(dependencyMapping);
                this.deleteDependencyMapping(dependencyMapping);
            }
            loopQueryOptions = QueryOptions.getNextPage(loopQueryOptions);
        } while (dependencyMappings.size() == loopQueryOptions.getNumberOfResults());
        return result;
    }

    @Override
    public List<SDependencyMapping> getDisconnectedDependencyMappings(ArtifactAccessor artifactAccessor, QueryOptions queryOptions) throws SDependencyException {
        QueryOptions loopQueryOptions = new QueryOptions(queryOptions.getFromIndex(), queryOptions.getNumberOfResults(), queryOptions.getOrderByOptions());
        List<SDependencyMapping> dependencyMappings = null;
        ArrayList<SDependencyMapping> result = new ArrayList<SDependencyMapping>();
        int numberOfResultsFound = 0;
        int startIndex = queryOptions.getFromIndex();
        do {
            dependencyMappings = this.getDependencyMappings(loopQueryOptions);
            for (SDependencyMapping dependencyMapping : dependencyMappings) {
                if (artifactAccessor.artifactExists(dependencyMapping.getArtifactType(), dependencyMapping.getArtifactId())) continue;
                if (++numberOfResultsFound > startIndex) {
                    result.add(dependencyMapping);
                }
                if (result.size() != queryOptions.getNumberOfResults()) continue;
                break;
            }
            loopQueryOptions = QueryOptions.getNextPage(loopQueryOptions);
        } while (dependencyMappings.size() == loopQueryOptions.getNumberOfResults() && result.size() < queryOptions.getNumberOfResults());
        return result;
    }

    private String getKey(ScopeType scopeType, long artifactId) {
        StringBuffer sb = new StringBuffer(scopeType.name());
        sb.append("________");
        sb.append(artifactId);
        return sb.toString();
    }

    @Override
    public void deleteDependencies(long id, ScopeType type) throws SDependencyException, SDependencyNotFoundException, SDependencyDeletionException {
        List<Long> dependencyIds;
        QueryOptions queryOptions = QueryOptions.defaultQueryOptions();
        ArrayList<Long> allDependencyIds = new ArrayList<Long>();
        do {
            dependencyIds = this.getDependencyIds(id, type, queryOptions);
            allDependencyIds.addAll(dependencyIds);
            queryOptions = QueryOptions.getNextPage(queryOptions);
        } while (dependencyIds.size() == 20);
        for (Long dependencyId : allDependencyIds) {
            List<SDependencyMapping> dependencyMappings = this.getDependencyMappings(dependencyId, QueryOptions.defaultQueryOptions());
            if (dependencyMappings.size() != 1) continue;
            this.deleteDependencyMapping(dependencyMappings.get(0));
            this.deleteDependency(dependencyId);
        }
    }

    private void refreshClassLoader() throws SDependencyException {
        this.refreshClassLoader(ScopeType.valueOf(this.classLoaderService.getGlobalClassLoaderType()), this.classLoaderService.getGlobalClassLoaderId());
    }

    @Override
    public void refreshClassLoader(ScopeType type, long id) throws SDependencyException {
        Map<String, byte[]> resources = this.getDependenciesResources();
        try {
            this.classLoaderService.refreshGlobalClassLoader(resources);
        }
        catch (ClassLoaderException e) {
            throw new SDependencyException("can't refresh global classLoader", e);
        }
    }

    private Map<String, byte[]> getDependenciesResources() throws SDependencyException {
        HashMap<String, byte[]> resources = new HashMap<String, byte[]>();
        int fromIndex = 0;
        int pageSize = 20;
        List<Long> dependencyIds = null;
        do {
            QueryOptions queryOptions = new QueryOptions(fromIndex, 20);
            dependencyIds = this.getDependencyIds(this.classLoaderService.getGlobalClassLoaderId(), ScopeType.valueOf(this.classLoaderService.getGlobalClassLoaderType()), queryOptions);
            if (dependencyIds != null && dependencyIds.size() > 0) {
                List<SDependency> dependencies = this.getDependencies(dependencyIds);
                for (SDependency dependency : dependencies) {
                    resources.put(dependency.getFileName(), dependency.getValue());
                }
            }
            fromIndex += 20;
        } while (dependencyIds.size() == 20);
        return resources;
    }

    @Override
    public void updateDependenciesOfArtifact(long id, ScopeType type, ArrayList<SDependency> dependencies) throws SDependencyException {
        throw new UnsupportedOperationException("only one artifact at platform level, no need to update in batch all dependencies");
    }
}

