/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.execution;

import java.util.ArrayList;
import java.util.List;
import org.bonitasoft.engine.core.process.definition.model.SFlowElementContainerDefinition;
import org.bonitasoft.engine.core.process.definition.model.SFlowNodeDefinition;
import org.bonitasoft.engine.core.process.definition.model.SProcessDefinition;
import org.bonitasoft.engine.core.process.definition.model.SSubProcessDefinition;
import org.bonitasoft.engine.execution.Filter;

public class FlowNodeSelector {
    private Filter<SFlowNodeDefinition> selector;
    private SProcessDefinition definition;
    private long subProcessDefinitionId = -1L;

    public FlowNodeSelector(SProcessDefinition definition, Filter<SFlowNodeDefinition> filter) {
        this.definition = definition;
        this.selector = filter;
    }

    public FlowNodeSelector(SProcessDefinition definition, Filter<SFlowNodeDefinition> filter, long subProcessDefinitionId) {
        this(definition, filter);
        this.subProcessDefinitionId = subProcessDefinitionId;
    }

    public List<SFlowNodeDefinition> getFilteredElements() {
        SFlowElementContainerDefinition container = this.getContainer();
        ArrayList<SFlowNodeDefinition> selectedFlowNodes = new ArrayList<SFlowNodeDefinition>();
        for (SFlowNodeDefinition flowNodeDefinition : container.getFlowNodes()) {
            if (!this.selector.select(flowNodeDefinition)) continue;
            selectedFlowNodes.add(flowNodeDefinition);
        }
        return selectedFlowNodes;
    }

    public SFlowElementContainerDefinition getContainer() {
        if (this.subProcessDefinitionId == -1L) {
            return this.definition.getProcessContainer();
        }
        SSubProcessDefinition subProcDef = (SSubProcessDefinition)this.definition.getProcessContainer().getFlowNode(this.subProcessDefinitionId);
        return subProcDef.getSubProcessContainer();
    }

    public SProcessDefinition getProcessDefinition() {
        return this.definition;
    }

    public long getSubProcessDefinitionId() {
        return this.subProcessDefinitionId;
    }
}

