/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.expression;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.bonitasoft.engine.bpm.document.Document;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.core.process.document.api.ProcessDocumentService;
import org.bonitasoft.engine.core.process.document.model.SProcessDocument;
import org.bonitasoft.engine.core.process.instance.api.FlowNodeInstanceService;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SFlowNodeNotFoundException;
import org.bonitasoft.engine.core.process.instance.api.exceptions.SFlowNodeReadException;
import org.bonitasoft.engine.data.instance.api.DataInstanceContainer;
import org.bonitasoft.engine.document.SDocumentNotFoundException;
import org.bonitasoft.engine.expression.NonEmptyContentExpressionExecutorStrategy;
import org.bonitasoft.engine.expression.exception.SExpressionDependencyMissingException;
import org.bonitasoft.engine.expression.exception.SExpressionEvaluationException;
import org.bonitasoft.engine.expression.model.ExpressionKind;
import org.bonitasoft.engine.expression.model.SExpression;
import org.bonitasoft.engine.service.ModelConvertor;

public class DocumentReferenceExpressionExecutorStrategy
extends NonEmptyContentExpressionExecutorStrategy {
    private final ProcessDocumentService processDocumentService;
    private final FlowNodeInstanceService flowNodeInstanceService;

    public DocumentReferenceExpressionExecutorStrategy(ProcessDocumentService processDocumentService, FlowNodeInstanceService flowNodeInstanceService) {
        this.processDocumentService = processDocumentService;
        this.flowNodeInstanceService = flowNodeInstanceService;
    }

    @Override
    public Object evaluate(SExpression expression, Map<String, Object> dependencyValues, Map<Integer, Object> resolvedExpressions) throws SExpressionEvaluationException {
        return this.evaluate(Collections.singletonList(expression), dependencyValues, resolvedExpressions).get(0);
    }

    @Override
    public ExpressionKind getExpressionKind() {
        return KIND_DOCUMENT;
    }

    @Override
    public List<Object> evaluate(List<SExpression> expressions, Map<String, Object> dependencyValues, Map<Integer, Object> resolvedExpressions) throws SExpressionEvaluationException {
        try {
            Long containerId = (Long)dependencyValues.get("containerId");
            String containerType = (String)dependencyValues.get("containerType");
            Long time = (Long)dependencyValues.get("time");
            long processInstanceId = this.getProcessInstance(containerId, containerType);
            ArrayList<Object> results = new ArrayList<Object>(expressions.size());
            for (SExpression expression : expressions) {
                results.add(this.getDocument(processInstanceId, expression, time));
            }
            return results;
        }
        catch (SBonitaException e) {
            throw new SExpressionEvaluationException(e);
        }
    }

    private Document getDocument(long processInstanceId, SExpression expression, Long time) {
        try {
            SProcessDocument document = time != null ? this.processDocumentService.getDocument(processInstanceId, expression.getContent(), time) : this.processDocumentService.getDocument(processInstanceId, expression.getContent());
            return ModelConvertor.toDocument(document);
        }
        catch (SDocumentNotFoundException e) {
            return null;
        }
    }

    private long getProcessInstance(Long containerId, String containerType) throws SFlowNodeNotFoundException, SFlowNodeReadException, SExpressionDependencyMissingException {
        if (containerId == null || containerType == null) {
            throw new SExpressionDependencyMissingException("the context to retrieve the document is not set");
        }
        if (DataInstanceContainer.PROCESS_INSTANCE.name().equals(containerType)) {
            return containerId;
        }
        return this.flowNodeInstanceService.getFlowNodeInstance(containerId).getParentProcessInstanceId();
    }

    @Override
    public boolean mustPutEvaluatedExpressionInContext() {
        return true;
    }
}

