/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.external.identitymapping;

import java.io.Serializable;
import java.util.Map;
import org.bonitasoft.engine.command.SCommandParameterizationException;
import org.bonitasoft.engine.command.system.CommandWithParameters;
import org.bonitasoft.engine.identity.MemberType;

public abstract class MemberCommand
extends CommandWithParameters {
    protected MemberType getMemberType(Long userId, Long groupId, Long roleId) throws SCommandParameterizationException {
        MemberType memberType = null;
        if (userId != null) {
            memberType = MemberType.USER;
        } else if (groupId != null && roleId == null) {
            memberType = MemberType.GROUP;
        } else if (roleId != null && groupId == null) {
            memberType = MemberType.ROLE;
        } else if (roleId != null && groupId != null) {
            memberType = MemberType.MEMBERSHIP;
        } else {
            StringBuilder stb = new StringBuilder("Parameters map must contain at least one of entries: ");
            stb.append("userId");
            stb.append(", ");
            stb.append("groupId");
            stb.append(", ");
            stb.append("roleId");
            throw new SCommandParameterizationException(stb.toString());
        }
        return memberType;
    }

    protected Long getProfileIdParameter(Map<String, Serializable> parameters) throws SCommandParameterizationException {
        return this.getLongMandadoryParameter(parameters, "profileId");
    }

    protected Long getUserIdParameter(Map<String, Serializable> parameters) throws SCommandParameterizationException {
        String message = "Error while retrieving the parameter userId (long value).";
        return (Long)this.getParameter(parameters, "userId", "Error while retrieving the parameter userId (long value).");
    }

    protected Long getGroupIdParameter(Map<String, Serializable> parameters) throws SCommandParameterizationException {
        String message = "Error while retrieving the parameter groupId (long value).";
        return (Long)this.getParameter(parameters, "groupId", "Error while retrieving the parameter groupId (long value).");
    }

    protected Long getRoleIdParameter(Map<String, Serializable> parameters) throws SCommandParameterizationException {
        String message = "Error while retrieving the parameter roleId (long value).";
        return (Long)this.getParameter(parameters, "roleId", "Error while retrieving the parameter roleId (long value).");
    }

    protected String getQuerySuffix(MemberType memberType) {
        String suffix = null;
        switch (memberType) {
            case USER: {
                suffix = "ForUser";
                break;
            }
            case GROUP: {
                suffix = "ForGroup";
                break;
            }
            case ROLE: {
                suffix = "ForRole";
                break;
            }
            case MEMBERSHIP: {
                suffix = "ForRoleAndGroup";
            }
        }
        return suffix;
    }
}

