/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.external.web.profile.command;

import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import java.util.List;
import java.util.Map;
import org.bonitasoft.engine.api.impl.SessionInfos;
import org.bonitasoft.engine.api.impl.transaction.profile.DeleteAllExistingProfiles;
import org.bonitasoft.engine.api.impl.transaction.profile.ImportProfiles;
import org.bonitasoft.engine.command.SCommandExecutionException;
import org.bonitasoft.engine.command.SCommandParameterizationException;
import org.bonitasoft.engine.command.TenantCommand;
import org.bonitasoft.engine.commons.exceptions.SBonitaException;
import org.bonitasoft.engine.identity.IdentityService;
import org.bonitasoft.engine.profile.ProfileService;
import org.bonitasoft.engine.profile.impl.ExportedProfile;
import org.bonitasoft.engine.service.TenantServiceAccessor;
import org.bonitasoft.engine.xml.Parser;
import org.bonitasoft.engine.xml.SValidationException;
import org.bonitasoft.engine.xml.SXMLParseException;

public class ImportProfilesCommand
extends TenantCommand {
    @Override
    public Serializable execute(Map<String, Serializable> parameters, TenantServiceAccessor serviceAccessor) throws SCommandParameterizationException, SCommandExecutionException {
        ProfileService profileService = serviceAccessor.getProfileService();
        IdentityService identityService = serviceAccessor.getIdentityService();
        byte[] xmlContent = null;
        try {
            xmlContent = (byte[])parameters.get("xmlContent");
            if (xmlContent == null) {
                throw new SCommandParameterizationException("Parameters map must contain an entry  xmlContent with a byte array value.");
            }
        }
        catch (Exception e) {
            throw new SCommandParameterizationException("Parameters map must contain an entry  xmlContent with a byte array value.", e);
        }
        Parser parser = serviceAccessor.getProfileParser();
        List<ExportedProfile> profiles = this.getProfilesFromXML(new String(xmlContent), parser);
        return (Serializable)((Object)this.importWithDeleteExisting(profileService, identityService, profiles));
    }

    private List<String> importWithDeleteExisting(ProfileService profileService, IdentityService identityService, List<ExportedProfile> profiles) throws SCommandExecutionException {
        DeleteAllExistingProfiles deleteAll = new DeleteAllExistingProfiles(profileService);
        try {
            deleteAll.execute();
        }
        catch (SBonitaException e) {
            throw new SCommandExecutionException(e);
        }
        ImportProfiles importProfiles = new ImportProfiles(profileService, identityService, profiles, SessionInfos.getUserIdFromSession());
        try {
            importProfiles.execute();
        }
        catch (SBonitaException e) {
            throw new SCommandExecutionException(e);
        }
        return importProfiles.getResult();
    }

    private List<ExportedProfile> getProfilesFromXML(String xmlContent, Parser parser) throws SCommandExecutionException {
        StringReader reader = new StringReader(xmlContent);
        try {
            parser.validate(reader);
            reader.close();
            reader = new StringReader(xmlContent);
            List list = (List)parser.getObjectFromXML(reader);
            return list;
        }
        catch (IOException ioe) {
            throw new SCommandExecutionException(ioe);
        }
        catch (SValidationException e) {
            throw new SCommandExecutionException(e);
        }
        catch (SXMLParseException e) {
            throw new SCommandExecutionException(e);
        }
        finally {
            reader.close();
        }
    }
}

