/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine.lock.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.bonitasoft.engine.lock.BonitaLock;
import org.bonitasoft.engine.lock.LockService;
import org.bonitasoft.engine.lock.SLockException;
import org.bonitasoft.engine.log.technical.TechnicalLogSeverity;
import org.bonitasoft.engine.log.technical.TechnicalLoggerService;

public class MemoryLockService
implements LockService {
    protected static final String SEPARATOR = "_";
    private final Map<String, ReentrantLock> locks = Collections.synchronizedMap(new HashMap());
    protected final TechnicalLoggerService logger;
    protected final int lockTimeout;
    private final Map<Integer, Object> mutexs;
    protected final boolean debugEnable;
    private final boolean traceEnable;
    private final int lockPoolSize;

    public MemoryLockService(TechnicalLoggerService logger, int lockTimeout, int lockPoolSize) {
        this.logger = logger;
        this.lockTimeout = lockTimeout;
        this.debugEnable = logger.isLoggable(this.getClass(), TechnicalLogSeverity.DEBUG);
        this.traceEnable = logger.isLoggable(this.getClass(), TechnicalLogSeverity.TRACE);
        this.lockPoolSize = lockPoolSize;
        HashMap<Integer, Object> tmpMutexs = new HashMap<Integer, Object>();
        for (int i = 0; i < lockPoolSize; ++i) {
            tmpMutexs.put(i, new Object());
        }
        this.mutexs = Collections.unmodifiableMap(tmpMutexs);
    }

    private Object getMutex(long objectToLockId) {
        int poolKeyForThisObjectId = Long.valueOf(objectToLockId % (long)this.lockPoolSize).intValue();
        if (!this.mutexs.containsKey(poolKeyForThisObjectId)) {
            throw new RuntimeException("No mutex defined for objectToLockId '" + objectToLockId + "' with generated key '" + poolKeyForThisObjectId + "'");
        }
        return this.mutexs.get(poolKeyForThisObjectId);
    }

    protected ReentrantLock getLock(String key) {
        if (!this.locks.containsKey(key)) {
            this.locks.put(key, new ReentrantLock());
        }
        return this.locks.get(key);
    }

    protected ReentrantLock removeLockFromMapIfNotUsed(String key) {
        ReentrantLock reentrantLock = this.locks.get(key);
        if (reentrantLock != null && !reentrantLock.hasQueuedThreads()) {
            if (this.debugEnable) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.DEBUG, "removed from map " + reentrantLock.hashCode() + " id=" + key);
            }
            this.locks.remove(key);
        }
        return reentrantLock;
    }

    private String buildKey(long objectToLockId, String objectType, long tenantId) {
        return objectType + SEPARATOR + objectToLockId + SEPARATOR + tenantId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlock(BonitaLock lock, long tenantId) throws SLockException {
        String key = this.buildKey(lock.getObjectToLockId(), lock.getObjectType(), tenantId);
        if (this.traceEnable) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, "will unlock " + lock.getLock().hashCode() + " id=" + key);
        }
        Object object = this.getMutex(lock.getObjectToLockId());
        synchronized (object) {
            ReentrantLock removedLock = this.removeLockFromMapIfNotUsed(key);
            if (removedLock != lock.getLock()) {
                throw new IllegalStateException("The lock held by the BonitaLock and the one associated to the key do not match.");
            }
            lock.getLock().unlock();
            if (this.traceEnable) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, "unlock " + lock.getLock().hashCode() + " id=" + key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BonitaLock tryLock(long objectToLockId, String objectType, long timeout, TimeUnit timeUnit, long tenantId) {
        ReentrantLock lock;
        String key;
        block15: {
            key = this.buildKey(objectToLockId, objectType, tenantId);
            Object object = this.getMutex(objectToLockId);
            synchronized (object) {
                lock = this.getLock(key);
                if (this.traceEnable) {
                    this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, "tryLock " + lock.hashCode() + " id=" + key);
                }
                if (lock.isHeldByCurrentThread()) {
                    return null;
                }
            }
            try {
                if (!lock.tryLock(timeout, timeUnit)) break block15;
                if (this.traceEnable) {
                    this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, "locked " + lock.hashCode() + " id=" + key);
                }
                object = this.getMutex(objectToLockId);
                synchronized (object) {
                    ReentrantLock previousLock = this.locks.get(key);
                    if (previousLock == null) {
                        this.locks.put(key, lock);
                    } else if (previousLock != lock) {
                        lock.unlock();
                        return null;
                    }
                }
                return new BonitaLock(lock, objectType, objectToLockId);
            }
            catch (InterruptedException e) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.ERROR, "The trylock was interrupted " + lock.hashCode() + " id=" + key);
            }
        }
        if (this.traceEnable) {
            this.logger.log(this.getClass(), TechnicalLogSeverity.TRACE, "not locked " + lock.hashCode() + " id=" + key);
        }
        return null;
    }

    @Override
    public BonitaLock lock(long objectToLockId, String objectType, long tenantId) throws SLockException {
        BonitaLock lock = this.tryLock(objectToLockId, objectType, this.lockTimeout, TimeUnit.SECONDS, tenantId);
        if (lock == null) {
            throw new SLockException("Unable (default timeout) to acquire the lock for " + objectToLockId + ":" + objectType + this.getDetailsOnLock(objectToLockId, objectType, tenantId));
        }
        return lock;
    }

    private StringBuilder getDetailsOnLock(long objectToLockId, String objectType, long tenantId) {
        String key = this.buildKey(objectToLockId, objectType, tenantId);
        ReentrantLock reentrantLock = this.locks.get(key);
        StringBuilder details = new StringBuilder(", Details: ");
        if (reentrantLock == null) {
            details.append("The lock was removed from the locks map in the memory lock service");
        } else {
            details.append("The lock is locked ");
            details.append(reentrantLock.isLocked());
            details.append(", held by current thread ");
            details.append(reentrantLock.isHeldByCurrentThread());
            try {
                Thread thread = (Thread)reentrantLock.getClass().getDeclaredMethod("getOwner", new Class[0]).invoke((Object)reentrantLock, new Object[0]);
                details.append(", held by thread ");
                details.append(thread.getName());
            }
            catch (Exception e) {
                this.logger.log(this.getClass(), TechnicalLogSeverity.INFO, "Error while fetching details on lock for an exception", e);
            }
        }
        return details;
    }

    TechnicalLogSeverity selectSeverity(long time) {
        if (time > 150L) {
            return TechnicalLogSeverity.INFO;
        }
        if (time > 50L) {
            return TechnicalLogSeverity.DEBUG;
        }
        return null;
    }
}

