/**
 * Copyright (C) 2011 BonitaSoft S.A.
 * BonitaSoft, 32 rue Gustave Eiffel - 38000 Grenoble
 * This library is free software; you can redistribute it and/or modify it under the terms
 * of the GNU Lesser General Public License as published by the Free Software Foundation
 * version 2.1 of the License.
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License along with this
 * program; if not, write to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301, USA.
 **/
package org.bonitasoft.engine.data.model.impl;

import org.bonitasoft.engine.data.model.SDataSourceParameter;

public class SDataSourceParameterImpl implements SDataSourceParameter {

    private static final long serialVersionUID = 1L;

    private long id;

    private long tenantId;

    private long dataSourceId;

    private String name;

    private String value_;

    public SDataSourceParameterImpl() {
        super();
    }

    public SDataSourceParameterImpl(final long dataSourceId, final String name, final String value_) {
        super();
        this.dataSourceId = dataSourceId;
        this.name = name;
        this.value_ = value_;
    }

    public long getTenantId() {
        return tenantId;
    }

    public void setTenantId(final long tenantId) {
        this.tenantId = tenantId;
    }

    public void setId(final long id) {
        this.id = id;
    }

    @Override
    public long getId() {
        return id;
    }

    @Override
    public long getDataSourceId() {
        return dataSourceId;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public String getDiscriminator() {
        return SDataSourceParameter.class.getName();
    }

    @Override
    public String getValue_() {
        return value_;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + (int) (dataSourceId ^ (dataSourceId >>> 32));
        result = prime * result + (int) (id ^ (id >>> 32));
        result = prime * result + ((name == null) ? 0 : name.hashCode());
        result = prime * result + (int) (tenantId ^ (tenantId >>> 32));
        result = prime * result + ((value_ == null) ? 0 : value_.hashCode());
        return result;
    }

    @Override
    public boolean equals(final Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        final SDataSourceParameterImpl other = (SDataSourceParameterImpl) obj;
        if (dataSourceId != other.dataSourceId) {
            return false;
        }
        if (id != other.id) {
            return false;
        }
        if (name == null) {
            if (other.name != null) {
                return false;
            }
        } else if (!name.equals(other.name)) {
            return false;
        }
        if (tenantId != other.tenantId) {
            return false;
        }
        if (value_ == null) {
            if (other.value_ != null) {
                return false;
            }
        } else if (!value_.equals(other.value_)) {
            return false;
        }
        return true;
    }

}
