/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.engine;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.bonitasoft.engine.EngineInitializerProperties;
import org.bonitasoft.engine.PlatformTenantManager;
import org.bonitasoft.engine.api.PlatformAPI;
import org.bonitasoft.engine.api.impl.PlatformAPIImpl;
import org.bonitasoft.engine.exception.BonitaRuntimeException;
import org.bonitasoft.engine.platform.PlatformNotFoundException;
import org.bonitasoft.engine.platform.session.PlatformSessionService;
import org.bonitasoft.engine.platform.session.SSessionException;
import org.bonitasoft.engine.platform.session.SSessionNotFoundException;
import org.bonitasoft.engine.platform.session.model.SPlatformSession;
import org.bonitasoft.engine.service.PlatformServiceAccessor;
import org.bonitasoft.engine.service.impl.ServiceAccessorFactory;
import org.bonitasoft.engine.sessionaccessor.SessionAccessor;

public class EngineInitializer {
    private static final Logger LOGGER = Logger.getLogger(EngineInitializer.class.getName());
    private final PlatformTenantManager platformManager;
    private final EngineInitializerProperties platformProperties;

    public EngineInitializer(PlatformTenantManager platformManager, EngineInitializerProperties platformProperties) {
        this.platformManager = platformManager;
        this.platformProperties = platformProperties;
    }

    protected PlatformServiceAccessor getPlatformAccessor() {
        try {
            return ServiceAccessorFactory.getInstance().createPlatformServiceAccessor();
        }
        catch (Exception e) {
            throw new BonitaRuntimeException((Throwable)e);
        }
    }

    public static void init() throws Exception {
        new EngineInitializer(PlatformTenantManager.getInstance(), new EngineInitializerProperties()).initializeEngine();
    }

    public static void unload() throws Exception {
        new EngineInitializer(PlatformTenantManager.getInstance(), new EngineInitializerProperties()).unloadEngine();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeEngine() throws Exception {
        LOGGER.log(Level.INFO, "Initializing Bonita Engine...");
        long before = System.currentTimeMillis();
        LOGGER.log(Level.INFO, "Initializing Spring context...");
        PlatformServiceAccessor platformAccessor = this.getPlatformAccessor();
        PlatformSessionService platformSessionService = platformAccessor.getPlatformSessionService();
        SessionAccessor sessionAccessor = ServiceAccessorFactory.getInstance().createSessionAccessor();
        long sessionId = this.createPlatformSession(platformSessionService, sessionAccessor);
        PlatformAPIImpl platformAPI = this.createPlatformAPI();
        try {
            try {
                this.initPlatform(platformAPI);
            }
            catch (Exception e) {
                // empty catch block
            }
            this.startPlatform(platformAPI);
        }
        finally {
            this.deletePlatformSession(platformSessionService, sessionAccessor, sessionId);
        }
        long after = System.currentTimeMillis();
        LOGGER.log(Level.INFO, "Initialization of Bonita Engine done! ( took " + (after - before) + "ms)");
    }

    protected PlatformAPIImpl createPlatformAPI() {
        return new PlatformAPIImpl();
    }

    private void deletePlatformSession(PlatformSessionService platformSessionService, SessionAccessor sessionAccessor, long sessionId) throws SSessionNotFoundException {
        platformSessionService.deleteSession(sessionId);
        sessionAccessor.deleteSessionId();
    }

    private long createPlatformSession(PlatformSessionService platformSessionService, SessionAccessor sessionAccessor) throws SSessionException {
        SPlatformSession createSession = platformSessionService.createSession(this.platformProperties.getPlatformAdminUsername());
        long sessionId = createSession.getId();
        sessionAccessor.setSessionInfo(sessionId, -1L);
        return sessionId;
    }

    protected void initPlatform(PlatformAPI platformAPI) throws Exception {
        if (this.platformProperties.shouldCreatePlatform()) {
            LOGGER.log(Level.INFO, "Creating platform...");
            this.platformManager.createPlatform(platformAPI);
        }
    }

    protected void startPlatform(PlatformAPI platformAPI) throws Exception {
        if (this.platformProperties.shouldStartPlatform()) {
            LOGGER.log(Level.INFO, "Starting platform...");
            this.platformManager.startPlatform(platformAPI);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unloadEngine() throws Exception {
        LOGGER.log(Level.INFO, "Stopping Bonita Engine...");
        PlatformServiceAccessor platformAccessor = this.getPlatformAccessor();
        SessionAccessor sessionAccessor = ServiceAccessorFactory.getInstance().createSessionAccessor();
        PlatformSessionService platformSessionService = platformAccessor.getPlatformSessionService();
        long sessionId = this.createPlatformSession(platformSessionService, sessionAccessor);
        PlatformAPIImpl platformAPI = this.createPlatformAPI();
        try {
            if (this.platformProperties.shouldStopPlatform()) {
                this.platformManager.stopPlatform(platformAPI);
            }
        }
        catch (PlatformNotFoundException e) {
            LOGGER.log(Level.WARNING, "The platform cannot be stopped because it does not exist!");
        }
        finally {
            this.deletePlatformSession(platformSessionService, sessionAccessor, sessionId);
        }
        ServiceAccessorFactory.getInstance().destroyAccessors();
        LOGGER.log(Level.INFO, "Bonita Engine stopped!");
    }
}

